/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class ModelMinigun
extends Model {
    private final ModelPart barrel;
    private final ModelPart support1;
    private final ModelPart support2;
    private final ModelPart support3;
    private final ModelPart support4;
    private final ModelPart support5;
    private final ModelPart main;
    private final ModelPart magazine;
    private final ModelPart mount;
    private final ModelPart magazineColor;
    private static final String BARREL = "barrel";
    private static final String SUPPORT1 = "support1";
    private static final String SUPPORT2 = "support2";
    private static final String SUPPORT3 = "support3";
    private static final String SUPPORT4 = "support4";
    private static final String SUPPORT5 = "support5";
    private static final String MAIN = "main";
    private static final String MAGAZINE = "magazine";
    private static final String MOUNT = "mount";
    private static final String MOUNT_R1 = "mount_r1";
    private static final String MOUNT_R2 = "mount_r2";
    private static final String MAGAZINECOLOR = "magazineColor";

    public ModelMinigun(ModelPart root) {
        super(RenderType::m_110458_);
        this.barrel = root.m_171324_(BARREL);
        this.support1 = root.m_171324_(SUPPORT1);
        this.support2 = root.m_171324_(SUPPORT2);
        this.support3 = root.m_171324_(SUPPORT3);
        this.support4 = root.m_171324_(SUPPORT4);
        this.support5 = root.m_171324_(SUPPORT5);
        this.main = root.m_171324_(MAIN);
        this.magazine = root.m_171324_(MAGAZINE);
        this.mount = root.m_171324_(MOUNT);
        this.magazineColor = root.m_171324_(MAGAZINECOLOR);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(BARREL, CubeListBuilder.m_171558_().m_171514_(30, 15).m_171534_("barrel_0", -0.5f, 1.4333f, -4.0f, 1, 1, 20, 0, 3), PartPose.m_171419_((float)0.0f, (float)20.9667f, (float)-8.0f));
        partdefinition.m_171599_(SUPPORT1, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171534_("support1_0", -1.5f, -1.5f, -5.0f, 3, 3, 4, 22, 16).m_171534_("support1_1", -1.5f, -1.5f, 0.0f, 3, 3, 1, 0, 13).m_171534_("support1_2", -1.5f, -1.5f, 5.0f, 3, 3, 1, 0, 13).m_171534_("support1_3", -1.5f, -1.5f, 7.0f, 3, 3, 1, 0, 13).m_171534_("support1_4", -1.5f, -1.5f, 13.0f, 3, 3, 1, 0, 13), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)-6.0f));
        partdefinition.m_171599_(SUPPORT2, CubeListBuilder.m_171558_().m_171514_(0, 4).m_171534_("support2_0", -1.5f, 1.5f, -5.0f, 3, 1, 4, 22, 8).m_171534_("support2_1", -1.5f, 1.5f, 0.0f, 3, 1, 1, 0, 11).m_171534_("support2_2", -1.5f, 1.5f, 5.0f, 3, 1, 1, 0, 21).m_171534_("support2_3", -1.5f, 1.5f, 7.0f, 3, 1, 1, 0, 21).m_171534_("support2_4", -1.5f, 1.5f, 13.0f, 3, 1, 1, 0, 21), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)-6.0f));
        partdefinition.m_171599_(SUPPORT3, CubeListBuilder.m_171558_().m_171514_(0, 6).m_171534_("support3_0", -1.5f, -2.5f, -5.0f, 3, 1, 4, 22, 8).m_171534_("support3_1", -1.5f, -2.5f, 0.0f, 3, 1, 1, 0, 11).m_171534_("support3_2", -1.5f, -2.5f, 5.0f, 3, 1, 1, 0, 11).m_171534_("support3_3", -1.5f, -2.5f, 7.0f, 3, 1, 1, 0, 11).m_171534_("support3_4", -1.5f, -2.5f, 13.0f, 3, 1, 1, 0, 11), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)-6.0f));
        partdefinition.m_171599_(SUPPORT4, CubeListBuilder.m_171558_().m_171514_(0, 8).m_171534_("support4_0", 1.5f, -1.5f, -5.0f, 1, 3, 4, 22, 1).m_171534_("support4_1", 1.5f, -1.5f, 0.0f, 1, 3, 1, 0, 17).m_171534_("support4_2", 1.5f, -1.5f, 5.0f, 1, 3, 1, 4, 17).m_171534_("support4_3", 1.5f, -1.5f, 7.0f, 1, 3, 1, 4, 17).m_171534_("support4_4", 1.5f, -1.5f, 13.0f, 1, 3, 1, 4, 17), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)-6.0f));
        partdefinition.m_171599_(SUPPORT5, CubeListBuilder.m_171558_().m_171514_(0, 11).m_171534_("support5_0", -2.5f, -1.5f, -5.0f, 1, 3, 4, 32, 1).m_171534_("support5_1", -2.5f, -1.5f, 0.0f, 1, 3, 1, 0, 17).m_171534_("support5_2", -2.5f, -1.5f, 5.0f, 1, 3, 1, 0, 17).m_171534_("support5_3", -2.5f, -1.5f, 7.0f, 1, 3, 1, 4, 17).m_171534_("support5_4", -2.5f, -1.5f, 13.0f, 1, 3, 1, 4, 17), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)-6.0f));
        partdefinition.m_171599_(MAIN, CubeListBuilder.m_171558_().m_171514_(36, 0).m_171534_("main_0", 0.0f, 0.0f, 1.0f, 6, 6, 8, 36, 18).m_171534_("main_1", 0.5f, 0.5f, 0.0f, 5, 5, 10, 34, 3), PartPose.m_171419_((float)-3.0f, (float)18.0f, (float)8.0f));
        partdefinition.m_171599_(MAGAZINE, CubeListBuilder.m_171558_().m_171514_(0, 14).m_171534_("magazine_0", -8.0f, -2.0f, 2.5f, 5, 6, 5, 0, 0).m_171480_(), PartPose.m_171419_((float)3.0f, (float)22.0f, (float)9.0f));
        PartDefinition mount = partdefinition.m_171599_(MOUNT, CubeListBuilder.m_171558_().m_171514_(0, 23), PartPose.m_171419_((float)-1.0f, (float)15.0f, (float)11.0f));
        mount.m_171599_(MOUNT_R1, CubeListBuilder.m_171558_().m_171514_(0, 23).m_171534_("mount_r1_0", -0.5f, -3.0f, -0.75f, 1, 2, 1, 60, 0), PartPose.m_171423_((float)1.0f, (float)2.0f, (float)2.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        mount.m_171599_(MOUNT_R2, CubeListBuilder.m_171558_().m_171514_(0, 23).m_171534_("mount_r2_0", -1.0f, -5.0f, -1.0f, 2, 1, 3, 54, 3).m_171534_("mount_r2_1", -1.0f, -4.0f, 0.0f, 2, 6, 2, 56, 18), PartPose.m_171423_((float)1.0f, (float)2.0f, (float)2.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_(MAGAZINECOLOR, CubeListBuilder.m_171558_().m_171514_(8, 0).m_171534_("magazineColor_0", -9.6f, -2.0f, 2.0f, 1, 2, 4, 54, 7).m_171480_(), PartPose.m_171419_((float)4.3f, (float)22.5f, (float)10.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void renderMinigun(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Minigun minigun, float partialTick, boolean renderMount) {
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)Textures.MODEL_DRONE_MINIGUN));
        matrixStack.m_85836_();
        if (renderMount) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.3125, -0.75);
            this.mount.m_104301_(matrixStack, builder, combinedLight, combinedOverlay);
            matrixStack.m_85849_();
        }
        float barrelRotation = 0.0f;
        if (minigun != null) {
            barrelRotation = minigun.getOldMinigunRotation() + partialTick * (minigun.getMinigunRotation() - minigun.getOldMinigunRotation());
            float yaw = minigun.oldMinigunYaw + partialTick * Minigun.clampYaw(minigun.minigunYaw - minigun.oldMinigunYaw);
            float pitch = minigun.oldMinigunPitch + partialTick * (minigun.minigunPitch - minigun.oldMinigunPitch);
            matrixStack.m_85837_(0.0, 1.4375, 0.0);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(yaw));
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(pitch));
            matrixStack.m_85837_(0.0, -1.125, -0.75);
        }
        this.barrel.f_104204_ = 0.0f;
        this.barrel.f_104203_ = 0.0f;
        for (int i = 0; i < 6; ++i) {
            this.barrel.f_104205_ = (float)(1.0471975511965976 * (double)i) + barrelRotation;
            this.barrel.m_104301_(matrixStack, builder, combinedLight, combinedOverlay);
        }
        this.support1.f_104205_ = barrelRotation;
        this.support2.f_104205_ = barrelRotation;
        this.support3.f_104205_ = barrelRotation;
        this.support4.f_104205_ = barrelRotation;
        this.support5.f_104205_ = barrelRotation;
        this.support1.m_104301_(matrixStack, builder, combinedLight, combinedOverlay);
        this.support2.m_104301_(matrixStack, builder, combinedLight, combinedOverlay);
        this.support3.m_104301_(matrixStack, builder, combinedLight, combinedOverlay);
        this.support4.m_104301_(matrixStack, builder, combinedLight, combinedOverlay);
        this.support5.m_104301_(matrixStack, builder, combinedLight, combinedOverlay);
        this.magazine.m_104301_(matrixStack, builder, combinedLight, combinedOverlay);
        this.main.m_104301_(matrixStack, builder, combinedLight, combinedOverlay);
        float[] cols = RenderUtils.decomposeColorF(minigun != null ? 0xFF000000 | minigun.getAmmoColor() : -13553359);
        this.magazineColor.m_104306_(matrixStack, builder, combinedLight, combinedOverlay, cols[1], cols[2], cols[3], cols[0]);
        matrixStack.m_85849_();
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }

    public void m_7695_(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
    }
}

