/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.upgrademanager;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.client.gui.upgrademanager.AbstractUpgradeManagerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.common.inventory.ChargingStationUpgradeManagerMenu;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ArmorItem;

public class PneumaticArmorUpgradeScreen
extends AbstractUpgradeManagerScreen {
    private final String registryName;
    private WidgetAnimatedStat statusStat;
    private final EquipmentSlot equipmentSlot;

    public PneumaticArmorUpgradeScreen(ChargingStationUpgradeManagerMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.registryName = this.itemStack.m_41720_().getRegistryName().m_135815_();
        this.equipmentSlot = ((ArmorItem)this.itemStack.m_41720_()).m_40402_();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info", new Object[0]), Textures.GUI_INFO_LOCATION, -7829249, true).setText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.item." + this.registryName, new Object[0]));
        this.statusStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status", new Object[0]), this.itemStack, -22016, false);
        this.addUpgradeTabs(this.itemStack.m_41720_(), "armor." + this.equipmentSlot.toString().toLowerCase(Locale.ROOT), "armor.generic");
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        CommonArmorHandler.getHandlerForPlayer().initArmorInventory(this.equipmentSlot);
        this.statusStat.setText(this.getStatusText());
    }

    private List<Component> getStatusText() {
        ArrayList<Component> text = new ArrayList<Component>();
        ChatFormatting black = ChatFormatting.BLACK;
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.pneumatic_armor.usage", new Object[0]).m_130940_(ChatFormatting.WHITE));
        CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer();
        float totalUsage = commonArmorHandler.getIdleAirUsage(this.equipmentSlot, true);
        if (totalUsage > 0.0f) {
            List<IArmorUpgradeHandler<?>> handlers = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(this.equipmentSlot);
            for (int i = 0; i < handlers.size(); ++i) {
                IArmorUpgradeHandler<?> handler;
                float upgradeUsage;
                if (!commonArmorHandler.isUpgradeInserted(this.equipmentSlot, i) || !((upgradeUsage = (handler = handlers.get(i)).getIdleAirUsage(commonArmorHandler)) > 0.0f)) continue;
                TranslatableComponent desc = PneumaticCraftUtils.xlate(IArmorUpgradeHandler.getStringKey(handler.getID()), new Object[0]);
                MutableComponent c = new TextComponent(PneumaticCraftUtils.roundNumberTo(upgradeUsage, 1) + " mL/t (").m_7220_((Component)desc).m_130946_(")").m_130940_(black);
                text.add((Component)c);
            }
            text.add((Component)new TextComponent("--------+").m_130940_(black));
            text.add((Component)new TextComponent(PneumaticCraftUtils.roundNumberTo(totalUsage, 1) + " mL/t").m_130940_(black));
        } else {
            text.add((Component)new TextComponent("0.0 mL/t").m_130940_(black));
        }
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.pneumatic_armor.timeRemaining", new Object[0]).m_130940_(ChatFormatting.WHITE));
        int airLeft = (Integer)this.itemStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(IAirHandler::getAir).orElseThrow(RuntimeException::new);
        if (totalUsage == 0.0f) {
            if (airLeft > 0) {
                text.add((Component)new TextComponent("\u221e").m_130940_(black));
            } else {
                text.add((Component)new TextComponent("0s").m_130940_(black));
            }
        } else {
            text.add((Component)new TextComponent(PneumaticCraftUtils.convertTicksToMinutesAndSeconds((int)((float)airLeft / totalUsage), false)).m_130940_(black));
        }
        return text;
    }

    @Override
    protected int getDefaultVolume() {
        return ((PneumaticArmorItem)this.itemStack.m_41720_()).getBaseVolume();
    }
}

