/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.LiquidCompressorBlockEntity;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.fluid.FuelRegistry;
import me.desht.pneumaticcraft.common.inventory.LiquidCompressorMenu;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class LiquidCompressorScreen
extends AbstractPneumaticCraftContainerScreen<LiquidCompressorMenu, LiquidCompressorBlockEntity> {
    public LiquidCompressorScreen(LiquidCompressorMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new WidgetTank(this.f_97735_ + this.getFluidOffset(), this.f_97736_ + 15, ((LiquidCompressorBlockEntity)this.te).getTank()));
        WidgetAnimatedStat stat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.liquidCompressor.fuel", new Object[0]), new ItemStack((ItemLike)ModItems.LPG_BUCKET.get()), -5226496, true);
        Pair<Integer, List<Component>> p = this.getAllFuels();
        stat.setMinimumExpandedDimensions((Integer)p.getLeft() + 30, 17);
        stat.setText((List)p.getRight());
    }

    @Override
    protected void addPressureStatInfo(List<Component> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.maxProduction", PneumaticCraftUtils.roundNumberTo(((LiquidCompressorBlockEntity)this.te).airPerTick, 2)).m_130940_(ChatFormatting.BLACK));
    }

    protected int getFluidOffset() {
        return 86;
    }

    @Override
    protected PointXY getInvNameOffset() {
        return new PointXY(0, -1);
    }

    @Override
    protected PointXY getGaugeLocation() {
        int xStart = (this.f_96543_ - this.f_97726_) / 2;
        int yStart = (this.f_96544_ - this.f_97727_) / 2;
        return new PointXY(xStart + this.f_97726_ * 3 / 4 + 5, yStart + this.f_97727_ / 4 + 4);
    }

    @Override
    protected String upgradeCategory() {
        return "liquid_compressor";
    }

    private Pair<Integer, List<Component>> getAllFuels() {
        ArrayList<Object> text = new ArrayList<Object>();
        TranslatableComponent header = PneumaticCraftUtils.xlate("pneumaticcraft.gui.liquidCompressor.fuelsHeader", new Object[0]);
        text.add(header.m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.AQUA}));
        int maxWidth = this.f_96547_.m_92852_((FormattedText)header);
        FuelRegistry fuelRegistry = FuelRegistry.getInstance();
        fuelRegistry.clearCachedFuelFluids();
        Level world = ((LiquidCompressorBlockEntity)this.te).m_58904_();
        ArrayList<Fluid> fluids = new ArrayList<Fluid>(fuelRegistry.registeredFuels(world));
        fluids.sort((o1, o2) -> Integer.compare(fuelRegistry.getFuelValue(world, (Fluid)o2), fuelRegistry.getFuelValue(world, (Fluid)o1)));
        Map<String, Integer> counted = fluids.stream().collect(Collectors.toMap(fluid -> new FluidStack(fluid, 1).getDisplayName().getString(), fluid -> 1, Integer::sum));
        int dotWidth = this.f_96547_.m_92895_(".");
        Component prevLine = TextComponent.f_131282_;
        for (Fluid fluid2 : fluids) {
            TextComponent line;
            Object value = String.format("%4d", fuelRegistry.getFuelValue(world, fluid2) / 1000);
            int nSpc = (32 - this.f_96547_.m_92895_((String)value)) / dotWidth;
            value = (String)value + StringUtils.repeat((char)'.', (int)nSpc);
            String fluidName = new FluidStack(fluid2, 1).getDisplayName().getString();
            float mul = fuelRegistry.getBurnRateMultiplier(world, fluid2);
            TextComponent textComponent = line = mul == 1.0f ? new TextComponent((String)value + "| " + StringUtils.abbreviate((String)fluidName, (int)25)) : new TextComponent((String)value + "| " + StringUtils.abbreviate((String)fluidName, (int)20) + " (x" + PneumaticCraftUtils.roundNumberTo(mul, 2) + ")");
            if (!line.equals((Object)prevLine)) {
                maxWidth = Math.max(maxWidth, this.f_96547_.m_92852_((FormattedText)line));
                text.add(line);
            }
            prevLine = line;
            if (counted.getOrDefault(fluidName, 0) <= 1) continue;
            MutableComponent line2 = new TextComponent("       " + ModNameCache.getModName(fluid2)).m_130940_(ChatFormatting.GOLD);
            text.add(line2);
            maxWidth = Math.max(maxWidth, this.f_96547_.m_92852_((FormattedText)line2));
        }
        return Pair.of((Object)Math.min(maxWidth, this.f_97735_ - 10), text);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_LIQUID_COMPRESSOR;
    }

    @Override
    public void addProblems(List<Component> curInfo) {
        super.addProblems(curInfo);
        if (((LiquidCompressorBlockEntity)this.te).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).isPresent()) {
            ((LiquidCompressorBlockEntity)this.te).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(fluidHandler -> {
                if (!((LiquidCompressorBlockEntity)this.te).isActive() && fluidHandler.getFluidInTank(0).isEmpty()) {
                    curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.liquidCompressor.noFuel", new Object[0]));
                }
            });
        } else {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.liquidCompressor.noFuel", new Object[0]));
        }
    }
}

