/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.InventorySearcherScreen;
import me.desht.pneumaticcraft.client.gui.ItemSearcherScreen;
import me.desht.pneumaticcraft.client.gui.semiblock.LogisticsLiquidFilterScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidFilter;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModMenuTypes;
import me.desht.pneumaticcraft.common.inventory.AmadronAddTradeMenu;
import me.desht.pneumaticcraft.common.item.AmadronTabletItem;
import me.desht.pneumaticcraft.common.item.GPSToolItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeAddCustom;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.util.GlobalPosHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class AmadronAddTradeScreen
extends AbstractPneumaticCraftContainerScreen<AmadronAddTradeMenu, AbstractPneumaticCraftBlockEntity> {
    private ItemSearcherScreen searchGui;
    private InventorySearcherScreen invSearchGui;
    private InventorySearcherScreen gpsSearchGui;
    private LogisticsLiquidFilterScreen fluidGui;
    private int settingSlot;
    private final WidgetFluidFilter[] fluidFilters = new WidgetFluidFilter[2];
    private final WidgetTextFieldNumber[] amountFields = new WidgetTextFieldNumber[2];
    private final BlockPos[] positions = new BlockPos[2];
    private Button addButton;
    private boolean openingSubGUI = false;

    public AmadronAddTradeScreen(AmadronAddTradeMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.f_97726_ = 183;
        this.f_97727_ = 202;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        if (this.searchGui != null) {
            this.setStack(this.settingSlot, this.searchGui.getSearchStack());
        } else if (this.invSearchGui != null) {
            this.setStack(this.settingSlot, this.invSearchGui.getSearchStack());
        } else if (this.fluidGui != null) {
            this.setFluid(this.settingSlot, this.fluidGui.getFilter());
        } else if (this.gpsSearchGui != null) {
            GPSToolItem.getGPSLocation(this.gpsSearchGui.getSearchStack()).ifPresent(pos -> {
                this.positions[this.settingSlot] = pos;
            });
        }
        this.openingSubGUI = false;
        this.searchGui = null;
        this.fluidGui = null;
        this.invSearchGui = null;
        this.gpsSearchGui = null;
        this.initSide(0);
        this.initSide(1);
        this.m_7522_((GuiEventListener)this.amountFields[0]);
        this.addButton = new WidgetButtonExtended(this.f_97735_ + 50, this.f_97736_ + 171, 85, 20, "Add Trade", b -> this.addTrade());
        this.m_142416_((GuiEventListener)this.addButton);
        this.addJeiFilterInfoTab();
    }

    public void setStack(int slot, ItemStack stack) {
        this.fluidFilters[slot].setFluid(Fluids.f_76191_);
        ((AmadronAddTradeMenu)this.f_97732_).setStack(slot, stack);
    }

    public void setFluid(int slot, Fluid stack) {
        ((AmadronAddTradeMenu)this.f_97732_).setStack(slot, ItemStack.f_41583_);
        this.fluidFilters[slot].setFluid(stack);
    }

    private void initSide(int slot) {
        int xOffset = slot == 0 ? 0 : 89;
        String s = slot == 0 ? "selling" : "buying";
        this.m_142416_((GuiEventListener)new WidgetLabel(this.f_97735_ + 48 + xOffset, this.f_97736_ + 7, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.addTrade." + s, new Object[0]), -1).setAlignment(WidgetLabel.Alignment.CENTRE));
        this.m_142416_((GuiEventListener)new WidgetButtonExtended(this.f_97735_ + 4 + xOffset, this.f_97736_ + 20, 85, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.searchItem", new Object[0]), b -> this.openItemSearchGui(slot)));
        this.m_142416_((GuiEventListener)new WidgetButtonExtended(this.f_97735_ + 4 + xOffset, this.f_97736_ + 42, 85, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.searchInventory", new Object[0]), b -> this.openInventorySearchGui(slot)));
        this.m_142416_((GuiEventListener)new WidgetButtonExtended(this.f_97735_ + 4 + xOffset, this.f_97736_ + 64, 85, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.searchFluid", new Object[0]), b -> this.openFluidSearchGui(slot)));
        Fluid prev = this.fluidFilters[slot] != null ? this.fluidFilters[slot].getFluid() : Fluids.f_76191_;
        this.fluidFilters[slot] = new WidgetFluidFilter(this.f_97735_ + 37 + xOffset, this.f_97736_ + 90, prev);
        this.m_142416_((GuiEventListener)this.fluidFilters[slot]);
        String tip = slot == 0 ? "pneumaticcraft.gui.amadron.button.selectSellingBlock.tooltip" : "pneumaticcraft.gui.amadron.button.selectPaymentBlock.tooltip";
        this.m_142416_((GuiEventListener)new WidgetButtonExtended(this.f_97735_ + 10 + xOffset, this.f_97736_ + 115, 20, 20, "", b -> this.openGPSGui(slot)).setRenderStacks(new ItemStack((ItemLike)ModItems.GPS_TOOL.get())).setTooltipKey(tip, new Object[0]));
        int coarse = this.fluidFilters[slot].getFluid() == Fluids.f_76191_ ? 10 : 1000;
        int max = this.fluidFilters[slot].getFluid() == Fluids.f_76191_ ? 64 : Integer.MAX_VALUE;
        Objects.requireNonNull(this.f_96547_);
        this.amountFields[slot] = new WidgetTextFieldNumber(this.f_96547_, this.f_97735_ + 22 + xOffset, this.f_97736_ + 145, 40, 9).setValue(this.amountFields[slot] != null ? this.amountFields[slot].getIntValue() : 1).setRange(1, max).setAdjustments(1.0, coarse);
        this.m_142416_((GuiEventListener)this.amountFields[slot]);
        this.m_142416_((GuiEventListener)new WidgetLabel(this.f_97735_ + 65 + xOffset, this.f_97736_ + 145, (Component)new TextComponent(this.fluidFilters[slot].getFluid() != Fluids.f_76191_ ? "mB" : ""), -1));
        GlobalPos p = this.getPosition(slot);
        if (p != null && GlobalPosHelper.isSameWorld(p, ClientUtils.getClientLevel())) {
            BlockState state = ClientUtils.getClientLevel().m_8055_(p.m_122646_());
            Component name = new ItemStack((ItemLike)state.m_60734_().m_5456_()).m_41786_();
            ((WidgetLabel)this.m_142416_((GuiEventListener)new WidgetLabel(this.f_97735_ + 32 + xOffset, this.f_97736_ + 118, name, -1))).setScale(0.5f);
            ((WidgetLabel)this.m_142416_((GuiEventListener)new WidgetLabel(this.f_97735_ + 32 + xOffset, this.f_97736_ + 124, (Component)new TextComponent(" @ " + this.posToString(p.m_122646_())), -1))).setScale(0.5f);
        }
        if (this.positions[slot] == null) {
            ((WidgetLabel)this.m_142416_((GuiEventListener)new WidgetLabel(this.f_97735_ + 32 + xOffset, this.f_97736_ + 130, (Component)new TextComponent("[Default]"), -4144960))).setScale(0.5f);
        }
    }

    private String posToString(BlockPos pos) {
        return pos == null ? "[Default]" : PneumaticCraftUtils.posToString(pos);
    }

    public boolean m_6913_() {
        return true;
    }

    @Override
    public void m_7861_() {
        if (!this.openingSubGUI) {
            NetworkHandler.sendToServer(new PacketGuiButton("showAmadron"));
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        GuiEventListener guiEventListener;
        if (keyCode == 256) {
            this.m_7861_();
            return true;
        }
        if (keyCode == 258) {
            WidgetTextFieldNumber amountIn = this.amountFields[0];
            WidgetTextFieldNumber amountOut = this.amountFields[1];
            if (amountIn.m_93696_()) {
                amountIn.m_94192_(amountIn.m_94207_());
                amountIn.m_94178_(false);
                this.m_7522_((GuiEventListener)amountOut);
                amountOut.m_94192_(0);
                amountOut.m_94208_(amountOut.m_94155_().length());
            } else if (amountOut.m_93696_()) {
                amountOut.m_94192_(amountOut.m_94207_());
                amountOut.m_94178_(false);
                this.m_7522_((GuiEventListener)amountIn);
                amountIn.m_94192_(0);
                amountIn.m_94208_(amountIn.m_94155_().length());
            }
        }
        if ((guiEventListener = this.m_7222_()) instanceof WidgetTextField) {
            WidgetTextField tf = (WidgetTextField)guiEventListener;
            return tf.m_7933_(keyCode, scanCode, modifiers) || tf.m_94204_() || super.m_7933_(keyCode, scanCode, modifiers);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    protected int getBackgroundTint() {
        return -16347604;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_AMADRON_ADD_TRADE;
    }

    private void openItemSearchGui(int slot) {
        this.openingSubGUI = true;
        ClientUtils.openContainerGui((MenuType<? extends AbstractContainerMenu>)((MenuType)ModMenuTypes.ITEM_SEARCHER.get()), (Component)new TranslatableComponent("pneumaticcraft.gui.amadron.addTrade.itemSearch"));
        Screen screen = this.f_96541_.f_91080_;
        if (screen instanceof ItemSearcherScreen) {
            ItemSearcherScreen scr = (ItemSearcherScreen)screen;
            this.settingSlot = slot;
            this.searchGui = scr;
            this.searchGui.setSearchStack(((AmadronAddTradeMenu)this.f_97732_).getStack(slot));
        }
    }

    private void openInventorySearchGui(int slot) {
        this.openingSubGUI = true;
        ClientUtils.openContainerGui((MenuType<? extends AbstractContainerMenu>)((MenuType)ModMenuTypes.INVENTORY_SEARCHER.get()), (Component)new TranslatableComponent("pneumaticcraft.gui.amadron.addTrade.invSearch"));
        Screen screen = this.f_96541_.f_91080_;
        if (screen instanceof InventorySearcherScreen) {
            InventorySearcherScreen scr = (InventorySearcherScreen)screen;
            this.settingSlot = slot;
            this.invSearchGui = scr;
            this.invSearchGui.setSearchStack(((AmadronAddTradeMenu)this.f_97732_).getStack(slot));
        }
    }

    private void openFluidSearchGui(int slot) {
        this.openingSubGUI = true;
        this.settingSlot = slot;
        this.fluidGui = new LogisticsLiquidFilterScreen((Screen)this);
        this.fluidGui.setFilter(this.fluidFilters[slot].getFluid());
        this.f_96541_.m_91152_((Screen)this.fluidGui);
    }

    private void openGPSGui(int slot) {
        this.openingSubGUI = true;
        ClientUtils.openContainerGui((MenuType<? extends AbstractContainerMenu>)((MenuType)ModMenuTypes.INVENTORY_SEARCHER.get()), (Component)new TranslatableComponent("pneumaticcraft.gui.amadron.addTrade.gpsSearch"));
        Screen screen = this.f_96541_.f_91080_;
        if (screen instanceof InventorySearcherScreen) {
            InventorySearcherScreen scr;
            this.gpsSearchGui = scr = (InventorySearcherScreen)screen;
            this.gpsSearchGui.setStackPredicate(itemStack -> itemStack.m_41720_() instanceof IPositionProvider);
            this.settingSlot = slot;
            ItemStack gps = new ItemStack((ItemLike)ModItems.GPS_TOOL.get());
            GlobalPos gPos = this.getPosition(slot);
            if (gPos != null) {
                GPSToolItem.setGPSLocation(ClientUtils.getClientPlayer().m_142081_(), gps, gPos.m_122646_());
            }
            this.gpsSearchGui.setSearchStack(GPSToolItem.getGPSLocation(gps).isPresent() ? gps : ItemStack.f_41583_);
        }
    }

    private void addTrade() {
        AmadronTradeResource[] resources = new AmadronTradeResource[2];
        for (int slot = 0; slot < resources.length; ++slot) {
            resources[slot] = !((AmadronAddTradeMenu)this.f_97732_).getStack(slot).m_41619_() ? AmadronTradeResource.of(ItemHandlerHelper.copyStackWithSize((ItemStack)((AmadronAddTradeMenu)this.f_97732_).getStack(slot), (int)this.amountFields[slot].getIntValue())) : AmadronTradeResource.of(new FluidStack(this.fluidFilters[slot].getFluid(), this.amountFields[slot].getIntValue()));
        }
        String id = ClientUtils.getClientPlayer().m_7755_().m_6111_().toLowerCase() + "_" + System.currentTimeMillis() / 1000L;
        AmadronPlayerOffer trade = new AmadronPlayerOffer(PneumaticRegistry.RL(id), resources[1], resources[0], ClientUtils.getClientPlayer()).setProvidingPosition(this.getPosition(0)).setReturningPosition(this.getPosition(1));
        NetworkHandler.sendToServer(new PacketAmadronTradeAddCustom(trade));
    }

    private GlobalPos getPosition(int slot) {
        if (this.positions[slot] != null) {
            return GlobalPosHelper.makeGlobalPos(ClientUtils.getClientLevel(), this.positions[slot]);
        }
        if (!((AmadronAddTradeMenu)this.f_97732_).getStack(slot).m_41619_()) {
            return AmadronTabletItem.getItemProvidingLocation(ClientUtils.getClientPlayer().m_21205_());
        }
        if (this.fluidFilters[slot].getFluid() != Fluids.f_76191_) {
            return AmadronTabletItem.getFluidProvidingLocation(ClientUtils.getClientPlayer().m_21205_());
        }
        return null;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        GlobalPos inPos = this.getPosition(0);
        GlobalPos outPos = this.getPosition(1);
        this.addButton.f_93623_ = !(this.amountFields[0].getIntValue() <= 0 || this.amountFields[1].getIntValue() <= 0 || this.fluidFilters[0].getFluid() == Fluids.f_76191_ && ((AmadronAddTradeMenu)this.f_97732_).getInputStack().m_41619_() || this.fluidFilters[1].getFluid() == Fluids.f_76191_ && ((AmadronAddTradeMenu)this.f_97732_).getOutputStack().m_41619_() || inPos == null || outPos == null);
    }

    @Override
    protected void addProblems(List<Component> curInfo) {
        if (this.getPosition(0) == null || this.getPosition(1) == null) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.amadron.addTrade.problems.noSellingOrPayingBlock", new Object[0]));
        }
        super.addProblems(curInfo);
    }
}

