/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class NoNBTIngredient
extends Ingredient {
    private final ItemStack stack;

    public NoNBTIngredient(ItemStack stack) {
        super(Stream.of(new Ingredient.ItemValue(stack)));
        this.stack = stack;
    }

    public NoNBTIngredient(ItemLike item) {
        this(new ItemStack(item));
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && stack.m_41720_() == this.stack.m_41720_() && !stack.m_41782_();
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.ID.toString());
        json.addProperty("item", this.stack.m_41720_().getRegistryName().toString());
        json.addProperty("count", (Number)this.stack.m_41613_());
        return json;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<NoNBTIngredient> {
        public static final IIngredientSerializer<NoNBTIngredient> INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("pneumaticcraft:no_nbt");

        public NoNBTIngredient parse(FriendlyByteBuf buffer) {
            return new NoNBTIngredient(buffer.m_130267_());
        }

        public NoNBTIngredient parse(JsonObject json) {
            return new NoNBTIngredient((ItemLike)ShapedRecipe.m_151278_((JsonObject)json));
        }

        public void write(FriendlyByteBuf buffer, NoNBTIngredient ingredient) {
            buffer.m_130055_(ingredient.stack);
        }
    }
}

