/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;

public class AmadronTradeResource {
    private final Either<ItemStack, FluidStack> resource;

    private AmadronTradeResource(@Nonnull ItemStack stack) {
        this.resource = Either.left((Object)stack);
    }

    private AmadronTradeResource(@Nonnull FluidStack stack) {
        this.resource = Either.right((Object)stack);
    }

    public boolean isEmpty() {
        return (Boolean)this.resource.map(ItemStack::m_41619_, FluidStack::isEmpty);
    }

    public boolean equivalentTo(AmadronTradeResource other) {
        return (Boolean)this.resource.map(itemStack -> itemStack.m_41720_() == other.getItem().m_41720_(), fluidStack -> fluidStack.getFluid() == other.getFluid().getFluid());
    }

    public static AmadronTradeResource of(ItemStack stack) {
        return new AmadronTradeResource(stack);
    }

    public static AmadronTradeResource of(FluidStack stack) {
        return new AmadronTradeResource(stack);
    }

    public static AmadronTradeResource fromPacketBuf(FriendlyByteBuf pb) {
        Type type = (Type)pb.m_130066_(Type.class);
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.ITEM -> new AmadronTradeResource(pb.m_130267_());
            case Type.FLUID -> new AmadronTradeResource(FluidStack.loadFluidStackFromNBT((CompoundTag)pb.m_130260_()));
        };
    }

    public ItemStack getItem() {
        return this.resource.left().orElse(ItemStack.f_41583_);
    }

    public FluidStack getFluid() {
        return this.resource.right().orElse(FluidStack.EMPTY);
    }

    public void accept(Consumer<ItemStack> cItemStack, Consumer<FluidStack> cFluidStack) {
        this.resource.ifLeft(cItemStack).ifRight(cFluidStack);
    }

    public <T> T apply(Function<ItemStack, T> fItemStack, Function<FluidStack, T> fFluidStack) {
        return (T)this.resource.map(fItemStack, fFluidStack);
    }

    public int totalSpaceRequired(int units) {
        return (Integer)this.resource.map(itemStack -> (itemStack.m_41613_() * units - 1) / itemStack.m_41741_() + 1, fluidStack -> fluidStack.getAmount() * units);
    }

    public int countTradesInInventory(LazyOptional<IItemHandler> inv) {
        return this.resource.left().map(item -> AmadronTradeResource.countItemsInHandler(item, inv) / item.m_41613_()).orElse(0);
    }

    public int findSpaceInItemOutput(LazyOptional<IItemHandler> inv, int wantedTradeCount) {
        return this.resource.left().map(item -> Math.min(wantedTradeCount, AmadronTradeResource.findSpaceInHandler(item, wantedTradeCount, inv))).orElse(0);
    }

    public int countTradesInTank(LazyOptional<IFluidHandler> lazy) {
        return this.resource.right().map(fluid -> lazy.map(fluidHandler -> {
            FluidStack searchingFluid = fluid.copy();
            searchingFluid.setAmount(Integer.MAX_VALUE);
            FluidStack extracted = fluidHandler.drain(searchingFluid, IFluidHandler.FluidAction.SIMULATE);
            return extracted.getAmount() / fluid.getAmount();
        }).orElse(0)).orElse(0);
    }

    public int findSpaceInFluidOutput(LazyOptional<IFluidHandler> lazy, int wantedTradeCount) {
        return this.resource.right().map(fluid -> lazy.map(fluidHandler -> {
            FluidStack providingFluid = fluid.copy();
            providingFluid.setAmount(providingFluid.getAmount() * wantedTradeCount);
            int amountFilled = fluidHandler.fill(providingFluid, IFluidHandler.FluidAction.SIMULATE);
            return amountFilled / fluid.getAmount();
        }).orElse(0)).orElse(0);
    }

    public AmadronTradeResource validate() {
        this.resource.ifLeft(stack -> Validate.isTrue((!stack.m_41619_() ? 1 : 0) != 0)).ifRight(fluidStack -> Validate.isTrue((!fluidStack.isEmpty() ? 1 : 0) != 0));
        return this;
    }

    public static AmadronTradeResource fromJson(JsonObject obj) throws CommandSyntaxException {
        Type type = Type.valueOf(obj.get("type").getAsString().toUpperCase(Locale.ROOT));
        ResourceLocation rl = new ResourceLocation(obj.get("id").getAsString());
        int amount = obj.get("amount").getAsInt();
        switch (type) {
            case ITEM: {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(rl);
                if (item == null || item == Items.f_41852_) {
                    throw new JsonSyntaxException("unknown item " + rl + "!");
                }
                ItemStack itemStack = new ItemStack((ItemLike)item, amount);
                if (obj.has("nbt")) {
                    itemStack.m_41751_(TagParser.m_129359_((String)GsonHelper.m_13906_((JsonObject)obj, (String)"nbt")));
                }
                return new AmadronTradeResource(itemStack);
            }
            case FLUID: {
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(rl);
                if (fluid == null || fluid == Fluids.f_76191_) {
                    throw new JsonSyntaxException("unknown fluid " + rl + "!");
                }
                FluidStack fluidStack = new FluidStack(fluid, amount);
                return new AmadronTradeResource(fluidStack);
            }
        }
        throw new JsonSyntaxException("amadron offer " + rl + " : invalid type!");
    }

    public JsonObject toJson() {
        JsonObject res = new JsonObject();
        this.resource.ifLeft(item -> {
            res.addProperty("type", Type.ITEM.name());
            ResourceLocation name = item.m_41720_().getRegistryName();
            res.addProperty("id", name == null ? "" : name.toString());
            res.addProperty("amount", (Number)item.m_41613_());
            if (item.m_41782_()) {
                res.addProperty("nbt", Objects.requireNonNull(item.m_41783_()).toString());
            }
        }).ifRight(fluid -> {
            res.addProperty("type", Type.FLUID.name());
            res.addProperty("id", fluid.getFluid().getRegistryName().toString());
            res.addProperty("amount", (Number)fluid.getAmount());
        });
        return res;
    }

    public void writeToBuf(FriendlyByteBuf pb) {
        this.resource.ifLeft(pStack -> {
            pb.m_130068_((Enum)Type.ITEM);
            pb.m_130055_(pStack);
        }).ifRight(fluidStack -> {
            pb.m_130068_((Enum)Type.FLUID);
            pb.m_130079_(fluidStack.writeToNBT(new CompoundTag()));
        });
    }

    public String getName() {
        return (String)this.resource.map(itemStack -> itemStack.m_41786_().getString(), fluidStack -> fluidStack.getDisplayName().getString());
    }

    public ResourceLocation getId() {
        return (ResourceLocation)this.resource.map(itemStack -> itemStack.m_41720_().getRegistryName(), fluidStack -> fluidStack.getFluid().getRegistryName());
    }

    public int getAmount() {
        return (Integer)this.resource.map(ItemStack::m_41613_, FluidStack::getAmount);
    }

    public CompoundTag writeToNBT() {
        CompoundTag tag = new CompoundTag();
        this.resource.ifLeft(itemStack -> {
            tag.m_128359_("type", Type.ITEM.toString());
            tag.m_128365_("resource", (Tag)itemStack.m_41739_(new CompoundTag()));
        }).ifRight(fluidStack -> {
            tag.m_128359_("type", Type.FLUID.toString());
            tag.m_128365_("resource", (Tag)fluidStack.writeToNBT(new CompoundTag()));
        });
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AmadronTradeResource)) {
            return false;
        }
        AmadronTradeResource that = (AmadronTradeResource)o;
        return (Boolean)this.resource.map(itemStack -> ItemStack.m_41728_((ItemStack)itemStack, (ItemStack)that.getItem()), fluidStack -> fluidStack.isFluidStackIdentical(that.getFluid()));
    }

    public int hashCode() {
        return (Integer)this.resource.map(xva$0 -> Objects.hash(xva$0), xva$0 -> Objects.hash(xva$0));
    }

    public String toString() {
        return (String)this.resource.map(itemStack -> itemStack.m_41613_() + " x " + itemStack.m_41786_().getString(), fluidStack -> fluidStack.getAmount() + "mB " + fluidStack.getDisplayName().getString());
    }

    private static int countItemsInHandler(ItemStack item, LazyOptional<IItemHandler> lazy) {
        boolean matchNBT = item.m_41782_();
        IItemRegistry registry = PneumaticRegistry.getInstance().getItemRegistry();
        return lazy.map(handler -> IntStream.range(0, handler.getSlots()).filter(i -> registry.doesItemMatchFilter(item, handler.getStackInSlot(i), false, matchNBT, false)).map(i -> handler.getStackInSlot(i).m_41613_()).sum()).orElse(0);
    }

    private static int findSpaceInHandler(ItemStack item, int multiplier, LazyOptional<IItemHandler> lazy) {
        int totalItems = item.m_41613_() * multiplier;
        return lazy.map(inv -> {
            int remaining = totalItems;
            for (int i = 0; i < inv.getSlots() && remaining > 0; ++i) {
                if (!inv.getStackInSlot(i).m_41619_() && !ItemHandlerHelper.canItemStacksStack((ItemStack)inv.getStackInSlot(i), (ItemStack)item)) continue;
                remaining -= item.m_41741_() - inv.getStackInSlot(i).m_41613_();
            }
            return (totalItems - remaining) / item.m_41613_();
        }).orElse(0);
    }

    private static enum Type {
        ITEM,
        FLUID;

    }
}

