/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.worldgen.feature.configurations;

import biomesoplenty.common.worldgen.feature.configurations.BOPTreeConfiguration;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;

public class TwigletTreeConfiguration
extends BOPTreeConfiguration {
    public static final Codec<TwigletTreeConfiguration> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockStateProvider.f_68747_.fieldOf("trunk_provider").forGetter(instance -> instance.f_68185_), (App)BlockStateProvider.f_68747_.fieldOf("foliage_provider").forGetter(instance -> instance.f_161213_), (App)BlockStateProvider.f_68747_.fieldOf("vine_provider").forGetter(instance -> instance.vineProvider), (App)BlockStateProvider.f_68747_.fieldOf("hanging_provider").forGetter(instance -> instance.hangingProvider), (App)BlockStateProvider.f_68747_.fieldOf("trunk_fruit_provider").forGetter(instance -> instance.trunkFruitProvider), (App)BlockStateProvider.f_68747_.fieldOf("alt_foliage_provider").forGetter(instance -> instance.altFoliageProvider), (App)Codec.INT.fieldOf("min_height").forGetter(instance -> instance.minHeight), (App)Codec.INT.fieldOf("max_height").forGetter(instance -> instance.maxHeight), (App)TreeDecorator.f_70021_.listOf().fieldOf("decorators").forGetter(instance -> instance.f_68187_), (App)Codec.FLOAT.fieldOf("leaf_chance_even").forGetter(instance -> Float.valueOf(instance.leafChanceEven)), (App)Codec.FLOAT.fieldOf("leaf_chance_odd").forGetter(instance -> Float.valueOf(instance.leafChanceOdd))).apply((Applicative)builder, TwigletTreeConfiguration::new));
    public final float leafChanceEven;
    public final float leafChanceOdd;

    protected TwigletTreeConfiguration(BlockStateProvider trunkProvider, BlockStateProvider foliageProvider, BlockStateProvider vineProvider, BlockStateProvider hangingProvider, BlockStateProvider trunkFruitProvider, BlockStateProvider altFoliageProvider, int minHeight, int maxHeight, List<TreeDecorator> decorators, float leafChanceEven, float leafChanceOdd) {
        super(trunkProvider, foliageProvider, vineProvider, hangingProvider, trunkFruitProvider, altFoliageProvider, minHeight, maxHeight, decorators);
        this.leafChanceEven = leafChanceEven;
        this.leafChanceOdd = leafChanceOdd;
    }

    public static class Builder
    extends BOPTreeConfiguration.Builder<Builder> {
        private float leafChanceEven;
        private float leafChanceOdd;

        public Builder() {
            this.minHeight = 2;
            this.maxHeight = 6;
            this.leafChanceEven = 0.2f;
            this.leafChanceOdd = 0.9f;
        }

        public Builder leafChance(float a, float b) {
            this.leafChanceEven = a;
            this.leafChanceOdd = b;
            return this;
        }

        @Override
        public TwigletTreeConfiguration build() {
            return new TwigletTreeConfiguration(this.trunkProvider, this.foliageProvider, this.vineProvider, this.hangingProvider, this.trunkFruitProvider, this.altFoliageProvider, this.minHeight, this.maxHeight, this.decorators, this.leafChanceEven, this.leafChanceOdd);
        }
    }
}

