/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WildCropBlock
extends FlowerBlock
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    private final boolean renderOffset;

    public WildCropBlock(MobEffect suspiciousStewEffect, int effectDuration, BlockBehaviour.Properties properties) {
        super(suspiciousStewEffect, effectDuration, properties);
        this.renderOffset = true;
    }

    public WildCropBlock(MobEffect suspiciousStewEffect, int effectDuration, BlockBehaviour.Properties properties, boolean hasOffset) {
        super(suspiciousStewEffect, effectDuration, properties);
        this.renderOffset = hasOffset;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_204336_(BlockTags.f_144274_) || state.m_204336_(BlockTags.f_13029_);
    }

    public BlockBehaviour.OffsetType m_5858_() {
        return this.renderOffset ? BlockBehaviour.OffsetType.XZ : BlockBehaviour.OffsetType.NONE;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return (double)rand.nextFloat() < (double)0.8f;
    }

    public void m_7719_(ServerLevel worldIn, Random random, BlockPos pos, BlockState state) {
        int wildCropLimit = 10;
        for (BlockPos nearbyPos : BlockPos.m_121940_((BlockPos)pos.m_142082_(-4, -1, -4), (BlockPos)pos.m_142082_(4, 1, 4))) {
            if (!worldIn.m_8055_(nearbyPos).m_60713_((Block)this) || --wildCropLimit > 0) continue;
            return;
        }
        BlockPos randomPos = pos.m_142082_(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
        for (int k = 0; k < 4; ++k) {
            if (worldIn.m_46859_(randomPos) && state.m_60710_((LevelReader)worldIn, randomPos)) {
                pos = randomPos;
            }
            randomPos = pos.m_142082_(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
        }
        if (worldIn.m_46859_(randomPos) && state.m_60710_((LevelReader)worldIn, randomPos)) {
            worldIn.m_7731_(randomPos, state, 2);
        }
    }
}

