/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.integration.jei;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import someassemblyrequired.common.init.ModItems;
import someassemblyrequired.common.item.sandwich.SandwichItem;
import someassemblyrequired.common.util.Util;

public class SandwichAssemblyCategory
implements IRecipeCategory<Recipe> {
    public static final ResourceLocation ID = Util.id("sandwich_assembly");
    private final Component title = Util.translate("jei.sandwich_assembly", new Object[0]);
    private final IDrawable background;
    private final IDrawable icon;
    private final ItemStack breadSlice;
    private final ItemStack sandwich;

    public SandwichAssemblyCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(Util.id("textures/jei/sandwich_assembly.png"), 0, 0, 96, 64);
        this.breadSlice = new ItemStack((ItemLike)ModItems.BREAD_SLICE.get());
        this.sandwich = SandwichItem.makeSandwich(new ItemLike[]{Items.f_42580_, (ItemLike)ModItems.TOMATO_SLICES.get()});
        this.icon = helper.createDrawableIngredient(VanillaTypes.ITEM, (Object)this.sandwich);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends Recipe> getRecipeClass() {
        return Recipe.class;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(Recipe decompositionRecipe, IIngredients ingredients) {
        ingredients.setInputIngredients((List)ImmutableList.of((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.breadSlice})));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.sandwich);
    }

    public void setRecipe(IRecipeLayout recipeLayout, Recipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        stacks.init(0, true, 7, 4);
        stacks.set(0, this.breadSlice);
        stacks.init(1, true, 7, 42);
        stacks.set(1, this.breadSlice);
        stacks.init(2, false, 71, 23);
        stacks.set(2, this.sandwich);
    }

    public List<Component> getTooltipStrings(Recipe recipe, double mouseX, double mouseY) {
        int x = 8;
        int y = 24;
        if (mouseX >= (double)x && mouseY >= (double)y && mouseX < (double)(x + 16) && mouseY < (double)(y + 16)) {
            return ImmutableList.of((Object)Util.translate("jei.sandwich_assembly.ingredients", new Object[0]));
        }
        return Collections.emptyList();
    }

    public static class Recipe {
    }
}

