/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.integration.create.recipe.deployer;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.utility.recipe.IRecipeTypeInfo;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import someassemblyrequired.common.config.ModConfig;
import someassemblyrequired.common.ingredient.Ingredients;
import someassemblyrequired.common.init.ModItems;
import someassemblyrequired.common.init.ModTags;
import someassemblyrequired.common.item.sandwich.SandwichItem;
import someassemblyrequired.common.item.sandwich.SandwichItemHandler;
import someassemblyrequired.common.util.Util;

public class SandwichDeployingRecipe
extends ProcessingRecipe<RecipeWrapper> {
    private static final IRecipeTypeInfo TYPE_INFO = new TypeInfo();
    private static final ResourceLocation RECIPE_ID = Util.id("sandwich_deploying");

    public SandwichDeployingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(TYPE_INFO, params);
    }

    public static Optional<SandwichDeployingRecipe> createRecipe(RecipeWrapper inventory) {
        if (!SandwichDeployingRecipe.matches(inventory)) {
            return Optional.empty();
        }
        return Optional.of(SandwichDeployingRecipe.createRecipe(inventory.m_8020_(0), inventory.m_8020_(1)));
    }

    public static boolean matches(RecipeWrapper inventory) {
        ItemStack item = inventory.m_8020_(0);
        if (item.m_41619_() || !item.m_204117_(ModTags.SANDWICH_BREAD) && !item.m_150930_((Item)ModItems.SANDWICH.get())) {
            return false;
        }
        ItemStack ingredient = inventory.m_8020_(1);
        if (!Ingredients.canAddToSandwich(ingredient) || ingredient.m_150930_((Item)ModItems.SANDWICH.get())) {
            return false;
        }
        return SandwichItemHandler.get((ICapabilityProvider)item).map(sandwich -> sandwich.size() < (Integer)ModConfig.server.maximumSandwichHeight.get()).orElse(true);
    }

    public static SandwichDeployingRecipe createRecipe(ItemStack sandwich, ItemStack ingredient) {
        sandwich = sandwich.m_41777_();
        sandwich.m_41764_(1);
        ingredient = ingredient.m_41777_();
        ingredient.m_41764_(1);
        ItemStack container = Ingredients.getContainer(ingredient);
        ItemStack result = SandwichItem.of(sandwich, ingredient);
        return (SandwichDeployingRecipe)new ProcessingRecipeBuilder(SandwichDeployingRecipe::new, RECIPE_ID).withItemOutputs(new ProcessingOutput[]{new ProcessingOutput(result, 1.0f), container.m_41619_() ? ProcessingOutput.EMPTY : new ProcessingOutput(container, 1.0f)}).build();
    }

    public boolean matches(RecipeWrapper inventory, Level level) {
        return false;
    }

    protected int getMaxInputCount() {
        return 2;
    }

    protected int getMaxOutputCount() {
        return 2;
    }

    private static class TypeInfo
    implements IRecipeTypeInfo {
        private TypeInfo() {
        }

        public ResourceLocation getId() {
            return null;
        }

        public <T extends RecipeSerializer<?>> T getSerializer() {
            return null;
        }

        public <T extends RecipeType<?>> T getType() {
            return (T)AllRecipeTypes.DEPLOYING.getType();
        }
    }
}

