/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.integration.create.recipe;

import com.google.gson.JsonObject;
import com.simibubi.create.AllFluids;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluid;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluidHandler;
import com.simibubi.create.foundation.utility.NBTHelper;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import someassemblyrequired.common.init.ModRecipeTypes;
import someassemblyrequired.common.recipe.SandwichSpoutingRecipe;

public class SandwichPotionSpoutingRecipe
extends SandwichSpoutingRecipe {
    private static final ItemStack BOTTLE = new ItemStack((ItemLike)Items.f_42590_);

    public SandwichPotionSpoutingRecipe(ResourceLocation id) {
        super(id);
    }

    @Override
    public int getAmountRequired(FluidStack fluid) {
        return PotionFluidHandler.getRequiredAmountForFilledBottle((ItemStack)BOTTLE, (FluidStack)fluid);
    }

    @Override
    public boolean matches(FluidStack fluid) {
        if (!fluid.getFluid().m_6212_((Fluid)AllFluids.POTION.get()) || fluid.getTag() == null) {
            return false;
        }
        return NBTHelper.readEnum((CompoundTag)fluid.getOrCreateTag(), (String)"Bottle", PotionFluid.BottleType.class) == PotionFluid.BottleType.REGULAR;
    }

    @Override
    public ItemStack assemble(FluidStack fluid) {
        return PotionFluidHandler.fillBottle((ItemStack)BOTTLE.m_41777_(), (FluidStack)fluid.copy());
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.SANDWICH_POTION_SPOUTING_SERIALIZER.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<SandwichPotionSpoutingRecipe> {
        public SandwichPotionSpoutingRecipe fromJson(ResourceLocation id, JsonObject object) {
            return new SandwichPotionSpoutingRecipe(id);
        }

        @Nullable
        public SandwichPotionSpoutingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            return new SandwichPotionSpoutingRecipe(id);
        }

        public void toNetwork(FriendlyByteBuf buffer, SandwichPotionSpoutingRecipe recipe) {
        }
    }
}

