/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.integration.create.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import someassemblyrequired.common.init.ModRecipeTypes;
import someassemblyrequired.common.recipe.SandwichSpoutingRecipe;

public class SandwichFluidSpoutingRecipe
extends SandwichSpoutingRecipe {
    private final FluidIngredient ingredient;
    private final ItemStack result;

    public SandwichFluidSpoutingRecipe(ResourceLocation id, FluidIngredient ingredient, ItemStack result) {
        super(id);
        this.ingredient = ingredient;
        this.result = result;
    }

    @Override
    public int getAmountRequired(FluidStack fluid) {
        return this.ingredient.getRequiredAmount();
    }

    @Override
    public boolean matches(FluidStack fluid) {
        return this.ingredient.test(fluid);
    }

    @Override
    public ItemStack assemble(FluidStack fluid) {
        return this.result.m_41777_();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.SANDWICH_FLUID_SPOUTING_SERIALIZER.get();
    }

    @Override
    public ItemStack m_8043_() {
        return this.result;
    }

    public FluidIngredient getIngredient() {
        return this.ingredient;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<SandwichFluidSpoutingRecipe> {
        public SandwichFluidSpoutingRecipe fromJson(ResourceLocation id, JsonObject object) {
            if (!object.has("fluid")) {
                throw new JsonParseException("Missing 'fluid', expected to find fluid ingredient");
            }
            FluidIngredient ingredient = FluidIngredient.deserialize((JsonElement)object.get("fluid"));
            JsonObject resultObject = GsonHelper.m_13930_((JsonObject)object, (String)"result");
            ItemStack result = CraftingHelper.getItemStack((JsonObject)resultObject, (boolean)true, (boolean)true);
            if (result.m_41619_()) {
                throw new JsonParseException("Resulting item cannot be empty");
            }
            if (result.m_41613_() != 1) {
                throw new JsonParseException("Resulting item must have a count of 1");
            }
            return new SandwichFluidSpoutingRecipe(id, ingredient, result);
        }

        @Nullable
        public SandwichFluidSpoutingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            return new SandwichFluidSpoutingRecipe(id, FluidIngredient.read((FriendlyByteBuf)buffer), buffer.m_130267_());
        }

        public void toNetwork(FriendlyByteBuf buffer, SandwichFluidSpoutingRecipe recipe) {
            recipe.ingredient.write(buffer);
            buffer.m_130055_(recipe.result);
        }
    }
}

