/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.data.recipe.farmersdelight;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import someassemblyrequired.common.init.ModItems;
import someassemblyrequired.common.util.JsonHelper;
import someassemblyrequired.common.util.Util;
import vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult;
import vectorwing.farmersdelight.common.tag.ForgeTags;
import vectorwing.farmersdelight.data.builder.CuttingBoardRecipeBuilder;

public class CuttingRecipeBuilder {
    private static final Set<CuttingRecipeBuilder> RECIPES = new HashSet<CuttingRecipeBuilder>();
    private final List<ChanceResult> results = new ArrayList<ChanceResult>(4);
    private final Ingredient ingredient;
    private final Ingredient tool;
    private SoundEvent soundEvent;

    private CuttingRecipeBuilder(Ingredient ingredient, Ingredient tool, ItemLike mainResult, int count, float chance) {
        this.results.add(new ChanceResult(new ItemStack((ItemLike)mainResult.m_5456_(), count), chance));
        this.ingredient = ingredient;
        this.tool = tool;
    }

    public static void addCuttingRecipes(Consumer<FinishedRecipe> consumer) {
        RECIPES.clear();
        CuttingRecipeBuilder.cut((ItemLike)Items.f_42410_, (ItemLike)ModItems.APPLE_SLICES.get(), 2);
        CuttingRecipeBuilder.cut((ItemLike)Items.f_42406_, (ItemLike)ModItems.BREAD_SLICE.get(), 4);
        CuttingRecipeBuilder.cut((ItemLike)Items.f_42732_, (ItemLike)ModItems.CHOPPED_BEETROOT.get(), 2);
        CuttingRecipeBuilder.cut((ItemLike)Items.f_42619_, (ItemLike)ModItems.CHOPPED_CARROT.get(), 2);
        CuttingRecipeBuilder.cut((ItemLike)Items.f_42677_, (ItemLike)ModItems.CHOPPED_GOLDEN_CARROT.get(), 2);
        CuttingRecipeBuilder.cut((ItemLike)Items.f_42437_, (ItemLike)ModItems.ENCHANTED_GOLDEN_APPLE_SLICES.get(), 2);
        CuttingRecipeBuilder.cut((ItemLike)Items.f_42436_, (ItemLike)ModItems.GOLDEN_APPLE_SLICES.get(), 2);
        CuttingRecipeBuilder.cut((TagKey<Item>)ForgeTags.CROPS_TOMATO, (ItemLike)ModItems.TOMATO_SLICES.get(), 2);
        for (CuttingRecipeBuilder recipe : new HashSet<CuttingRecipeBuilder>(RECIPES)) {
            recipe.build(consumer);
        }
    }

    public static CuttingRecipeBuilder cut(ItemLike ingredient, ItemLike mainResult, int count) {
        return CuttingRecipeBuilder.cut(Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), mainResult, count);
    }

    public static CuttingRecipeBuilder cut(TagKey<Item> ingredient, ItemLike mainResult, int count) {
        return CuttingRecipeBuilder.cut(Ingredient.m_204132_(ingredient), mainResult, count);
    }

    public static CuttingRecipeBuilder cut(Ingredient ingredient, ItemLike mainResult, int count) {
        CuttingRecipeBuilder builder = new CuttingRecipeBuilder(ingredient, Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), mainResult, count, 1.0f);
        RECIPES.add(builder);
        return builder;
    }

    public CuttingRecipeBuilder addResult(ItemLike result) {
        return this.addResult(result, 1);
    }

    public CuttingRecipeBuilder addResult(ItemLike result, int count) {
        this.results.add(new ChanceResult(new ItemStack((ItemLike)result.m_5456_(), count), 1.0f));
        return this;
    }

    public CuttingRecipeBuilder addResultWithChance(ItemLike result, float chance) {
        return this.addResultWithChance(result, chance, 1);
    }

    public CuttingRecipeBuilder addResultWithChance(ItemLike result, float chance, int count) {
        this.results.add(new ChanceResult(new ItemStack((ItemLike)result.m_5456_(), count), chance));
        return this;
    }

    public CuttingRecipeBuilder addSound(SoundEvent soundEvent) {
        this.soundEvent = soundEvent;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        ResourceLocation location = this.results.get(0).getStack().m_41720_().getRegistryName();
        this.build(consumer, Util.id("cutting/%s/".formatted("farmersdelight") + location.m_135815_()));
    }

    public void build(Consumer<FinishedRecipe> consumer, String save) {
        this.build(consumer, new ResourceLocation(save));
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        RECIPES.remove(this);
        String sound = this.soundEvent == null ? "" : this.soundEvent.getRegistryName().toString();
        consumer.accept((FinishedRecipe)new Result(id, this.ingredient, this.tool, this.results, sound));
    }

    public static class Result
    extends CuttingBoardRecipeBuilder.Result {
        public Result(ResourceLocation id, Ingredient ingredient, Ingredient tool, List<ChanceResult> results, String soundEventID) {
            super(id, ingredient, tool, results, soundEventID);
        }

        public void m_7917_(JsonObject json) {
            JsonHelper.addModLoadedCondition(json, "farmersdelight");
            super.m_7917_(json);
        }
    }
}

