/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.data.ingredient;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import someassemblyrequired.common.ingredient.IngredientProperties;
import someassemblyrequired.common.init.ModItems;
import someassemblyrequired.common.init.ModSoundEvents;

public class IngredientBuilder {
    private final Item item;
    @Nullable
    private Component displayName;
    @Nullable
    private Component fullName;
    @Nullable
    private SoundEvent soundEvent;
    private ItemStack displayItem = ItemStack.f_41583_;
    private ItemStack container = ItemStack.f_41583_;

    public IngredientBuilder(Item item) {
        this.item = item;
    }

    public IngredientProperties build() {
        return new IngredientProperties(null, this.displayName, this.fullName, this.displayItem, this.container, this.soundEvent);
    }

    public Item getItem() {
        return this.item;
    }

    public ItemStack getDisplayItem() {
        return this.displayItem;
    }

    public IngredientBuilder setDisplayName(Component displayName) {
        this.displayName = displayName;
        return this;
    }

    public IngredientBuilder setDisplayName(String translationKey) {
        return this.setDisplayName((Component)new TranslatableComponent(translationKey));
    }

    public IngredientBuilder setDisplayName(Item item) {
        return this.setDisplayName(IngredientBuilder.getDefaultTranslationKey(item));
    }

    public IngredientBuilder setCustomDisplayName() {
        return this.setDisplayName(this.getItem());
    }

    public IngredientBuilder setFullName(Component fullName) {
        this.fullName = fullName;
        return this;
    }

    public IngredientBuilder setFullName(String translationKey) {
        return this.setFullName((Component)new TranslatableComponent(translationKey));
    }

    public IngredientBuilder setFullName(Item item) {
        return this.setFullName(IngredientBuilder.getDefaultTranslationKey(item));
    }

    public IngredientBuilder setCustomFullName() {
        return this.setFullName(IngredientBuilder.getDefaultTranslationKey(this.getItem()));
    }

    public IngredientBuilder setDisplayItem(ItemStack displayItem) {
        this.displayItem = displayItem;
        return this;
    }

    public IngredientBuilder setSpread(int color) {
        ItemStack spread = new ItemStack((ItemLike)ModItems.SPREAD.get());
        spread.m_41784_().m_128405_("Color", color);
        return this.setDisplayItem(spread);
    }

    public IngredientBuilder setSpreadSound() {
        return this.setSound((SoundEvent)ModSoundEvents.ADD_SPREAD.get());
    }

    public IngredientBuilder setLeavesSound() {
        return this.setSound((SoundEvent)ModSoundEvents.ADD_LEAVES.get());
    }

    public IngredientBuilder setContainer(ItemStack container) {
        this.container = container;
        return this;
    }

    public IngredientBuilder setContainer(Item item) {
        return this.setContainer(new ItemStack((ItemLike)item));
    }

    public IngredientBuilder setBottled() {
        return this.setContainer(Items.f_42590_);
    }

    public IngredientBuilder setBowled() {
        return this.setContainer(Items.f_42399_);
    }

    public IngredientBuilder setBucketed() {
        return this.setContainer(Items.f_42446_);
    }

    public IngredientBuilder setSound(SoundEvent soundEvent) {
        this.soundEvent = soundEvent;
        return this;
    }

    private static String getDefaultTranslationKey(Item item) {
        ResourceLocation id = item.getRegistryName();
        if ("minecraft".equals(id.m_135827_()) || "some_assembly_required".equals(id.m_135827_())) {
            return "%s.ingredient.%s".formatted("some_assembly_required", id.m_135815_());
        }
        return "%s.ingredient.%s.%s".formatted("some_assembly_required", id.m_135827_(), id.m_135815_());
    }
}

