/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import someassemblyrequired.common.init.ModBlocks;
import someassemblyrequired.common.init.ModItems;
import someassemblyrequired.common.util.Util;
import someassemblyrequired.data.Ingredients;

public class ItemModels
extends ItemModelProvider {
    public ItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "some_assembly_required", existingFileHelper);
    }

    protected void registerModels() {
        Set<Item> items = ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.getRegistryName().m_135827_().equals("some_assembly_required")).collect(Collectors.toSet());
        ItemModels.removeAll(items, (ItemLike)ModItems.SANDWICH.get());
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(ModBlocks.SANDWICH.getId().m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).texture("particle", this.prefixItem("bread_slice"))).transforms().transform(ModelBuilder.Perspective.GUI).rotation(30.0f, 45.0f, 0.0f).scale(0.8f).end().transform(ModelBuilder.Perspective.GROUND).rotation(0.0f, 180.0f, 0.0f).scale(0.5f).end().transform(ModelBuilder.Perspective.HEAD).rotation(0.0f, 180.0f, 0.0f).translation(0.0f, 0.5f, 0.0f).end().transform(ModelBuilder.Perspective.FIXED).rotation(0.0f, 180.0f, 0.0f).translation(0.0f, -4.0f, 0.0f).end().transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(75.0f, 315.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.55f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(0.0f, 315.0f, 0.0f).translation(0.0f, 1.0f, 0.0f).scale(0.5f).end().end();
        ItemModels.removeAll(items, (ItemLike)ModItems.ENCHANTED_GOLDEN_APPLE_SLICES.get());
        ItemModels.removeAll(items, (ItemLike)ModItems.SPREAD.get());
        ItemModelBuilder builder = this.addGeneratedModel((Item)ModItems.SPREAD.get());
        ItemModels.removeAll(items, Ingredients.itemsWithCustomModel.toArray(new ItemLike[0]));
        List<Item> itemsWithCustomModel = Ingredients.itemsWithCustomModel;
        for (int i = 0; i < itemsWithCustomModel.size(); ++i) {
            Item item2 = itemsWithCustomModel.get(i);
            if ("some_assembly_required".equals(item2.getRegistryName().m_135827_())) {
                this.addGeneratedModel(item2);
            }
            String id = "%s/%s".formatted(item2.getRegistryName().m_135827_(), item2.getRegistryName().m_135815_());
            String path = "ingredient/" + id;
            builder.override().model((ModelFile)this.addGeneratedModel(path, this.prefixItem(path))).predicate(new ResourceLocation("custom_model_data"), (float)(i + 1)).end();
        }
        ItemModels.removeAll(items, (ItemLike)ModItems.ENCHANTED_GOLDEN_APPLE_SLICES.get());
        this.addGeneratedModel("enchanted_golden_apple_slices", this.prefixItem("golden_apple_slices"));
        ItemModels.removeAll(items, (T item) -> item instanceof BlockItem).forEach(block -> this.withExistingParent(block.getRegistryName().m_135815_(), this.prefixBlock(block.getRegistryName().m_135815_())));
        items.forEach(this::addGeneratedModel);
    }

    private ResourceLocation prefixBlock(String path) {
        return Util.id("block/" + path);
    }

    private ResourceLocation prefixItem(String path) {
        return Util.id("item/" + path);
    }

    private ItemModelBuilder addGeneratedModel(Item item) {
        String name = item.getRegistryName().m_135815_();
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("item/" + name, "item/generated")).texture("layer0", this.prefixItem(name));
    }

    private ItemModelBuilder addGeneratedModel(String name, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, "item/generated")).texture("layer0", texture);
    }

    private static Collection<Item> removeAll(Set<Item> set, ItemLike ... items) {
        Set<Item> result = Arrays.stream(items).map(ItemLike::m_5456_).collect(Collectors.toSet());
        set.removeAll(result);
        if (result.size() != items.length) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    private static <T> Collection<T> removeAll(Set<T> set, Predicate<T> pred) {
        Set result = set.stream().filter(pred).collect(Collectors.toSet());
        set.removeAll(result);
        if (result.size() <= 0) {
            throw new IllegalArgumentException();
        }
        return result;
    }
}

