/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.common.ingredient.IngredientProperties;
import someassemblyrequired.common.init.ModItems;
import someassemblyrequired.data.ingredient.CreateIngredients;
import someassemblyrequired.data.ingredient.FarmersDelightIngredients;
import someassemblyrequired.data.ingredient.IngredientBuilder;

public record Ingredients(DataGenerator generator) implements DataProvider
{
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<Item, IngredientBuilder> ingredients = new HashMap<Item, IngredientBuilder>();
    public static final List<Item> itemsWithCustomModel = new ArrayList<Item>();

    private void addIngredients() {
        ingredients.clear();
        for (int i = 0; i < itemsWithCustomModel.size(); ++i) {
            Item item2 = itemsWithCustomModel.get(i);
            ItemStack displayItem = new ItemStack((ItemLike)ModItems.SPREAD.get());
            displayItem.m_41784_().m_128405_("CustomModelData", i + 1);
            this.builder(item2).setDisplayItem(displayItem);
        }
        new CreateIngredients(ingredients).addIngredients();
        new FarmersDelightIngredients(ingredients).addIngredients();
        ItemStack displayItem = ingredients.get(ModItems.GOLDEN_APPLE_SLICES.get()).getDisplayItem().m_41777_();
        displayItem.m_41784_().m_128379_("HasEffect", true);
        this.builder((Item)ModItems.ENCHANTED_GOLDEN_APPLE_SLICES.get()).setDisplayItem(displayItem);
        this.builder(Items.f_42734_).setBowled().setSpread(9175075).setSpreadSound();
        this.builder(Items.f_42400_).setBowled().setSpread(11367505).setSpreadSound();
        this.builder(Items.f_42699_).setBowled().setSpread(12546612).setSpreadSound();
        this.builder(Items.f_42718_).setBowled().setSpread(4169344).setSpreadSound();
        this.builder(Items.f_42787_).setCustomFullName().setBottled().setSpread(15771918).setSpreadSound();
        this.builder(Items.f_42455_).setCustomFullName().setBucketed().setSpread(0xEEFDFF);
        Arrays.asList((Item)ModItems.TOASTED_BREAD_SLICE.get(), (Item)ModItems.APPLE_SLICES.get(), (Item)ModItems.GOLDEN_APPLE_SLICES.get(), (Item)ModItems.ENCHANTED_GOLDEN_APPLE_SLICES.get(), (Item)ModItems.CHOPPED_CARROT.get(), (Item)ModItems.CHOPPED_GOLDEN_CARROT.get(), (Item)ModItems.CHOPPED_BEETROOT.get(), (Item)ModItems.TOMATO_SLICES.get()).forEach(item -> this.builder((Item)item).setCustomDisplayName());
    }

    private IngredientBuilder builder(Item item) {
        if (ingredients.containsKey(item)) {
            return ingredients.get(item);
        }
        IngredientBuilder builder = new IngredientBuilder(item);
        ingredients.put(item, builder);
        return builder;
    }

    public void m_6865_(HashCache cache) {
        Path outputFolder = this.generator.m_123916_();
        this.addIngredients();
        ingredients.forEach((item, builder) -> {
            IngredientProperties ingredient = builder.build();
            ResourceLocation id = item.getRegistryName();
            Object name = id.m_135815_();
            if (!"minecraft".equals(id.m_135827_()) && !"some_assembly_required".equals(id.m_135827_())) {
                name = id.m_135827_() + "/" + (String)name;
            }
            Path path = outputFolder.resolve("data/%s/%s/ingredients/%s.json".formatted("some_assembly_required", "some_assembly_required", name));
            Ingredients.saveIngredient(cache, ingredient.toJson((Item)item), path);
        });
    }

    private static void saveIngredient(HashCache cache, JsonObject object, Path path) {
        try {
            String json = GSON.toJson((JsonElement)object);
            String hash = f_123918_.hashUnencodedChars((CharSequence)json).toString();
            if (!Objects.equals(cache.m_123938_(path), hash) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                    bufferedwriter.write(json);
                }
            }
            cache.m_123940_(path, hash);
        }
        catch (IOException exception) {
            SomeAssemblyRequired.LOGGER.error("Couldn't save ingredient {}", (Object)path, (Object)exception);
        }
    }

    public String m_6055_() {
        return "Ingredients";
    }

    static {
        itemsWithCustomModel.addAll(Arrays.asList((Item)ModItems.APPLE_SLICES.get(), (Item)ModItems.GOLDEN_APPLE_SLICES.get(), (Item)ModItems.CHOPPED_CARROT.get(), (Item)ModItems.CHOPPED_GOLDEN_CARROT.get(), (Item)ModItems.CHOPPED_BEETROOT.get(), (Item)ModItems.TOMATO_SLICES.get()));
        itemsWithCustomModel.addAll(FarmersDelightIngredients.itemsWithCustomModel);
    }
}

