/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.common.item.sandwich;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;
import someassemblyrequired.common.ingredient.Ingredients;
import someassemblyrequired.common.init.ModItems;
import someassemblyrequired.common.init.ModTags;
import someassemblyrequired.common.item.sandwich.SandwichItemHandler;
import someassemblyrequired.common.util.Util;

public class SandwichNameHelper {
    public static Component getSandwichDisplayName(ItemStack stack) {
        boolean isOpenFacedSandwich;
        Potion potion;
        SandwichItemHandler sandwich = SandwichItemHandler.get((ICapabilityProvider)stack).orElse(null);
        if (sandwich == null || !ForgeRegistries.ITEMS.tags().isKnownTagName(ModTags.SANDWICH_BREAD)) {
            return SandwichNameHelper.translateItem("sandwich", new Object[0]);
        }
        int amountOfBread = SandwichNameHelper.getAmountOfBread(sandwich);
        if (sandwich.size() == amountOfBread) {
            return SandwichNameHelper.getBreadSandwichName(sandwich);
        }
        List<ItemStack> uniqueIngredients = SandwichNameHelper.getUniqueIngredientsExcludingBread(sandwich);
        if (uniqueIngredients.size() == 1 && uniqueIngredients.get(0).m_150930_(Items.f_42589_) && (potion = PotionUtils.m_43579_((ItemStack)uniqueIngredients.get(0))).m_43488_().size() == 1) {
            return SandwichNameHelper.translateItem("potion_sandwich", ((MobEffectInstance)potion.m_43488_().get(0)).m_19544_().m_19482_());
        }
        boolean bl = isOpenFacedSandwich = amountOfBread == 1 && sandwich.size() > 1;
        if (uniqueIngredients.size() > 0 && uniqueIngredients.size() <= 3) {
            Component ingredientList = SandwichNameHelper.listIngredients(uniqueIngredients);
            if (sandwich.isDoubleDeckerSandwich()) {
                return SandwichNameHelper.translateItem("double_decker_ingredients_sandwich", ingredientList);
            }
            if (isOpenFacedSandwich) {
                return SandwichNameHelper.translateItem("open_faced_ingredients_sandwich", ingredientList);
            }
            return SandwichNameHelper.translateItem("ingredients_sandwich", ingredientList);
        }
        if (sandwich.isDoubleDeckerSandwich()) {
            return SandwichNameHelper.translateItem("double_decker_sandwich", new Object[0]);
        }
        if (isOpenFacedSandwich) {
            return SandwichNameHelper.translateItem("open_faced_sandwich", new Object[0]);
        }
        return SandwichNameHelper.translateItem("sandwich", new Object[0]);
    }

    private static List<ItemStack> getUniqueIngredientsExcludingBread(SandwichItemHandler sandwich) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack ingredient : sandwich) {
            if (ingredient.m_204117_(ModTags.SANDWICH_BREAD) || !result.stream().noneMatch(stack -> ItemStack.m_41728_((ItemStack)ingredient, (ItemStack)stack))) continue;
            result.add(ingredient);
        }
        return result;
    }

    private static int getAmountOfBread(SandwichItemHandler sandwich) {
        int result = 0;
        for (ItemStack ingredient : sandwich) {
            if (!ingredient.m_204117_(ModTags.SANDWICH_BREAD)) continue;
            ++result;
        }
        return result;
    }

    private static Component getBreadSandwichName(SandwichItemHandler sandwich) {
        if (sandwich.size() == 3 && sandwich.getStackInSlot(0).m_41720_() != ModItems.TOASTED_BREAD_SLICE.get() && sandwich.getStackInSlot(1).m_41720_() == ModItems.TOASTED_BREAD_SLICE.get() && sandwich.getStackInSlot(2).m_41720_() != ModItems.TOASTED_BREAD_SLICE.get()) {
            return SandwichNameHelper.translateItem("ingredients_sandwich", Ingredients.getDisplayName(sandwich.getStackInSlot(1)));
        }
        return SandwichNameHelper.translateItem("bread_sandwich", new Object[0]);
    }

    private static Component listIngredients(List<ItemStack> ingredients) {
        List ingredientNames = ingredients.stream().map(Ingredients::getDisplayName).collect(Collectors.toList());
        return Util.translate("tooltip.ingredient_list.%s".formatted(ingredientNames.size()), ingredientNames.toArray());
    }

    private static Component translateItem(String name, Object ... args) {
        return new TranslatableComponent("item.%s.%s".formatted("some_assembly_required", name), args);
    }
}

