/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.common.ingredient;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.common.ingredient.IngredientPropertiesManager;
import someassemblyrequired.common.ingredient.behavior.ChorusFruitBehavior;
import someassemblyrequired.common.ingredient.behavior.HoneyBottleBehavior;
import someassemblyrequired.common.ingredient.behavior.IngredientBehavior;
import someassemblyrequired.common.ingredient.behavior.MilkBucketBehavior;
import someassemblyrequired.common.ingredient.behavior.SuspiciousStewBehavior;
import someassemblyrequired.common.init.ModFoods;

public class Ingredients {
    private static final HashMap<Item, IngredientBehavior> INGREDIENT_BEHAVIORS = new HashMap();

    public static void addBehavior(Item item, IngredientBehavior properties) {
        if (INGREDIENT_BEHAVIORS.get(item) != null) {
            SomeAssemblyRequired.LOGGER.error("Multiple ingredient behaviors for item " + item.getRegistryName());
        } else {
            INGREDIENT_BEHAVIORS.put(item, properties);
        }
    }

    public static void addBehaviors() {
        Ingredients.addBehavior(Items.f_42730_, new ChorusFruitBehavior());
        Ingredients.addBehavior(Items.f_42718_, new SuspiciousStewBehavior());
        Ingredients.addBehavior(Items.f_42455_, new MilkBucketBehavior());
        Ingredients.addBehavior(Items.f_42787_, new HoneyBottleBehavior());
    }

    public static boolean canAddToSandwich(ItemStack item) {
        return !item.m_41619_() && (item.m_41614_() || IngredientPropertiesManager.get(item) != null);
    }

    public static FoodProperties getFood(ItemStack item, @Nullable LivingEntity entity) {
        FoodProperties result = IngredientPropertiesManager.getOrDefault(item).getFood(item, entity);
        return result == null ? ModFoods.EMPTY : result;
    }

    public static void onFoodEaten(ItemStack item, LivingEntity entity) {
        if (INGREDIENT_BEHAVIORS.containsKey(item.m_41720_())) {
            INGREDIENT_BEHAVIORS.get(item.m_41720_()).onEaten(item, entity);
        }
    }

    public static Component getDisplayName(ItemStack item) {
        return IngredientPropertiesManager.getOrDefault(item).getDisplayName(item);
    }

    public static Component getFullName(ItemStack item) {
        return IngredientPropertiesManager.getOrDefault(item).getFullName(item);
    }

    public static ItemStack getDisplayItem(ItemStack item) {
        return IngredientPropertiesManager.getOrDefault(item).getDisplayItem(item);
    }

    public static ItemStack getContainer(ItemStack item) {
        return IngredientPropertiesManager.getOrDefault(item).getContainer(item);
    }

    public static boolean hasContainer(ItemStack item) {
        return !Ingredients.getContainer(item).m_41619_();
    }

    public static void playApplySound(ItemStack item, Level level, @Nullable Player player, BlockPos pos) {
        IngredientPropertiesManager.getOrDefault(item).playSound(level, player, pos, 1.0f);
    }

    public static void playRemoveSound(ItemStack item, Level level, @Nullable Player player, BlockPos pos) {
        IngredientPropertiesManager.getOrDefault(item).playSound(level, player, pos, 1.2f);
    }
}

