/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.common.block.sandwich;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import someassemblyrequired.common.block.sandwich.SandwichBlock;
import someassemblyrequired.common.config.ModConfig;
import someassemblyrequired.common.ingredient.Ingredients;
import someassemblyrequired.common.init.ModBlockEntityTypes;
import someassemblyrequired.common.init.ModBlocks;
import someassemblyrequired.common.init.ModItems;
import someassemblyrequired.common.init.ModSoundEvents;
import someassemblyrequired.common.item.sandwich.SandwichItemHandler;
import someassemblyrequired.common.util.Util;

public class SandwichBlockEntity
extends BlockEntity {
    private final SandwichItemHandler sandwich = new ItemHandler();
    private final LazyOptional<SandwichItemHandler> itemHandler = LazyOptional.of(() -> this.sandwich);

    public SandwichBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.SANDWICH.get(), pos, state);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (player.m_21120_(InteractionHand.OFF_HAND).m_41619_() && player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            this.removeItem(player);
            return InteractionResult.SUCCESS;
        }
        return this.addItem(player, hand);
    }

    private void removeItem(Player player) {
        if (this.f_58857_ == null) {
            return;
        }
        ItemStack stack = this.sandwich.top();
        Ingredients.playRemoveSound(stack, this.f_58857_, player, this.m_58899_());
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.sandwich.pop();
        BlockPos pos = this.m_58899_();
        if (!Ingredients.hasContainer(stack) && !player.m_7500_()) {
            double y = (double)pos.m_123342_() + Math.max(0.2, (double)this.sandwich.size() * 0.03125 - 0.2);
            ItemEntity item = new ItemEntity(this.f_58857_, (double)pos.m_123341_() + 0.5, y, (double)pos.m_123343_() + 0.5, stack);
            item.m_32010_(5);
            this.f_58857_.m_7967_((Entity)item);
        }
        this.updateHeight();
    }

    private InteractionResult addItem(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_41619_()) {
            return InteractionResult.PASS;
        }
        ItemStack itemToAdd = player.m_21120_(hand).m_41777_();
        itemToAdd.m_41764_(1);
        if (itemToAdd.m_150930_((Item)ModItems.SANDWICH.get())) {
            this.addSandwich(player, hand, itemToAdd);
            this.updateHeight();
            return InteractionResult.SUCCESS;
        }
        if (!Ingredients.canAddToSandwich(itemToAdd)) {
            return InteractionResult.PASS;
        }
        if (this.sandwich.size() >= (Integer)ModConfig.server.maximumSandwichHeight.get()) {
            player.m_5661_((Component)Util.translate("message.full_sandwich", new Object[0]), true);
            return InteractionResult.SUCCESS;
        }
        this.addSingleItem(player, hand, itemToAdd);
        this.updateHeight();
        return InteractionResult.SUCCESS;
    }

    private void addSingleItem(Player player, InteractionHand hand, ItemStack stack) {
        if (this.f_58857_ == null) {
            return;
        }
        Ingredients.playApplySound(stack, this.f_58857_, player, this.m_58899_());
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.sandwich.add(stack);
        SandwichBlockEntity.shrinkHeldItem(player, hand);
    }

    private void addSandwich(Player player, InteractionHand hand, ItemStack stack) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        SandwichItemHandler.get((ICapabilityProvider)stack).ifPresent(handler -> {
            if (!this.sandwich.canAdd((SandwichItemHandler)handler)) {
                player.m_5661_((Component)Util.translate("message.full_sandwich", new Object[0]), true);
            } else {
                this.sandwich.add((SandwichItemHandler)handler);
                SandwichBlockEntity.shrinkHeldItem(player, hand);
                this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSoundEvents.ADD_ITEM.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        });
    }

    private static void shrinkHeldItem(Player player, InteractionHand hand) {
        if (!player.m_7500_()) {
            ItemStack item = player.m_21120_(hand);
            ItemStack container = Ingredients.getContainer(item).m_41777_();
            item.m_41774_(1);
            if (!container.m_41619_()) {
                if (player.m_21120_(hand).m_41619_()) {
                    player.m_21008_(hand, container);
                } else if (!player.m_150109_().m_36054_(container)) {
                    player.m_36176_(container, false);
                }
            }
        }
    }

    public void updateHeight() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.sandwich.isEmpty()) {
            this.f_58857_.m_7471_(this.m_58899_(), false);
        } else {
            SandwichItemHandler.get((ICapabilityProvider)this.f_58857_.m_7702_(this.m_58899_())).ifPresent(sandwich -> {
                BlockState newState;
                BlockState state = this.f_58857_.m_8055_(this.m_58899_());
                if (state.m_60713_((Block)ModBlocks.SANDWICH.get()) && !((Integer)(newState = (BlockState)state.m_61124_((Property)SandwichBlock.SIZE, (Comparable)Integer.valueOf(SandwichBlockEntity.getSizeFromHeight(sandwich.size())))).m_61143_((Property)SandwichBlock.SIZE)).equals(state.m_61143_((Property)SandwichBlock.SIZE))) {
                    this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)SandwichBlock.SIZE, (Comparable)Integer.valueOf(SandwichBlockEntity.getSizeFromHeight(sandwich.size()))), 3);
                }
            });
        }
    }

    static int getSizeFromHeight(int sandwichHeight) {
        int size = Math.min(32, Math.max(2, sandwichHeight)) + 1;
        return size / 2;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.sandwich.deserializeNBT(tag.m_128437_("Sandwich", 10));
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("Sandwich", (Tag)this.sandwich.serializeNBT());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    private class ItemHandler
    extends SandwichItemHandler {
        private ItemHandler() {
        }

        @Override
        protected void onContentsChanged() {
            super.onContentsChanged();
            Level level = SandwichBlockEntity.this.m_58904_();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.m_7726_().m_8450_(SandwichBlockEntity.this.m_58899_());
                SandwichBlockEntity.this.m_6596_();
            }
        }
    }
}

