/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.common.block.sandwich;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import someassemblyrequired.common.block.SandwichAssemblyTableBlock;
import someassemblyrequired.common.block.WaterLoggableHorizontalBlock;
import someassemblyrequired.common.block.sandwich.SandwichBlockEntity;
import someassemblyrequired.common.init.ModBlockEntityTypes;
import someassemblyrequired.common.init.ModItems;
import someassemblyrequired.common.item.sandwich.SandwichItemHandler;

public class SandwichBlock
extends WaterLoggableHorizontalBlock
implements EntityBlock {
    public static final IntegerProperty SIZE = IntegerProperty.m_61631_((String)"size", (int)1, (int)16);
    private static final VoxelShape[] SHAPES = SandwichBlock.createShapes();

    public SandwichBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)SIZE, (Comparable)Integer.valueOf(1)));
    }

    private static VoxelShape[] createShapes() {
        VoxelShape[] result = new VoxelShape[16];
        for (int i = 0; i < 16; ++i) {
            result[i] = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)(i + 1), (double)12.0);
        }
        return result;
    }

    public static ItemStack createSandwich(BlockEntity blockEntity) {
        if (!(blockEntity instanceof SandwichBlockEntity)) {
            return ItemStack.f_41583_;
        }
        SandwichBlockEntity sandwichAssemblyTable = (SandwichBlockEntity)blockEntity;
        ItemStack sandwich = new ItemStack((ItemLike)ModItems.SANDWICH.get());
        sandwichAssemblyTable.m_183515_(sandwich.m_41698_("BlockEntityTag"));
        return sandwich;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SIZE});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        CompoundTag tag = context.m_43722_().m_41737_("BlockEntityTag");
        if (tag != null) {
            int sandwichHeight = tag.m_128437_("Sandwich", 10).size();
            return (BlockState)super.m_5573_(context).m_61124_((Property)SIZE, (Comparable)Integer.valueOf(SandwichBlockEntity.getSizeFromHeight(sandwichHeight)));
        }
        return super.m_5573_(context);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (level.m_8055_(pos.m_7495_()).m_60734_() instanceof SandwichAssemblyTableBlock) {
            return level.m_141902_(pos, (BlockEntityType)ModBlockEntityTypes.SANDWICH.get()).map(blockEntity -> blockEntity.interact(player, hand)).orElse(InteractionResult.FAIL);
        }
        return super.m_6227_(state, level, pos, player, hand, blockHitResult);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(super.m_7381_(state, builder));
        SandwichItemHandler.get((ICapabilityProvider)builder.m_78982_(LootContextParams.f_81462_)).map(sandwich -> {
            if (sandwich.size() != 1) {
                return sandwich.getAsItem();
            }
            return sandwich.getStackInSlot(0);
        }).ifPresent(drops::add);
        return drops;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return SandwichBlock.createSandwich(world.m_7702_(pos));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES[(Integer)state.m_61143_((Property)SIZE) - 1];
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SandwichBlockEntity(pos, state);
    }
}

