/*
 * Decompiled with CFR 0.152.
 */
package com.coldspell.mobilebeacon118.util;

import com.coldspell.mobilebeacon118.items.MobileBeaconItem;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SoulboundHandler {
    private static final HashMap<Player, SoulboundHandler> handlerMap = new HashMap();
    public static final String soulboundTag = "SoulboundItems";
    public static final String storedStacksTag = "StoredStacks";
    public static final String stackTag = "Stack";
    private final Player player;

    public static SoulboundHandler getOrCreateSoulboundHandler(Player player) {
        if (SoulboundHandler.getSoulboundHandler(player) != null) {
            return SoulboundHandler.getSoulboundHandler(player);
        }
        return SoulboundHandler.createSoulboundHandler(player);
    }

    @Nullable
    public static SoulboundHandler getSoulboundHandler(Player player) {
        return handlerMap.get(player);
    }

    public static SoulboundHandler createSoulboundHandler(Player player) {
        SoulboundHandler newHandler = new SoulboundHandler(player);
        handlerMap.put(player, newHandler);
        return newHandler;
    }

    public static boolean hasStoredDrops(Player player) {
        return SoulboundHandler.hasSerializedDrops(player);
    }

    private SoulboundHandler(Player playerIn) {
        this.player = playerIn;
    }

    public void retainDrops(Collection<ItemEntity> eventDrops) {
        ArrayList retainedDrops = Lists.newArrayList();
        for (ItemEntity eventDrop : eventDrops) {
            MobileBeaconItem beaconItem;
            ItemStack item = eventDrop.m_32055_();
            Item item2 = item.m_41720_();
            if (!(item2 instanceof MobileBeaconItem) || !(beaconItem = (MobileBeaconItem)item2).isSoulbound()) continue;
            retainedDrops.add(eventDrop);
        }
        retainedDrops.forEach(dropItem -> eventDrops.remove(dropItem));
        this.serializeDrops(retainedDrops);
    }

    private void serializeDrops(Collection<ItemEntity> drops) {
        CompoundTag soulData = new CompoundTag();
        soulData.m_128405_(storedStacksTag, drops.size());
        int counter = 0;
        for (ItemEntity drop : drops) {
            ItemStack stack = drop.m_32055_().m_41777_();
            if (stack == null) continue;
            CompoundTag serializedStack = stack.serializeNBT();
            soulData.m_128365_(stackTag + counter, (Tag)serializedStack);
            ++counter;
        }
        this.player.getPersistentData().m_128365_(soulboundTag, (Tag)soulData);
    }

    private static boolean hasSerializedDrops(Player player) {
        return player.getPersistentData().m_128441_(soulboundTag);
    }

    private List<ItemStack> deserializeDrops() {
        int counter;
        ArrayList deserialized = Lists.newArrayList();
        CompoundTag soulData = this.player.getPersistentData().m_128469_(soulboundTag);
        for (int c = counter = soulData.m_128451_(storedStacksTag) - 1; c >= 0; --c) {
            CompoundTag nbt = soulData.m_128469_(stackTag + c);
            ItemStack stack = ItemStack.m_41712_((CompoundTag)nbt);
            if (!stack.m_41619_()) {
                deserialized.add(stack);
            }
            soulData.m_128473_(stackTag + c);
        }
        this.player.getPersistentData().m_128473_(soulboundTag);
        return deserialized;
    }

    public void transferItems(Player rebornPlayer) {
        List<ItemStack> retainedDrops = this.deserializeDrops();
        if (retainedDrops.isEmpty()) {
            return;
        }
        for (ItemStack item : retainedDrops) {
            rebornPlayer.m_150109_().m_36054_(item);
        }
        handlerMap.remove(this.player);
    }
}

