/*
 * Decompiled with CFR 0.152.
 */
package com.coldspell.mobilebeacon118.items;

import com.coldspell.mobilebeacon118.items.BeaconHelper;
import com.coldspell.mobilebeacon118.util.ConfigurationHandler;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class MobileBeaconItem
extends Item {
    protected final int beaconLevel;
    protected final int rank;
    protected final boolean isSoulbound;

    public MobileBeaconItem(Item.Properties builder, int beaconLevel, int rank, boolean isSoulbound) {
        super(builder);
        this.beaconLevel = beaconLevel;
        this.rank = rank;
        this.isSoulbound = isSoulbound;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.disc01").m_130940_(ChatFormatting.AQUA));
            if (this.rank == 1) {
                list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.upgrade").m_130940_(ChatFormatting.DARK_AQUA));
            }
            if (this.beaconLevel == 5) {
                list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.immunetofire").m_130940_(ChatFormatting.DARK_PURPLE));
            }
            if (((Boolean)ConfigurationHandler.ITEMS.aura.get()).booleanValue()) {
                list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.range").m_130940_(ChatFormatting.BLUE));
                list.add((Component)new TextComponent("" + this.getRange()).m_130940_(ChatFormatting.BLUE));
            }
        } else {
            if (((Boolean)ConfigurationHandler.ITEMS.aura.get()).booleanValue()) {
                list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.bonusnear").m_130940_(ChatFormatting.DARK_BLUE));
            } else {
                list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.bonusplayer").m_130940_(ChatFormatting.DARK_BLUE));
            }
            if (this.beaconLevel >= 1) {
                if (this.rank < 2) {
                    list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.bonus.regen"));
                    list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.bonus.speed"));
                } else {
                    list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.bonus.regen2"));
                    list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.bonus.speed2"));
                }
            }
            if (this.beaconLevel >= 2) {
                if (this.rank < 2) {
                    list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.bonus.jump"));
                } else {
                    list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.bonus.jump2"));
                }
            }
            if (this.beaconLevel >= 3) {
                if (this.rank < 2) {
                    list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.bonus.haste"));
                } else {
                    list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.bonus.haste2"));
                }
            }
            if (this.beaconLevel >= 4) {
                if (this.rank < 2) {
                    list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.bonus.strength"));
                } else {
                    list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.bonus.strength2"));
                }
            }
            if (this.beaconLevel >= 5) {
                if (this.rank < 2) {
                    list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.bonus.resist"));
                } else {
                    list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.bonus.resist2"));
                }
            }
            if (this.isTogglesOn(itemStack)) {
                list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.on"));
            } else {
                list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.off"));
            }
            list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.toggle"));
            if ((Integer)ConfigurationHandler.ITEMS.xpPerSec.get() > 0) {
                list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.cost").m_130940_(ChatFormatting.GOLD));
                list.add((Component)new TranslatableComponent(((Integer)ConfigurationHandler.ITEMS.xpPerSec.get()).toString()).m_130940_(ChatFormatting.GOLD));
            }
            list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.holdshift").m_130940_(ChatFormatting.GRAY));
            if (this.isSoulbound) {
                list.add((Component)new TranslatableComponent("tooltip.mobilebeacon118.soulbound").m_130940_(ChatFormatting.GRAY));
            }
        }
        super.m_7373_(itemStack, level, list, flag);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack mainStack = player.m_21205_();
        if (!level.f_46443_) {
            this.toggle(mainStack);
        }
        return super.m_7203_(level, player, hand);
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int p_41407_, boolean p_41408_) {
        if (!level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_7500_()) {
                if (this.isTogglesOn(itemStack)) {
                    if (this.getTick(itemStack) <= 0) {
                        if (((Boolean)ConfigurationHandler.ITEMS.aura.get()).booleanValue()) {
                            BeaconHelper.applyAura(level, player.m_142538_(), this.beaconLevel, this.rank);
                        } else {
                            BeaconHelper.applyEffects(player, this.beaconLevel, this.rank);
                        }
                        this.resetTick(itemStack);
                    }
                    this.tick(itemStack);
                }
            } else {
                if (this.isTogglesOn(itemStack) & player.f_36079_ > (Integer)ConfigurationHandler.ITEMS.xpPerSec.get()) {
                    if (this.getTick(itemStack) <= 0) {
                        if (((Boolean)ConfigurationHandler.ITEMS.aura.get()).booleanValue()) {
                            BeaconHelper.applyAura(level, player.m_142538_(), this.beaconLevel, this.rank);
                        } else {
                            BeaconHelper.applyEffects(player, this.beaconLevel, this.rank);
                        }
                        if (!player.m_7500_()) {
                            player.m_6756_(-((Integer)ConfigurationHandler.ITEMS.xpPerSec.get()).intValue());
                        }
                        this.resetTick(itemStack);
                    }
                    this.tick(itemStack);
                }
                if (player.f_36079_ <= (Integer)ConfigurationHandler.ITEMS.xpPerSec.get()) {
                    this.toggleOff(itemStack);
                }
            }
        }
        super.m_6883_(itemStack, level, entity, p_41407_, p_41408_);
    }

    public boolean m_5812_(ItemStack p_41453_) {
        return this.rank == 2;
    }

    public boolean m_41475_() {
        return this.beaconLevel == 5;
    }

    private void toggle(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        if (tag.m_128471_("toggle")) {
            tag.m_128379_("toggle", false);
            tag.m_128405_("tick", 0);
        } else {
            tag.m_128379_("toggle", true);
        }
    }

    private void toggleOff(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128379_("toggle", false);
    }

    private boolean isTogglesOn(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        return tag.m_128471_("toggle");
    }

    private void tick(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128405_("tick", this.getTick(itemStack) - 1);
    }

    private int getTick(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        return tag.m_128451_("tick");
    }

    private void resetTick(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128405_("tick", 200);
    }

    private int getRange() {
        return this.beaconLevel * 10;
    }

    public boolean isSoulbound() {
        return this.isSoulbound;
    }
}

