/*
 * Decompiled with CFR 0.152.
 */
package andrews.online_detector.block_entities.render;

import andrews.online_detector.block_entities.AdvancedOnlineDetectorBlockEntity;
import andrews.online_detector.block_entities.model.EyeModel;
import andrews.online_detector.objects.blocks.AdvancedOnlineDetectorBlock;
import andrews.online_detector.util.NetworkUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AdvancedOnlineDetectorBlockEntityRenderer
implements BlockEntityRenderer<AdvancedOnlineDetectorBlockEntity> {
    public static final ResourceLocation EYE_TEXTURE = new ResourceLocation("online_detector", "textures/block/eye.png");
    private static EyeModel eyeModel;

    public AdvancedOnlineDetectorBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        eyeModel = new EyeModel(context.m_173582_(EyeModel.EYE_LAYER_LOCATION));
    }

    public void render(AdvancedOnlineDetectorBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState blockstate;
        Direction facing = Direction.NORTH;
        if (blockEntity.m_58898_() && (blockstate = blockEntity.m_58904_().m_8055_(blockEntity.m_58899_())).m_60734_() instanceof AdvancedOnlineDetectorBlock) {
            facing = (Direction)blockstate.m_61143_((Property)AdvancedOnlineDetectorBlock.HORIZONTAL_FACING);
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        switch (facing) {
            default: {
                poseStack.m_85845_(Vector3f.f_122224_.m_122240_(90.0f));
                break;
            }
            case SOUTH: {
                poseStack.m_85845_(Vector3f.f_122224_.m_122240_(270.0f));
                break;
            }
            case WEST: {
                break;
            }
            case EAST: {
                poseStack.m_85845_(Vector3f.f_122224_.m_122240_(180.0f));
            }
        }
        if (blockEntity.m_58898_()) {
            blockstate = blockEntity.m_58904_().m_8055_(blockEntity.m_58899_());
            if (blockstate.m_60734_() instanceof AdvancedOnlineDetectorBlock) {
                AdvancedOnlineDetectorBlockEntityRenderer.renderEye(blockEntity.m_58904_(), blockstate, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
            }
        } else {
            AdvancedOnlineDetectorBlockEntityRenderer.renderEye(blockEntity.m_58904_(), partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        }
        poseStack.m_85837_(0.0, 0.5, -0.25);
        AdvancedOnlineDetectorBlockEntityRenderer.renderPlayerFace(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
        poseStack.m_85849_();
    }

    private static void renderEye(Level level, BlockState state, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_85841_(1.0f, -1.0f, -1.0f);
        if (((Boolean)state.m_61143_((Property)AdvancedOnlineDetectorBlock.IS_ACTIVE)).booleanValue()) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_((float)Math.cos(((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTick) / 4.0f) * 2.0f));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_((float)Math.sin(((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTick) / 4.0f) * 2.0f));
        }
        poseStack.m_85837_(0.0, -1.0, 0.0);
        poseStack.m_85837_(0.0, -1.3125, 0.0);
        VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)EYE_TEXTURE));
        eyeModel.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    private static void renderEye(Level level, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_85841_(1.0f, -1.0f, -1.0f);
        poseStack.m_85837_(0.0, -1.0, 0.0);
        poseStack.m_85837_(0.0, -1.3125, 0.0);
        VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)EYE_TEXTURE));
        eyeModel.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    private static void renderPlayerFace(AdvancedOnlineDetectorBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity.getOwnerUUID() != null && blockEntity.getOwnerName() != null && blockEntity.getOwnerHead().m_41720_() == Items.f_41852_) {
            NetworkUtil.setPlayerHeadMessage(blockEntity.m_58899_(), AdvancedOnlineDetectorBlockEntityRenderer.getCustomHead(blockEntity.getOwnerName()));
        }
        int i = (int)blockEntity.m_58899_().m_121878_();
        if (blockEntity.getOwnerHead().m_41720_() != Items.f_41852_) {
            Minecraft.m_91087_().m_91291_().m_174269_(blockEntity.getOwnerHead(), ItemTransforms.TransformType.FIXED, packedLight, packedOverlay, poseStack, bufferSource, i);
        }
    }

    private static ItemStack getCustomHead(String playerName) {
        ItemStack customHead = new ItemStack((ItemLike)Items.f_42680_);
        customHead.m_41751_(new CompoundTag());
        customHead.m_41783_().m_128359_("SkullOwner", playerName);
        return customHead;
    }
}

