/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.item;

import dev.murad.shipping.util.LocoRoute;
import dev.murad.shipping.util.LocoRouteNode;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocoRouteItem
extends Item {
    private static final Logger log = LogManager.getLogger(LocoRouteItem.class);
    private static final String ROUTE_NBT = "route";

    public LocoRouteItem(Item.Properties properties) {
        super(properties);
    }

    private boolean removeAndDisplay(@Nullable Player player, LocoRoute route, BlockPos pos) {
        boolean removed = route.removeIf(n -> n.isAt(pos));
        if (removed && player != null) {
            player.m_5661_((Component)new TranslatableComponent("item.littlelogistics.locomotive_route.removed", new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), false);
        }
        return removed;
    }

    private void addAndDisplay(@Nullable Player player, LocoRoute route, BlockPos pos, Level level) {
        if (level.m_8055_(pos).m_60734_() instanceof BaseRailBlock) {
            if (player != null) {
                player.m_5661_((Component)new TranslatableComponent("item.littlelogistics.locomotive_route.added", new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), false);
            }
            route.add(LocoRouteNode.fromBlocKPos(pos));
        }
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        if (pContext.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = pContext.m_43722_();
        if (stack.m_41720_() == this) {
            boolean shouldCheckAboveOnRemove;
            BlockPos target = pContext.m_8083_();
            LocoRoute route = LocoRouteItem.getRoute(stack);
            Player player = pContext.m_43723_();
            Block targetBlock = pContext.m_43725_().m_8055_(target).m_60734_();
            boolean bl = shouldCheckAboveOnRemove = !(targetBlock instanceof BaseRailBlock);
            if (!(this.removeAndDisplay(player, route, target) || shouldCheckAboveOnRemove && this.removeAndDisplay(player, route, target.m_7494_()))) {
                this.addAndDisplay(player, route, target, pContext.m_43725_());
            }
            this.saveRoute(stack, route);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void saveRoute(ItemStack stack, LocoRoute route) {
        if (route.isEmpty()) {
            stack.m_41751_(null);
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_(ROUTE_NBT, (Tag)route.toNBT());
    }

    public static LocoRoute getRoute(ItemStack stack) {
        if (stack.m_41783_() != null) {
            return LocoRoute.fromNBT(stack.m_41783_().m_128469_(ROUTE_NBT));
        }
        return new LocoRoute();
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TranslatableComponent("item.littlelogistics.locomotive_route.description"));
        tooltip.add((Component)new TranslatableComponent("item.littlelogistics.locomotive_route.num_nodes", new Object[]{LocoRouteItem.getRoute(stack).size()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)));
    }
}

