/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.render.train;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import dev.murad.shipping.entity.custom.train.AbstractTrainCarEntity;
import dev.murad.shipping.entity.models.ChainModel;
import dev.murad.shipping.entity.render.RenderWithAttachmentPoints;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class TrainCarRenderer<T extends AbstractTrainCarEntity>
extends EntityRenderer<T>
implements RenderWithAttachmentPoints<T> {
    private final EntityModel<T> entityModel;
    private final ResourceLocation texture;
    private static final ResourceLocation CHAIN_TEXTURE = new ResourceLocation("littlelogistics", "textures/entity/chain.png");
    private final ChainModel chainModel;

    public TrainCarRenderer(EntityRendererProvider.Context context, Function<ModelPart, EntityModel> baseModel, ModelLayerLocation layerLocation, String baseTexture) {
        super(context);
        this.chainModel = new ChainModel(context.m_174023_(ChainModel.LAYER_LOCATION));
        this.entityModel = baseModel.apply(context.m_174023_(layerLocation));
        this.texture = new ResourceLocation("littlelogistics", baseTexture);
    }

    public void render(T car, float yaw, float pPartialTicks, PoseStack pose, MultiBufferSource buffer, int pPackedLight) {
        if (((AbstractTrainCarEntity)car).getDominant().isPresent()) {
            return;
        }
        pose.m_85836_();
        Object t = car;
        Pair<Vec3, Vec3> attachmentPoints = this.renderCarAndGetAttachmentPoints(car, yaw, pPartialTicks, pose, buffer, pPackedLight);
        while (((AbstractTrainCarEntity)t).getDominated().isPresent()) {
            AbstractTrainCarEntity nextT = ((AbstractTrainCarEntity)t).getDominated().get();
            EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)nextT);
            if (renderer instanceof RenderWithAttachmentPoints) {
                RenderWithAttachmentPoints attachmentRenderer = (RenderWithAttachmentPoints)renderer;
                Vec3 nextTPos = nextT.m_20318_(pPartialTicks);
                Vec3 tPos = t.m_20318_(pPartialTicks);
                Vec3 offset = nextTPos.m_82546_(tPos);
                pose.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
                Pair<Vec3, Vec3> newAttachmentPoints = attachmentRenderer.renderCarAndGetAttachmentPoints(nextT, nextT.m_146908_(), pPartialTicks, pose, buffer, pPackedLight);
                Vec3 from = (Vec3)newAttachmentPoints.getFirst();
                Vec3 to = (Vec3)attachmentPoints.getSecond();
                pose.m_85836_();
                offset = from.m_82546_(nextTPos);
                pose.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
                this.getAndRenderChain(nextT, from, to, pose, buffer, pPackedLight);
                pose.m_85849_();
                attachmentPoints = newAttachmentPoints;
            }
            t = nextT;
        }
        pose.m_85849_();
    }

    private void getAndRenderChain(AbstractTrainCarEntity car, Vec3 from, Vec3 to, PoseStack matrixStack, MultiBufferSource buffer, int p_225623_6_) {
        matrixStack.m_85836_();
        Vec3 vec = from.m_82505_(to);
        double dist = vec.m_82553_();
        int segments = (int)Math.ceil(dist * 4.0);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122270_(-((float)Math.atan2(vec.f_82481_, vec.f_82479_))));
        matrixStack.m_85845_(Vector3f.f_122227_.m_122270_((float)Math.asin(vec.f_82480_ / dist)));
        matrixStack.m_85836_();
        VertexConsumer ivertexbuilderChain = buffer.m_6299_(this.chainModel.m_103119_(CHAIN_TEXTURE));
        for (int i = 1; i < segments; ++i) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)i / 4.0, 0.0, 0.0);
            this.chainModel.m_7695_(matrixStack, ivertexbuilderChain, p_225623_6_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }

    public Pair<Vec3, Vec3> getAttachmentPoints(Vec3 chainCentre, Vec3 trackDirection) {
        return new Pair((Object)chainCentre.m_82549_(trackDirection.m_82490_(0.2)), (Object)chainCentre.m_82549_(trackDirection.m_82490_(-0.2)));
    }

    public boolean shouldRender(T entity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        return true;
    }

    @Override
    public Pair<Vec3, Vec3> renderCarAndGetAttachmentPoints(T car, float yaw, float partialTicks, PoseStack pose, MultiBufferSource buffer, int packedLight) {
        Pair<Vec3, Vec3> attach = new Pair<Vec3, Vec3>((Object)car.m_20318_(partialTicks).m_82520_(0.0, 0.44, 0.0), (Object)car.m_20318_(partialTicks).m_82520_(0.0, 0.44, 0.0));
        pose.m_85836_();
        long i = (long)car.m_142049_() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        float f = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f1 = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f2 = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        pose.m_85837_((double)f, (double)f1, (double)f2);
        double d0 = Mth.m_14139_((double)partialTicks, (double)((AbstractTrainCarEntity)car).f_19790_, (double)car.m_20185_());
        double d1 = Mth.m_14139_((double)partialTicks, (double)((AbstractTrainCarEntity)car).f_19791_, (double)car.m_20186_());
        double d2 = Mth.m_14139_((double)partialTicks, (double)((AbstractTrainCarEntity)car).f_19792_, (double)car.m_20189_());
        double d3 = 0.3f;
        Vec3 pos = car.m_38179_(d0, d1, d2);
        float pitch = Mth.m_14179_((float)partialTicks, (float)((AbstractTrainCarEntity)car).f_19860_, (float)car.m_146909_());
        if (pos != null) {
            Vec3 forwardDir = ((AbstractTrainCarEntity)car).m_38096_(d0, d1, d2, 0.3f);
            Vec3 backDir = ((AbstractTrainCarEntity)car).m_38096_(d0, d1, d2, -0.3f);
            if (forwardDir == null) {
                forwardDir = pos;
            }
            if (backDir == null) {
                backDir = pos;
            }
            Vec3 centre = new Vec3(pos.f_82479_, (forwardDir.f_82480_ + backDir.f_82480_) / 2.0, pos.f_82481_);
            Vec3 offset = centre.m_82492_(d0, d1, d2);
            pose.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
            Vec3 trackDirection = forwardDir.m_82546_(backDir);
            if (trackDirection.m_82553_() != 0.0) {
                trackDirection = trackDirection.m_82541_();
                yaw = (float)(Math.atan2(-trackDirection.f_82481_, -trackDirection.f_82479_) * 180.0 / Math.PI + 90.0);
                pitch = (float)(Math.atan(-trackDirection.f_82480_) * 73.0);
            }
            Vec3 chainCentre = centre.m_82520_(0.0, 0.22, 0.0);
            attach = this.getAttachmentPoints(chainCentre, trackDirection);
        }
        pose.m_85837_(0.0, 0.375, 0.0);
        pose.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - yaw));
        pose.m_85845_(Vector3f.f_122222_.m_122240_(pitch));
        float f5 = (float)car.m_38176_() - partialTicks;
        float f6 = car.m_38169_() - partialTicks;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f5 > 0.0f) {
            pose.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)f5) * f5 * f6 / 10.0f * (float)car.m_38177_()));
        }
        pose.m_85837_(0.0, 1.1, 0.0);
        pose.m_85841_(-1.0f, -1.0f, 1.0f);
        this.entityModel.m_6973_(car, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = buffer.m_6299_(this.entityModel.m_103119_(this.getTextureLocation(car)));
        this.entityModel.m_7695_(pose, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        this.renderAdditional(car, yaw, partialTicks, pose, buffer, packedLight);
        pose.m_85849_();
        return attach;
    }

    protected void renderAdditional(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
    }

    protected Model getModel(T entity) {
        return this.entityModel;
    }

    public ResourceLocation getTextureLocation(T entity) {
        return this.texture;
    }
}

