/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.train.wagon;

import dev.murad.shipping.compatibility.create.CapabilityInjector;
import dev.murad.shipping.compatibility.create.CreateCompatibility;
import dev.murad.shipping.entity.custom.train.wagon.AbstractWagonEntity;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItems;
import javax.annotation.Nonnull;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SeaterCarEntity
extends AbstractWagonEntity {
    private @Nullable LazyOptional<?> createCompatMinecartControllerCapability = null;

    public SeaterCarEntity(EntityType<SeaterCarEntity> p_38087_, Level p_38088_) {
        super(p_38087_, p_38088_);
        this.initCompat();
    }

    public SeaterCarEntity(Level level, Double aDouble, Double aDouble1, Double aDouble2) {
        super((EntityType)ModEntityTypes.SEATER_CAR.get(), level, aDouble, aDouble1, aDouble2);
        this.initCompat();
    }

    private void initCompat() {
        if (CreateCompatibility.enabled()) {
            this.createCompatMinecartControllerCapability = CapabilityInjector.constructMinecartControllerCapability(this);
        }
    }

    @Override
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModItems.SEATER_CAR.get());
    }

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        InteractionResult ret = super.m_6096_(pPlayer, pHand);
        if (ret.m_19077_()) {
            return ret;
        }
        if (pPlayer.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (this.m_20160_()) {
            return InteractionResult.PASS;
        }
        if (!this.f_19853_.f_46443_) {
            return pPlayer.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6025_(int pX, int pY, int pZ, boolean pReceivingPower) {
        if (pReceivingPower) {
            if (this.m_20160_()) {
                this.m_20153_();
            }
            if (this.m_38176_() == 0) {
                this.m_38160_(-this.m_38177_());
                this.m_38154_(10);
                this.m_38109_(50.0f);
                this.m_5834_();
            }
        }
    }

    @Override
    public void m_142687_(Entity.RemovalReason r) {
        if (this.createCompatMinecartControllerCapability != null && CreateCompatibility.enabled()) {
            this.createCompatMinecartControllerCapability.invalidate();
        }
        super.m_142687_(r);
    }

    public void m_7332_(Entity entity) {
        if (this.m_20363_(entity)) {
            if (entity instanceof Player) {
                float f = -0.22f;
                Vec3 vector3d = new Vec3((double)f, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
                entity.m_6034_(this.m_20185_() + vector3d.f_82479_, this.m_20186_(), this.m_20189_() + vector3d.f_82481_);
            } else {
                super.m_7332_(entity);
            }
        }
    }

    private void clampRotation(Entity p_184454_1_) {
        p_184454_1_.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(p_184454_1_.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        p_184454_1_.f_19859_ += f1 - f;
        p_184454_1_.m_146922_(p_184454_1_.m_146908_() + f1 - f);
        p_184454_1_.m_5616_(p_184454_1_.m_146908_());
    }

    public void m_7340_(Entity p_184190_1_) {
        this.clampRotation(p_184190_1_);
    }

    @Override
    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.RIDEABLE;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (CreateCompatibility.enabled() && this.createCompatMinecartControllerCapability != null && CapabilityInjector.isMinecartControllerCapability(cap)) {
            return this.createCompatMinecartControllerCapability.cast();
        }
        return super.getCapability(cap);
    }
}

