/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.world;

import com.github.alexthe668.cloudstorage.block.CSBlockRegistry;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Material;

public class SkyTempleBlockProcessor
extends StructureProcessor {
    private WoodType woodType;
    private DyeColor woolColor1;
    private DyeColor woolColor2;
    private static final Map<DyeColor, Block> DYE_TO_BLOCK = (Map)Util.m_137469_((Object)Maps.newEnumMap(DyeColor.class), p_29841_ -> {
        p_29841_.put(DyeColor.WHITE, Blocks.f_50041_);
        p_29841_.put(DyeColor.ORANGE, Blocks.f_50042_);
        p_29841_.put(DyeColor.MAGENTA, Blocks.f_50096_);
        p_29841_.put(DyeColor.LIGHT_BLUE, Blocks.f_50097_);
        p_29841_.put(DyeColor.YELLOW, Blocks.f_50098_);
        p_29841_.put(DyeColor.LIME, Blocks.f_50099_);
        p_29841_.put(DyeColor.PINK, Blocks.f_50100_);
        p_29841_.put(DyeColor.GRAY, Blocks.f_50101_);
        p_29841_.put(DyeColor.LIGHT_GRAY, Blocks.f_50102_);
        p_29841_.put(DyeColor.CYAN, Blocks.f_50103_);
        p_29841_.put(DyeColor.PURPLE, Blocks.f_50104_);
        p_29841_.put(DyeColor.BLUE, Blocks.f_50105_);
        p_29841_.put(DyeColor.BROWN, Blocks.f_50106_);
        p_29841_.put(DyeColor.GREEN, Blocks.f_50107_);
        p_29841_.put(DyeColor.RED, Blocks.f_50108_);
        p_29841_.put(DyeColor.BLACK, Blocks.f_50109_);
    });

    public SkyTempleBlockProcessor(WoodType woodType, DyeColor woolColor1, DyeColor woolColor2) {
        this.woodType = woodType;
        this.woolColor1 = woolColor1;
        this.woolColor2 = woolColor2;
    }

    protected StructureProcessorType<?> m_6953_() {
        return StructureProcessorType.f_74457_;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader level, BlockPos pos1, BlockPos pos2, StructureTemplate.StructureBlockInfo info1, StructureTemplate.StructureBlockInfo info2, StructurePlaceSettings settings) {
        Random random = settings.m_74399_(info2.f_74675_);
        if (info2.f_74676_.m_60734_() == Blocks.f_50041_) {
            return new StructureTemplate.StructureBlockInfo(info2.f_74675_, DYE_TO_BLOCK.get(this.woolColor1).m_49966_(), info2.f_74677_);
        }
        if (info2.f_74676_.m_60734_() == Blocks.f_50108_) {
            return new StructureTemplate.StructureBlockInfo(info2.f_74675_, DYE_TO_BLOCK.get(this.woolColor2).m_49966_(), info2.f_74677_);
        }
        if (info2.f_74676_.m_60734_() instanceof SlabBlock && info2.f_74676_.m_60767_() == Material.f_76320_) {
            return new StructureTemplate.StructureBlockInfo(info2.f_74675_, this.getWoodSlab(info2.f_74676_), info2.f_74677_);
        }
        if (info2.f_74676_.m_60734_() instanceof FenceBlock) {
            return new StructureTemplate.StructureBlockInfo(info2.f_74675_, this.getWoodFence(info2.f_74676_), info2.f_74677_);
        }
        if (info2.f_74676_.m_60734_() instanceof TrapDoorBlock) {
            return new StructureTemplate.StructureBlockInfo(info2.f_74675_, this.getWoodTrapdoor(info2.f_74676_), info2.f_74677_);
        }
        if (info2.f_74676_.m_60734_() == CSBlockRegistry.CLOUD.get() && random.nextFloat() < 0.1f) {
            return new StructureTemplate.StructureBlockInfo(info2.f_74675_, ((Block)CSBlockRegistry.STATIC_CLOUD.get()).m_49966_(), info2.f_74677_);
        }
        return info2;
    }

    private BlockState getWoodSlab(BlockState in) {
        if (this.woodType == WoodType.f_61830_) {
            return SkyTempleBlockProcessor.getNewStateWithProperties(in, Blocks.f_50398_.m_49966_());
        }
        if (this.woodType == WoodType.f_61832_) {
            return SkyTempleBlockProcessor.getNewStateWithProperties(in, Blocks.f_50400_.m_49966_());
        }
        if (this.woodType == WoodType.f_61831_) {
            return SkyTempleBlockProcessor.getNewStateWithProperties(in, Blocks.f_50399_.m_49966_());
        }
        if (this.woodType == WoodType.f_61834_) {
            return SkyTempleBlockProcessor.getNewStateWithProperties(in, Blocks.f_50401_.m_49966_());
        }
        if (this.woodType == WoodType.f_61835_) {
            return SkyTempleBlockProcessor.getNewStateWithProperties(in, Blocks.f_50403_.m_49966_());
        }
        if (this.woodType == WoodType.f_61833_) {
            return SkyTempleBlockProcessor.getNewStateWithProperties(in, Blocks.f_50402_.m_49966_());
        }
        return in;
    }

    private BlockState getWoodFence(BlockState in) {
        if (this.woodType == WoodType.f_61830_) {
            return SkyTempleBlockProcessor.getNewStateWithProperties(in, Blocks.f_50132_.m_49966_());
        }
        if (this.woodType == WoodType.f_61832_) {
            return SkyTempleBlockProcessor.getNewStateWithProperties(in, Blocks.f_50480_.m_49966_());
        }
        if (this.woodType == WoodType.f_61831_) {
            return SkyTempleBlockProcessor.getNewStateWithProperties(in, Blocks.f_50479_.m_49966_());
        }
        if (this.woodType == WoodType.f_61834_) {
            return SkyTempleBlockProcessor.getNewStateWithProperties(in, Blocks.f_50481_.m_49966_());
        }
        if (this.woodType == WoodType.f_61835_) {
            return SkyTempleBlockProcessor.getNewStateWithProperties(in, Blocks.f_50483_.m_49966_());
        }
        if (this.woodType == WoodType.f_61833_) {
            return SkyTempleBlockProcessor.getNewStateWithProperties(in, Blocks.f_50482_.m_49966_());
        }
        return in;
    }

    private BlockState getWoodTrapdoor(BlockState in) {
        if (this.woodType == WoodType.f_61830_) {
            return SkyTempleBlockProcessor.getNewStateWithProperties(in, Blocks.f_50216_.m_49966_());
        }
        if (this.woodType == WoodType.f_61832_) {
            return SkyTempleBlockProcessor.getNewStateWithProperties(in, Blocks.f_50218_.m_49966_());
        }
        if (this.woodType == WoodType.f_61831_) {
            return SkyTempleBlockProcessor.getNewStateWithProperties(in, Blocks.f_50217_.m_49966_());
        }
        if (this.woodType == WoodType.f_61834_) {
            return SkyTempleBlockProcessor.getNewStateWithProperties(in, Blocks.f_50219_.m_49966_());
        }
        if (this.woodType == WoodType.f_61835_) {
            return SkyTempleBlockProcessor.getNewStateWithProperties(in, Blocks.f_50221_.m_49966_());
        }
        if (this.woodType == WoodType.f_61833_) {
            return SkyTempleBlockProcessor.getNewStateWithProperties(in, Blocks.f_50220_.m_49966_());
        }
        return in;
    }

    private static BlockState getNewStateWithProperties(BlockState copied, BlockState blockstate) {
        for (Property property : copied.m_61147_()) {
            blockstate = blockstate.m_61138_(property) ? (BlockState)blockstate.m_61124_(property, copied.m_61143_(property)) : blockstate;
        }
        return blockstate;
    }
}

