/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.world;

import com.github.alexthe668.cloudstorage.CloudStorage;
import com.github.alexthe668.cloudstorage.block.CSBlockRegistry;
import com.github.alexthe668.cloudstorage.entity.BalloonEntity;
import com.github.alexthe668.cloudstorage.entity.BalloonTieEntity;
import com.github.alexthe668.cloudstorage.entity.CSEntityRegistry;
import com.github.alexthe668.cloudstorage.entity.villager.CSVillagerRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.JigsawReplacementProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BalloonStandPoolElement
extends LegacySinglePoolElement {
    public static final Codec<BalloonStandPoolElement> CODEC = RecordCodecBuilder.create(p_210357_ -> p_210357_.group((App)BalloonStandPoolElement.m_210465_(), (App)BalloonStandPoolElement.m_210462_(), (App)BalloonStandPoolElement.m_210538_()).apply((Applicative)p_210357_, BalloonStandPoolElement::new));

    protected BalloonStandPoolElement(Either<ResourceLocation, StructureTemplate> either, Holder<StructureProcessorList> p_210349_, StructureTemplatePool.Projection p_210350_) {
        super(either, p_210349_, p_210350_);
    }

    public BalloonStandPoolElement(ResourceLocation resourceLocation, Holder<StructureProcessorList> processors) {
        super(Either.left((Object)resourceLocation), processors, StructureTemplatePool.Projection.RIGID);
    }

    public void m_210472_(LevelAccessor accessor, StructureTemplate.StructureBlockInfo structureBlockInfo, BlockPos pos, Rotation rotation, Random random, BoundingBox box) {
        String contents = structureBlockInfo.f_74677_.m_128461_("metadata");
        if (contents.startsWith("balloons")) {
            int secondary = 0;
            try {
                secondary = Integer.parseInt(contents.substring(8));
            }
            catch (Exception e) {
                CloudStorage.LOGGER.warn("could not parse balloon NBT");
            }
            if (accessor instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevel = (ServerLevelAccessor)accessor;
                if (!accessor.m_8055_(structureBlockInfo.f_74675_).m_60795_()) {
                    BalloonTieEntity tie = new BalloonTieEntity((Level)serverLevel.m_6018_(), structureBlockInfo.f_74675_.m_7495_());
                    if (accessor.m_8055_(structureBlockInfo.f_74675_.m_7495_()).m_60734_() == CSBlockRegistry.BALLOON_STAND.get()) {
                        tie.m_6034_(tie.m_20185_(), tie.m_20186_() + (double)0.3f, tie.m_20189_());
                    }
                    int balloons = 1 + random.nextInt(3);
                    tie.setBalloonCount(balloons);
                    ((ServerLevelAccessor)accessor).m_47205_((Entity)tie);
                    int[] colors = this.getBalloonColors(secondary);
                    for (int i = 0; i < balloons; ++i) {
                        BalloonEntity balloon = (BalloonEntity)((EntityType)CSEntityRegistry.BALLOON.get()).m_20615_((Level)serverLevel.m_6018_());
                        balloon.m_6034_((float)structureBlockInfo.f_74675_.m_123341_() + 0.5f, (float)structureBlockInfo.f_74675_.m_123342_() + 0.1f, (float)structureBlockInfo.f_74675_.m_123343_() + 0.5f);
                        balloon.setStringLength(1 + random.nextInt(2));
                        balloon.setBalloonColor(colors[Mth.m_14045_((int)random.nextInt(colors.length), (int)0, (int)(colors.length - 1))]);
                        balloon.setChildId(tie.m_142081_());
                        ((ServerLevelAccessor)accessor).m_47205_((Entity)balloon);
                    }
                }
            }
            accessor.m_7731_(structureBlockInfo.f_74675_, Blocks.f_50016_.m_49966_(), 2);
        }
    }

    private int[] getBalloonColors(int index) {
        switch (index) {
            case 1: {
                return CSVillagerRegistry.getBalloonColorsForVillager(VillagerType.f_35821_);
            }
            case 2: {
                return CSVillagerRegistry.getBalloonColorsForVillager(VillagerType.f_35819_);
            }
            case 3: {
                return CSVillagerRegistry.getBalloonColorsForVillager(VillagerType.f_35822_);
            }
            case 4: {
                return CSVillagerRegistry.getBalloonColorsForVillager(VillagerType.f_35823_);
            }
            case 5: {
                return CSVillagerRegistry.getBalloonColorsForVillager(VillagerType.f_35825_);
            }
        }
        return new int[]{15149353};
    }

    public boolean m_207251_(StructureManager p_210435_, WorldGenLevel p_210436_, StructureFeatureManager p_210437_, ChunkGenerator p_210438_, BlockPos p_210439_, BlockPos p_210440_, Rotation p_210441_, BoundingBox p_210442_, Random p_210443_, boolean p_210444_) {
        StructurePlaceSettings structureplacesettings;
        StructureTemplate structuretemplate = p_210435_.m_74341_((ResourceLocation)this.f_210411_.left().get());
        if (!structuretemplate.m_74536_((ServerLevelAccessor)p_210436_, p_210439_, p_210440_, structureplacesettings = this.m_207169_(p_210441_, p_210442_, p_210444_), p_210443_, 18)) {
            return false;
        }
        for (StructureTemplate.StructureBlockInfo structuretemplate$structureblockinfo : StructureTemplate.processBlockInfos((LevelAccessor)p_210436_, (BlockPos)p_210439_, (BlockPos)p_210440_, (StructurePlaceSettings)structureplacesettings, (List)this.m_210457_(p_210435_, p_210439_, p_210441_, false), (StructureTemplate)structuretemplate)) {
            this.m_210472_((LevelAccessor)p_210436_, structuretemplate$structureblockinfo, p_210439_, p_210441_, p_210443_, p_210442_);
        }
        return true;
    }

    protected StructurePlaceSettings m_207169_(Rotation p_210421_, BoundingBox p_210422_, boolean p_210423_) {
        StructurePlaceSettings structureplacesettings = new StructurePlaceSettings();
        structureplacesettings.m_74381_(p_210422_);
        structureplacesettings.m_74379_(p_210421_);
        structureplacesettings.m_74402_(true);
        structureplacesettings.m_74392_(false);
        structureplacesettings.m_74405_(true);
        if (!p_210423_) {
            structureplacesettings.m_74383_((StructureProcessor)JigsawReplacementProcessor.f_74122_);
        }
        ((StructureProcessorList)this.f_210412_.m_203334_()).m_74425_().forEach(arg_0 -> ((StructurePlaceSettings)structureplacesettings).m_74383_(arg_0));
        this.m_210539_().m_210609_().forEach(arg_0 -> ((StructurePlaceSettings)structureplacesettings).m_74383_(arg_0));
        return structureplacesettings;
    }

    public StructurePoolElementType<?> m_207234_() {
        return CSVillagerRegistry.BALLOON_STAND_TYPE;
    }

    public String toString() {
        return "BalloonStand[" + this.f_210411_ + "]";
    }
}

