/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.entity;

import com.github.alexthe668.cloudstorage.client.particle.CSParticleRegistry;
import com.github.alexthe668.cloudstorage.entity.BadloonHandEntity;
import com.github.alexthe668.cloudstorage.entity.BalloonFace;
import com.github.alexthe668.cloudstorage.entity.BalloonFlyer;
import com.github.alexthe668.cloudstorage.entity.GloveGesture;
import com.github.alexthe668.cloudstorage.entity.LivingBalloon;
import com.github.alexthe668.cloudstorage.entity.ai.BalloonBuddyAttackGoal;
import com.github.alexthe668.cloudstorage.entity.ai.BalloonBuddyFollowGoal;
import com.github.alexthe668.cloudstorage.entity.ai.FlightMoveController;
import com.github.alexthe668.cloudstorage.entity.ai.FlyAroundGoal;
import com.github.alexthe668.cloudstorage.item.CSItemRegistry;
import com.github.alexthe668.cloudstorage.misc.CSSoundRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class BalloonBuddyEntity
extends TamableAnimal
implements LivingBalloon,
BalloonFlyer {
    private static final EntityDataAccessor<Float> ROT_Z = SynchedEntityData.m_135353_(BalloonBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Optional<UUID>> CHILD_UUID = SynchedEntityData.m_135353_(BalloonBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> CHILD_ID = SynchedEntityData.m_135353_(BalloonBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FACE = SynchedEntityData.m_135353_(BalloonBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PERSONALITY = SynchedEntityData.m_135353_(BalloonBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BALLOON_COLOR = SynchedEntityData.m_135353_(BalloonBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.m_135353_(BalloonBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ABILITYTIME = SynchedEntityData.m_135353_(BalloonBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int fearOfBeingPoppedCooldown = 0;
    public float prevRotZ;
    private Vec3 randomMoveOffset = null;
    private float prevAbilityProgress;
    private float abilityProgress;
    private int coolnessCooldown = 0;

    protected BalloonBuddyEntity(EntityType type, Level level) {
        super(type, level);
        this.f_21364_ = 1;
        this.f_21342_ = new FlightMoveController((Mob)this, 1.0f, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_CACTUS, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_CACTUS, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, (double)0.15f).m_22268_(Attributes.f_22280_, (double)0.15f).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BalloonBuddyAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BalloonBuddyFollowGoal(this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(3, new FlyAroundGoal<BalloonBuddyEntity>(this, 6, 3, 40, 1.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevRotZ = this.getRotZ();
        this.prevAbilityProgress = this.abilityProgress;
        this.m_20256_(this.m_20184_().m_82542_((double)0.8f, (double)0.6f, (double)0.8f));
        if (!this.f_19853_.f_46443_) {
            Entity child = this.getChild();
            if (child == null) {
                BadloonHandEntity hand = new BadloonHandEntity((LivingEntity)this);
                hand.m_146884_(this.m_20182_().m_82520_(0.0, 0.5, 0.0));
                this.f_19853_.m_7967_((Entity)hand);
                this.setChildId(hand.m_142081_());
                this.f_19804_.m_135381_(CHILD_ID, (Object)hand.m_142049_());
            } else {
                this.f_19804_.m_135381_(CHILD_ID, (Object)child.m_142049_());
                if (this.m_20270_(child) > 4.0f) {
                    Vec3 back = child.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                    this.m_20256_(this.m_20184_().m_82549_(back.m_82490_((double)0.1f)));
                }
            }
            if (this.randomMoveOffset == null || this.f_19796_.nextInt(5) == 0) {
                this.randomMoveOffset = new Vec3((double)(this.f_19796_.nextFloat() - 0.5f), (double)(this.f_19796_.nextFloat() - 0.5f), (double)(this.f_19796_.nextFloat() - 0.5f));
            }
            if (this.m_21825_()) {
                add = new Vec3(0.0, (double)0.02f * Math.sin(0.1f * (float)this.f_19797_), 0.0);
                this.m_20256_(this.m_20184_().m_82549_(add));
            } else if (this.randomMoveOffset != null) {
                add = this.randomMoveOffset.m_82541_().m_82490_((double)(0.01f + this.f_19796_.nextFloat() * 0.01f));
                this.m_20256_(this.m_20184_().m_82549_(add));
            }
            if (this.m_20096_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.08, 0.0));
            }
            if (this.fearOfBeingPoppedCooldown > 0) {
                --this.fearOfBeingPoppedCooldown;
            }
        }
        Vec3 vector3d = this.m_20184_();
        float f = Mth.m_14116_((float)((float)(vector3d.f_82479_ * vector3d.f_82479_ + vector3d.f_82481_ * vector3d.f_82481_)));
        if (!this.f_19853_.f_46443_) {
            float xRotTarget = (float)(Mth.m_14136_((double)vector3d.f_82480_, (double)f) * (double)0.05f * 57.2957763671875);
            this.m_146926_(BalloonFace.rotlerp(this.m_146909_(), xRotTarget, 5.0f));
        }
        if (this.getRotZ() > 0.0f) {
            this.setRotZ(Math.max(this.getRotZ() - 3.0f, 0.0f));
        } else if (this.getRotZ() < 0.0f) {
            this.setRotZ(Math.min(this.getRotZ() + 3.0f, 0.0f));
        }
        if (this.getAbilityTime() > 0) {
            Entity entity;
            this.setAbilityTime(this.getAbilityTime() - 1);
            if (this.abilityProgress < 10.0f) {
                this.abilityProgress += 1.0f;
            }
            if (this.getPersonality() == BalloonFace.SCARY) {
                List list = this.f_19853_.m_45976_(Monster.class, this.m_142469_().m_82377_(16.0, 8.0, 16.0));
                entity = list.iterator();
                while (entity.hasNext()) {
                    Vec3 vec;
                    Monster e = (Monster)entity.next();
                    e.m_6710_(null);
                    e.m_6703_(null);
                    if (this.f_19796_.nextInt(5) != 0 || (vec = LandRandomPos.m_148521_((PathfinderMob)e, (int)20, (int)7, (Vec3)this.m_20182_())) == null) continue;
                    e.m_21573_().m_26519_(vec.f_82479_, vec.f_82480_, vec.f_82481_, 1.5);
                }
            }
            if (this.getPersonality() == BalloonFace.TROLL) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.08, 0.0));
                if (this.getAbilityTime() < 2 && (entity = this.getChild()) instanceof BadloonHandEntity) {
                    BadloonHandEntity hand = (BadloonHandEntity)entity;
                    hand.m_20153_();
                }
            }
        }
        if (this.getAbilityTime() == 0 && this.abilityProgress > 0.0f) {
            this.abilityProgress -= 1.0f;
        }
        if (!this.f_19853_.f_46443_ && this.getPersonality() == BalloonFace.CHARMING && this.getAbilityTime() == 0 && (this.f_19797_ + this.m_142049_()) % 100 == 0) {
            AABB aabb = this.m_142469_().m_82377_(16.0, 8.0, 16.0);
            Predicate<Entity> breedableAnimal = animal -> !(animal instanceof BalloonBuddyEntity) && animal instanceof Animal && !((Animal)animal).m_6162_() && ((Animal)animal).m_27591_() == 0 && ((Animal)animal).m_142606_((ServerLevel)this.f_19853_, (AgeableMob)((Animal)animal)) != null;
            List list = this.f_19853_.m_6443_(Animal.class, aabb, EntitySelector.f_20408_.and(breedableAnimal));
            HashMap typeAnimalMap = new HashMap();
            for (Object animal2 : list) {
                if (typeAnimalMap.get(animal2.m_6095_()) == null) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add(animal2);
                    typeAnimalMap.put(animal2.m_6095_(), arrayList);
                    continue;
                }
                ((List)typeAnimalMap.get(animal2.m_6095_())).add(animal2);
            }
            List closestToBreed = null;
            for (Map.Entry entry : typeAnimalMap.entrySet()) {
                if (((List)entry.getValue()).size() < 2 || closestToBreed != null && !(((Animal)((List)entry.getValue()).get(0)).m_20270_((Entity)this) < ((Animal)closestToBreed.get(0)).m_20270_((Entity)this))) continue;
                closestToBreed = (List)entry.getValue();
            }
            boolean flag = false;
            if (closestToBreed != null) {
                for (Animal animal3 : closestToBreed) {
                    animal3.m_27601_(600);
                    flag = true;
                }
            }
            this.setAbilityTime((flag ? 8000 : 200) + this.f_19796_.nextInt(200));
        }
        if (this.getPersonality() == BalloonFace.COOL && !this.f_19853_.f_46443_) {
            boolean flag = false;
            if (this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_())) {
                if (this.getAbilityTime() == 0) {
                    if (this.coolnessCooldown == 0) {
                        this.setAbilityTime(30);
                    }
                } else {
                    this.m_5448_().m_7292_(new MobEffectInstance(MobEffects.f_19597_, 30, 255, true, false, true));
                    this.m_5448_().m_7292_(new MobEffectInstance(MobEffects.f_19604_, 30, 0, true, false, true));
                    if (!(this.m_5448_() instanceof Player)) {
                        this.m_5448_().m_7618_(EntityAnchorArgument.Anchor.EYES, this.m_20182_());
                    }
                    this.coolnessCooldown = 40 + this.f_19796_.nextInt(40);
                    flag = true;
                    this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
                    this.f_19853_.m_7605_((Entity)this, (byte)69);
                    this.m_5448_().m_6703_(null);
                    LivingEntity livingEntity = this.m_5448_();
                    if (livingEntity instanceof Mob) {
                        Mob mob = (Mob)livingEntity;
                        mob.m_6710_(null);
                    }
                }
            }
            this.setHandGesture(flag ? GloveGesture.POINT : GloveGesture.IDLE);
            if (this.coolnessCooldown > 0) {
                --this.coolnessCooldown;
            }
        }
    }

    public boolean m_6040_() {
        return true;
    }

    public float getRotZ() {
        return Mth.m_14036_((float)((Float)this.f_19804_.m_135370_(ROT_Z)).floatValue(), (float)-20.0f, (float)20.0f);
    }

    public void setRotZ(float rot) {
        this.f_19804_.m_135381_(ROT_Z, (Object)Float.valueOf(rot));
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return worldIn.m_8055_(pos).m_60795_() ? 10.0f : 0.0f;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    protected PathNavigation m_6037_(Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, worldIn){

            public boolean m_6342_(BlockPos pos) {
                return this.f_26495_.m_8055_(pos).m_60795_();
            }
        };
        flyingpathnavigator.m_26440_(false);
        flyingpathnavigator.m_7008_(true);
        flyingpathnavigator.m_26443_(true);
        return flyingpathnavigator;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHILD_UUID, Optional.empty());
        this.f_19804_.m_135372_(CHILD_ID, (Object)-1);
        this.f_19804_.m_135372_(ROT_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(FACE, (Object)0);
        this.f_19804_.m_135372_(PERSONALITY, (Object)0);
        this.f_19804_.m_135372_(BALLOON_COLOR, (Object)15149353);
        this.f_19804_.m_135372_(COMMAND, (Object)0);
        this.f_19804_.m_135372_(ABILITYTIME, (Object)0);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.f_19789_ = 0.0f;
    }

    @Override
    @javax.annotation.Nullable
    public UUID getChildId() {
        return ((Optional)this.f_19804_.m_135370_(CHILD_UUID)).orElse(null);
    }

    @Override
    public void setChildId(@javax.annotation.Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getHandForRendering() {
        return this.f_19853_.m_6815_(((Integer)this.f_19804_.m_135370_(CHILD_ID)).intValue());
    }

    public boolean m_20068_() {
        return true;
    }

    @Override
    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.f_19853_.f_46443_) {
            return ((ServerLevel)this.f_19853_).m_8791_(id);
        }
        return null;
    }

    private void setFaceInt(int face) {
        this.f_19804_.m_135381_(FACE, (Object)(face % BalloonFace.values().length));
    }

    private BalloonFace getFaceFromData() {
        return BalloonFace.values()[Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(FACE)), (int)0, (int)(BalloonFace.values().length - 1))];
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return CSSoundRegistry.BALLOON_HURT;
    }

    @Override
    public BalloonFace getFace() {
        if (this.getFaceFromData() != BalloonFace.NEUTRAL) {
            return this.getFaceFromData();
        }
        return this.getPersonality();
    }

    @Override
    public void setFace(BalloonFace face) {
        this.setFaceInt(face.ordinal());
    }

    private void setPersonalityInt(int face) {
        this.f_19804_.m_135381_(PERSONALITY, (Object)(face % BalloonFace.values().length));
    }

    public BalloonFace getPersonality() {
        return BalloonFace.values()[Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(PERSONALITY)), (int)0, (int)(BalloonFace.values().length - 1))];
    }

    public void setPersonality(BalloonFace face) {
        this.setPersonalityInt(face.ordinal());
    }

    @Override
    public int getBalloonColor() {
        return (Integer)this.f_19804_.m_135370_(BALLOON_COLOR);
    }

    @Override
    public void setBalloonColor(int color) {
        this.f_19804_.m_135381_(BALLOON_COLOR, (Object)color);
    }

    public int getAbilityTime() {
        return (Integer)this.f_19804_.m_135370_(ABILITYTIME);
    }

    public void setAbilityTime(int time) {
        this.f_19804_.m_135381_(ABILITYTIME, (Object)time);
    }

    @Override
    public float getPopProgress(float partialTick) {
        if (this.f_20919_ == 0) {
            return 0.0f;
        }
        return ((float)this.f_20919_ + partialTick - 1.0f) / 3.0f;
    }

    protected void m_6153_() {
        int max = 3;
        if (this.f_20919_ == 0 && !this.m_20067_()) {
            this.m_5496_(CSSoundRegistry.BALLOON_POP, this.m_6121_(), 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.4f);
        }
        ++this.f_20919_;
        if (this.f_20919_ == max && !this.f_19853_.m_5776_()) {
            this.f_19853_.m_7605_((Entity)this, (byte)67);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 67) {
            int color = this.getBalloonColor();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            for (int i = 0; i < 5 + this.f_19796_.nextInt(2) + 5; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)CSParticleRegistry.BALLOON_SHARD, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), (double)r, (double)g, (double)b);
            }
        } else if (id == 68) {
            for (int i = 0; i < 5 + this.f_19796_.nextInt(2) + 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)CSParticleRegistry.STOP_SPAWN, this.m_20208_(1.0), this.m_20227_(0.5), this.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
        } else if (id == 69) {
            this.f_19853_.m_7106_((ParticleOptions)CSParticleRegistry.COOL, this.m_20208_(0.8f), this.m_20227_(0.75), this.m_20262_(0.8f), 0.0, 0.0, 0.0);
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_6469_(DamageSource source, float f) {
        if (source == DamageSource.f_19314_ || source.m_19360_()) {
            f = 100.0f;
        }
        return super.m_6469_(source, f);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("ChildUUID")) {
            this.setChildId(compound.m_128342_("ChildUUID"));
        }
        this.setPersonalityInt(compound.m_128451_("Personality"));
        this.setFaceInt(compound.m_128451_("Face"));
        this.setBalloonColor(compound.m_128451_("BalloonColor"));
        this.setCommand(compound.m_128451_("BalloonCommand"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getChildId() != null) {
            compound.m_128362_("ChildUUID", this.getChildId());
        }
        compound.m_128405_("Face", this.getFace().ordinal());
        compound.m_128405_("Personality", this.getPersonality().ordinal());
        compound.m_128405_("BalloonColor", this.getBalloonColor());
        compound.m_128405_("BalloonCommand", this.getCommand());
    }

    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(COMMAND);
    }

    public void setCommand(int i) {
        this.f_19804_.m_135381_(COMMAND, (Object)i);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_150930_(Items.f_42401_) && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(6.0f);
        } else if (this.m_21830_((LivingEntity)player)) {
            if (player.m_6144_() && itemstack.m_41619_()) {
                ItemStack balloonStack = this.turnIntoItem();
                if (!player.m_36356_(balloonStack)) {
                    this.m_19983_(balloonStack);
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            } else if (!this.f_19853_.f_46443_) {
                int command = (this.getCommand() + 1) % 3;
                this.setCommand(command);
                player.m_5661_((Component)new TranslatableComponent("entity.balloon_buddy.command_" + command, new Object[]{this.m_7755_()}), true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob ageableMob) {
        return null;
    }

    public boolean m_21825_() {
        return this.getCommand() == 1;
    }

    public void m_21837_(boolean sit) {
        if (sit) {
            this.setCommand(1);
        }
    }

    @Override
    public boolean stopFlying() {
        return this.m_21825_() && !this.shouldFollow();
    }

    public boolean shouldFollow() {
        return this.getCommand() == 2 && (this.getPersonality() != BalloonFace.TROLL || !this.shouldFaceStopAttacking());
    }

    public void clearMovement() {
        MoveControl moveControl = this.m_21566_();
        if (moveControl instanceof FlightMoveController) {
            FlightMoveController moveHelper = (FlightMoveController)moveControl;
            moveHelper.stop();
        }
    }

    @Override
    public float getAbilityProgress(float partialTicks) {
        return (this.prevAbilityProgress + (this.abilityProgress - this.prevAbilityProgress) * partialTicks) / 10.0f;
    }

    public void setHandGesture(GloveGesture gesture) {
        Entity entity = this.getChild();
        if (entity instanceof BadloonHandEntity) {
            BadloonHandEntity hand = (BadloonHandEntity)entity;
            hand.setGesture(gesture);
        }
    }

    public double m_20968_(@javax.annotation.Nullable Entity entity) {
        if (this.getPersonality() == BalloonFace.EYEPATCH) {
            return 0.0;
        }
        return super.m_20968_(entity);
    }

    public boolean shouldFaceStopAttacking() {
        BadloonHandEntity hand;
        Entity entity;
        if (this.getPersonality() == BalloonFace.SCARY) {
            LivingEntity owner = this.m_142480_();
            return owner != null && (double)this.m_20270_((Entity)owner) > 16.0;
        }
        if (this.getPersonality() == BalloonFace.TROLL && (entity = this.getChild()) instanceof BadloonHandEntity && (hand = (BadloonHandEntity)entity).m_20160_()) {
            return true;
        }
        return !this.getPersonality().doesMeleeAttacks();
    }

    public boolean doesDealDamage() {
        return this.getPersonality() != BalloonFace.SCARY;
    }

    @Override
    public float getAlpha(float partialTick) {
        return this.getPersonality() == BalloonFace.EYEPATCH ? 1.0f - 0.75f * this.getAbilityProgress(partialTick) : 1.0f;
    }

    public ItemStack turnIntoItem() {
        ItemStack stack = new ItemStack((ItemLike)CSItemRegistry.BALLOON_BUDDY.get());
        CompoundTag tag = new CompoundTag();
        CompoundTag mobNBT = new CompoundTag();
        CompoundTag display = new CompoundTag();
        this.m_7380_(mobNBT);
        tag.m_128365_("MobNBT", (Tag)mobNBT);
        tag.m_128405_("Personality", this.getPersonality().ordinal());
        if (this.getBalloonColor() != 15149353) {
            display.m_128405_("color", this.getBalloonColor());
            tag.m_128365_("display", (Tag)display);
        }
        tag.m_128350_("Health", this.m_21223_());
        stack.m_41751_(tag);
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        return stack;
    }

    public boolean m_7307_(Entity entityIn) {
        if (this.m_21824_()) {
            LivingEntity livingentity = this.m_142480_();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).m_21830_(livingentity);
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entityIn);
            }
        }
        return super.m_7307_(entityIn);
    }

    @javax.annotation.Nullable
    public ItemStack m_142340_() {
        return this.turnIntoItem();
    }
}

