/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.client.render;

import com.github.alexthe666.citadel.client.render.LightningBoltData;
import com.github.alexthe666.citadel.client.render.LightningRender;
import com.github.alexthe668.cloudstorage.client.model.BloviatorModel;
import com.github.alexthe668.cloudstorage.client.render.StringRenderHelper;
import com.github.alexthe668.cloudstorage.entity.BloviatorEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector4f;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;

public class RenderBloviator
extends MobRenderer<BloviatorEntity, BloviatorModel> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("cloudstorage:textures/entity/bloviator/bloviator.png");
    public static final ResourceLocation BLOWING_TEXTURE = new ResourceLocation("cloudstorage:textures/entity/bloviator/bloviator_blowing.png");
    public static final ResourceLocation THUNDER_TEXTURE = new ResourceLocation("cloudstorage:textures/entity/bloviator/bloviator_thunder.png");
    public static final ResourceLocation STATIC_TEXTURE = new ResourceLocation("cloudstorage:textures/entity/bloviator/bloviator_static.png");
    private LightningRender lightningRender = new LightningRender();
    private static Map<Integer, BloviatorModel> CLOUDCOUNT_TO_MODEL = new HashMap<Integer, BloviatorModel>();

    public RenderBloviator(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new BloviatorModel(5), 0.3f);
        this.m_115326_(new LayerThunder(this));
    }

    protected void scale(BloviatorEntity entity, PoseStack stack, float partialTick) {
        float f = entity.getCloudScale();
        stack.m_85841_(f, f, f);
    }

    public boolean shouldRender(BloviatorEntity entity, Frustum frustum, double x, double y, double z) {
        if (super.m_5523_((Mob)entity, frustum, x, y, z)) {
            return true;
        }
        Entity push = entity.getPushingEntity();
        Entity shock = entity.getShockingEntity();
        if (push != null && (frustum.m_113029_(push.m_142469_()) || push == Minecraft.m_91087_().f_91074_)) {
            return true;
        }
        return shock != null && (frustum.m_113029_(shock.m_142469_()) || shock == Minecraft.m_91087_().f_91074_);
    }

    public void render(BloviatorEntity entityIn, float entityYaw, float f, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        int count = entityIn.getCloudCount();
        if (CLOUDCOUNT_TO_MODEL.get(count) == null) {
            CLOUDCOUNT_TO_MODEL.put(count, new BloviatorModel(count));
        }
        this.f_115290_ = (EntityModel)CLOUDCOUNT_TO_MODEL.get(count);
        Entity blow = entityIn.getPushingEntity();
        Entity struck = entityIn.getShockingEntity();
        float partialTicks = Minecraft.m_91087_().m_91296_();
        double x = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19790_, (double)entityIn.m_20185_());
        double y = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19791_, (double)entityIn.m_20186_());
        double z = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19792_, (double)entityIn.m_20189_());
        if (struck != null) {
            matrixStackIn.m_85836_();
            Vec3 toVec = struck.m_20182_().m_82492_(x, y, z);
            float alpha = (float)entityIn.getShockTime() / 5.0f;
            int segCount = 2 + entityIn.getCloudCount() * 2;
            LightningBoltData.BoltRenderInfo lightningBoltData = new LightningBoltData.BoltRenderInfo(0.15f, 0.1f, 0.5f, 0.85f, new Vector4f(0.3f, 0.45f, 0.6f, alpha * 0.5f), 0.1f);
            LightningBoltData bolt = new LightningBoltData(lightningBoltData, Vec3.f_82478_, toVec, segCount).size(0.1f + 0.2f * entityIn.getCloudScale()).lifespan(5).spawn(LightningBoltData.SpawnFunction.CONSECUTIVE);
            this.lightningRender.update((Object)entityIn, bolt, partialTicks);
            this.lightningRender.render(partialTicks, matrixStackIn, bufferIn);
            matrixStackIn.m_85849_();
        }
        if (blow != null) {
            matrixStackIn.m_85836_();
            Vec3 vec3 = entityIn.getMouthVec(partialTicks);
            Vec3 vec31 = vec3.m_82492_(x, y, z);
            double d3 = Mth.m_14139_((double)partialTicks, (double)blow.f_19790_, (double)blow.m_20185_());
            double d4 = Mth.m_14139_((double)partialTicks, (double)blow.f_19791_, (double)blow.m_20186_()) + (double)blow.m_20192_();
            double d5 = Mth.m_14139_((double)partialTicks, (double)blow.f_19792_, (double)blow.m_20189_());
            float f6 = (float)(vec3.f_82479_ - d3);
            float f7 = (float)(vec3.f_82480_ - d4);
            float f8 = (float)(vec3.f_82481_ - d5);
            matrixStackIn.m_85837_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
            StringRenderHelper.renderBloviatorBeam(f6, f7, f8, partialTicks, entityIn.f_19797_, matrixStackIn, bufferIn, packedLightIn, entityIn.getCloudScale(), entityIn.getPushProgress(partialTicks));
            matrixStackIn.m_85849_();
        }
        super.m_7392_((Mob)entityIn, entityYaw, f, matrixStackIn, bufferIn, packedLightIn);
    }

    protected float getFlipDegrees(BloviatorEntity entity) {
        return 0.0f;
    }

    public ResourceLocation getTextureLocation(BloviatorEntity entity) {
        return entity.isPushing() ? BLOWING_TEXTURE : TEXTURE;
    }

    class LayerThunder
    extends RenderLayer<BloviatorEntity, BloviatorModel> {
        public LayerThunder(RenderBloviator render) {
            super((RenderLayerParent)render);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, BloviatorEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            VertexConsumer sheenBuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)THUNDER_TEXTURE));
            ((BloviatorModel)this.m_117386_()).m_7695_(matrixStackIn, sheenBuilder, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f), 1.0f, 1.0f, 1.0f, entity.getTransformProgress(partialTicks));
            if (entity.isThundery()) {
                VertexConsumer staticBuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)STATIC_TEXTURE));
                ((BloviatorModel)this.m_117386_()).m_7695_(matrixStackIn, staticBuilder, 240, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f), 1.0f, 1.0f, 1.0f, entity.getChargeTimeLerp(partialTicks) / (float)entity.getMaxChargeTime());
            }
        }
    }
}

