/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.client.gui;

import com.github.alexthe668.cloudstorage.CloudStorage;
import com.github.alexthe668.cloudstorage.client.ClientProxy;
import com.github.alexthe668.cloudstorage.inventory.BalloonStandMenu;
import com.github.alexthe668.cloudstorage.item.BalloonItem;
import com.github.alexthe668.cloudstorage.network.MessageRequestCloudInfo;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class BalloonStandScreen
extends AbstractContainerScreen<BalloonStandMenu> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("cloudstorage:textures/gui/balloon_stand_gui.png");
    private float cloudProgress;
    private float prevCloudProgress;
    private int lastBalloonColor = -1;
    private int tickCount = 0;

    public BalloonStandScreen(BalloonStandMenu menu, Inventory inventory, Component name) {
        super((AbstractContainerMenu)menu, inventory, name);
        this.f_97727_ = 176;
    }

    public void m_6305_(PoseStack stack, int x, int y, float partialTick) {
        this.m_7333_(stack);
        this.m_7286_(stack, partialTick, x, y);
        super.m_6305_(stack, x, y, partialTick);
        this.m_7025_(stack, x, y);
    }

    protected void m_7286_(PoseStack poseStack, float f, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        float partialTicks = Minecraft.m_91087_().m_91296_();
        float cloud = (this.prevCloudProgress + (this.cloudProgress - this.prevCloudProgress) * partialTicks) / 10.0f;
        int cloudTexture = this.tickCount / 7;
        this.renderLittleCloud(poseStack, partialTicks, cloud * 0.8f, cloudTexture);
    }

    private void renderLittleCloud(PoseStack poseStack, float partialTick, float alpha, int cloudTexture) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, i, j, 0, 0, this.f_97726_, this.f_97727_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        this.m_93228_(poseStack, i + 7, j + 15, 176, 66, 66, 66);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void m_181908_() {
        this.prevCloudProgress = this.cloudProgress;
        ++this.tickCount;
        if (((BalloonStandMenu)this.f_97732_).m_38853_(0).m_6657_()) {
            int i = BalloonItem.getBalloonColor(((BalloonStandMenu)this.f_97732_).m_38853_(0).m_7993_());
            if (i != this.lastBalloonColor) {
                CloudStorage.NETWORK_WRAPPER.sendToServer((Object)new MessageRequestCloudInfo(i));
                this.lastBalloonColor = i;
            }
            if (this.cloudProgress < 10.0f) {
                this.cloudProgress += 1.0f;
            }
        } else if (this.cloudProgress > 0.0f) {
            this.cloudProgress -= 1.0f;
        }
    }

    protected void m_7027_(PoseStack poseStack, int x, int y) {
        float cloud = this.prevCloudProgress + (this.cloudProgress - this.prevCloudProgress) * this.f_96541_.m_91296_();
        this.f_96547_.m_92889_(poseStack, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_, 0x404040);
        this.f_96547_.m_92889_(poseStack, this.f_169604_, (float)this.f_97730_, (float)this.f_97731_ + 10.0f, 0x404040);
        int alpha = (int)(cloud / 10.0f * 255.0f);
        if (alpha > 10) {
            int fade = FastColor.ARGB32.m_13660_((int)alpha, (int)255, (int)255, (int)255);
            poseStack.m_85836_();
            poseStack.m_85841_(0.8f, 0.8f, 0.8f);
            String color = Integer.toHexString(this.lastBalloonColor).toUpperCase(Locale.ROOT) + " RGB";
            int textColor = FastColor.ARGB32.m_13657_((int)8757938, (int)fade);
            float textX = 20.0f;
            float textY = 30.0f;
            int r = this.lastBalloonColor >> 16 & 0xFF;
            int g = this.lastBalloonColor >> 8 & 0xFF;
            int b = this.lastBalloonColor & 0xFF;
            this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("cloudstorage.container.balloon_stand.color"), textX, textY, textColor);
            this.f_96547_.m_92883_(poseStack, color, textX, textY + 10.0f, FastColor.ARGB32.m_13660_((int)alpha, (int)r, (int)g, (int)b));
            TranslatableComponent slotsPrivate = new TranslatableComponent("cloudstorage.container.balloon_stand.slots", new Object[]{ClientProxy.getCloudInt(this.lastBalloonColor, false), ClientProxy.getCloudInt(this.lastBalloonColor, true)});
            TranslatableComponent slotsPublic = new TranslatableComponent("cloudstorage.container.balloon_stand.slots", new Object[]{ClientProxy.getStaticCloudInt(this.lastBalloonColor, false), ClientProxy.getStaticCloudInt(this.lastBalloonColor, true)});
            if (this.f_96547_.m_92852_((FormattedText)slotsPrivate) > 78) {
                slotsPrivate = new TextComponent(ClientProxy.getCloudInt(this.lastBalloonColor, false) + " / " + ClientProxy.getCloudInt(this.lastBalloonColor, true));
            }
            if (this.f_96547_.m_92852_((FormattedText)slotsPublic) > 78) {
                slotsPublic = new TextComponent(ClientProxy.getStaticCloudInt(this.lastBalloonColor, false) + " / " + ClientProxy.getStaticCloudInt(this.lastBalloonColor, true));
            }
            this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("cloudstorage.container.balloon_stand.private_slots"), textX, textY + 20.0f, textColor);
            this.f_96547_.m_92889_(poseStack, (Component)slotsPrivate, textX, textY + 30.0f, textColor);
            this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("cloudstorage.container.balloon_stand.public_slots"), textX, textY + 40.0f, textColor);
            this.f_96547_.m_92889_(poseStack, (Component)slotsPublic, textX, textY + 50.0f, textColor);
            poseStack.m_85849_();
        }
    }
}

