/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.client;

import com.github.alexthe666.citadel.client.event.EventPosePlayerHand;
import com.github.alexthe668.cloudstorage.CloudStorage;
import com.github.alexthe668.cloudstorage.CommonProxy;
import com.github.alexthe668.cloudstorage.block.CSBlockEntityRegistry;
import com.github.alexthe668.cloudstorage.block.CSBlockRegistry;
import com.github.alexthe668.cloudstorage.client.gui.BalloonStandScreen;
import com.github.alexthe668.cloudstorage.client.gui.CloudChestScreen;
import com.github.alexthe668.cloudstorage.client.gui.GuideBookScreen;
import com.github.alexthe668.cloudstorage.client.model.PropellerHatModel;
import com.github.alexthe668.cloudstorage.client.model.baked.BakedModelFinalLayerFullbright;
import com.github.alexthe668.cloudstorage.client.particle.CSParticleRegistry;
import com.github.alexthe668.cloudstorage.client.particle.ParticleBalloonShard;
import com.github.alexthe668.cloudstorage.client.particle.ParticleBloviatorBreath;
import com.github.alexthe668.cloudstorage.client.particle.ParticleBuddyEffect;
import com.github.alexthe668.cloudstorage.client.particle.ParticleCloudChest;
import com.github.alexthe668.cloudstorage.client.particle.ParticleStaticLightning;
import com.github.alexthe668.cloudstorage.client.render.CSItemRenderProperties;
import com.github.alexthe668.cloudstorage.client.render.CSItemRenderer;
import com.github.alexthe668.cloudstorage.client.render.RenderBadloon;
import com.github.alexthe668.cloudstorage.client.render.RenderBadloonHand;
import com.github.alexthe668.cloudstorage.client.render.RenderBalloon;
import com.github.alexthe668.cloudstorage.client.render.RenderBalloonBuddy;
import com.github.alexthe668.cloudstorage.client.render.RenderBalloonCargo;
import com.github.alexthe668.cloudstorage.client.render.RenderBalloonTie;
import com.github.alexthe668.cloudstorage.client.render.RenderBloviator;
import com.github.alexthe668.cloudstorage.client.render.RenderCloudChest;
import com.github.alexthe668.cloudstorage.client.render.RenderFallingBlockWithTE;
import com.github.alexthe668.cloudstorage.client.render.VillagerHatLayer;
import com.github.alexthe668.cloudstorage.entity.CSEntityRegistry;
import com.github.alexthe668.cloudstorage.inventory.CSMenuRegistry;
import com.github.alexthe668.cloudstorage.item.BalloonItem;
import com.github.alexthe668.cloudstorage.item.CSItemRegistry;
import com.github.alexthe668.cloudstorage.misc.CloudInfo;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientProxy
extends CommonProxy {
    private static final List<String> FULLBRIGHTS = ImmutableList.of((Object)"cloudstorage:static_cloud#");
    public static final ModelLayerLocation PROPELLER_HAT_MODEL = new ModelLayerLocation(new ResourceLocation("cloudstorage", "propeller_hat"), "main");
    private static final Map<Integer, CloudInfo> CLIENT_CLOUD_INFO = new HashMap<Integer, CloudInfo>();
    private int visibleSlots;

    public static int getCloudInt(int color, boolean allSlots) {
        CloudInfo info = CLIENT_CLOUD_INFO.get(color);
        if (info == null) {
            return 0;
        }
        return allSlots ? info.getSlotCount() : info.getUsedSlots();
    }

    public static int getStaticCloudInt(int color, boolean allSlots) {
        CloudInfo info = CLIENT_CLOUD_INFO.get(color);
        if (info == null) {
            return 0;
        }
        return allSlots ? info.getStaticSlotCount() : info.getUsedStaticSlots();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::bakeModels);
        EntityRenderers.m_174036_((EntityType)((EntityType)CSEntityRegistry.BADLOON.get()), RenderBadloon::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CSEntityRegistry.BADLOON_HAND.get()), RenderBadloonHand::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CSEntityRegistry.BALLOON.get()), RenderBalloon::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CSEntityRegistry.BALLOON_TIE.get()), RenderBalloonTie::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CSEntityRegistry.BALLOON_CARGO.get()), RenderBalloonCargo::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CSEntityRegistry.BLOVIATOR.get()), RenderBloviator::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CSEntityRegistry.BALLOON_BUDDY.get()), RenderBalloonBuddy::new);
        EntityRenderers.m_174036_((EntityType)EntityType.f_20450_, RenderFallingBlockWithTE::new);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CSBlockRegistry.CLOUD.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CSBlockRegistry.STATIC_CLOUD.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CSBlockRegistry.CLOUD_CHEST.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CSBlockRegistry.STATIC_CLOUD_CHEST.get()), (RenderType)RenderType.m_110466_());
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)CSBlockEntityRegistry.CLOUD_CHEST.get()), RenderCloudChest::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)CSBlockEntityRegistry.STATIC_CLOUD_CHEST.get()), RenderCloudChest::new);
        MenuScreens.m_96206_(CSMenuRegistry.CLOUD_CHEST_MENU, CloudChestScreen::new);
        MenuScreens.m_96206_(CSMenuRegistry.BALLOON_STAND_MENU, BalloonStandScreen::new);
    }

    @Override
    public void init() {
        super.init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientProxy::onAddLayers);
    }

    @Override
    public Object getISTERProperties(boolean armor) {
        return new CSItemRenderProperties(armor);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onItemColors(ColorHandlerEvent.Item event) {
        CloudStorage.LOGGER.info("loaded in item colorizer");
        event.getItemColors().m_92689_((stack, colorIn) -> colorIn != 1 ? -1 : ClientProxy.getBalloonColorForRender(stack), new ItemLike[]{(ItemLike)CSItemRegistry.BALLOON_INVENTORY.get()});
        event.getItemColors().m_92689_((stack, colorIn) -> colorIn != 1 ? -1 : ClientProxy.getBalloonColorForRender(stack), new ItemLike[]{(ItemLike)CSItemRegistry.BALLOON.get()});
        event.getItemColors().m_92689_((stack, colorIn) -> colorIn != 1 && colorIn != 3 ? -1 : ClientProxy.getBalloonColorForRender(stack), new ItemLike[]{(ItemLike)CSItemRegistry.BALLOON_BUDDY_INVENTORY.get()});
        event.getItemColors().m_92689_((stack, colorIn) -> colorIn != 1 && colorIn != 3 ? -1 : ClientProxy.getBalloonColorForRender(stack), new ItemLike[]{(ItemLike)CSItemRegistry.BALLOON_BUDDY.get()});
        event.getItemColors().m_92689_((stack, colorIn) -> colorIn != 2 ? -1 : ClientProxy.getBalloonColorForRender(stack), new ItemLike[]{(ItemLike)CSItemRegistry.BALLOON_ARROW.get()});
    }

    private static int getBalloonColorForRender(ItemStack stack) {
        int color = BalloonItem.getBalloonColor(stack);
        if (color == -1) {
            return 15149353;
        }
        return color;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPoseHand(EventPosePlayerHand event) {
        LivingEntity player = (LivingEntity)event.getEntityIn();
        float f = Minecraft.m_91087_().m_91296_();
        boolean rightHand = false;
        boolean leftHand = false;
        boolean flag = false;
        if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof BalloonItem) {
            leftHand = leftHand || player.m_5737_() == HumanoidArm.LEFT;
            rightHand = rightHand || player.m_5737_() == HumanoidArm.RIGHT;
            flag = true;
        }
        if (player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof BalloonItem) {
            leftHand = leftHand || player.m_5737_() != HumanoidArm.LEFT;
            rightHand = rightHand || player.m_5737_() != HumanoidArm.RIGHT;
            flag = true;
        }
        if (flag) {
            if (leftHand && event.isLeftHand()) {
                event.getModel().f_102812_.f_104203_ = -((float)Math.toRadians(135.0));
            }
            if (rightHand && !event.isLeftHand()) {
                event.getModel().f_102811_.f_104203_ = -((float)Math.toRadians(135.0));
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPostRenderEntity(RenderNameplateEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof FallingBlockEntity) {
            FallingBlockEntity entity2 = (FallingBlockEntity)entity;
            BlockState blockstate = entity2.m_31980_();
            PoseStack stack = event.getPoseStack();
            if (blockstate.m_60799_() == RenderShape.ENTITYBLOCK_ANIMATED) {
                stack.m_85836_();
                stack.m_85837_(-0.5, 0.0, -0.5);
                if (blockstate.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
                    float f = ((Direction)blockstate.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122435_();
                    stack.m_85837_(0.5, 0.5, 0.5);
                    stack.m_85845_(Vector3f.f_122225_.m_122240_(-f));
                    stack.m_85837_(-0.5, -0.5, -0.5);
                }
                Minecraft.m_91087_().m_91289_().m_110912_(blockstate, stack, event.getMultiBufferSource(), event.getPackedLight(), OverlayTexture.f_118083_);
                stack.m_85849_();
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        event.getRenderer(EntityType.f_20492_).m_115326_(new VillagerHatLayer(event.getRenderer(EntityType.f_20492_)));
        event.getRenderer(EntityType.f_20530_).m_115326_(new VillagerHatLayer(event.getRenderer(EntityType.f_20530_)));
    }

    @Override
    public void setupParticles() {
        CloudStorage.LOGGER.debug("Registered particle factories");
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)CSParticleRegistry.BALLOON_SHARD, ParticleBalloonShard.Factory::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)CSParticleRegistry.CLOUD_CHEST, ParticleCloudChest.Factory::new);
        Minecraft.m_91087_().f_91061_.m_107381_((ParticleType)CSParticleRegistry.STATIC_LIGHTNING, (ParticleProvider)new ParticleStaticLightning.Factory());
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)CSParticleRegistry.BLOVIATOR_BREATH, ParticleBloviatorBreath.Factory::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)CSParticleRegistry.STOP_SPAWN, ParticleBuddyEffect.StopSpawn::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)CSParticleRegistry.COOL, ParticleBuddyEffect.Cool::new);
    }

    private void bakeModels(ModelBakeEvent e) {
        for (ResourceLocation id : e.getModelRegistry().keySet()) {
            if (!FULLBRIGHTS.contains(id.toString())) continue;
            e.getModelRegistry().put(id, new BakedModelFinalLayerFullbright((BakedModel)e.getModelRegistry().get(id)));
        }
        ItemProperties.register((Item)((Item)CSItemRegistry.BALLOON.get()), (ResourceLocation)new ResourceLocation("loot_or_static"), (stack, lvl, holder, i) -> BalloonItem.isLoot(stack) ? 1.0f : (BalloonItem.isStatic(stack) ? 0.5f : 0.0f));
        ItemProperties.register((Item)((Item)CSItemRegistry.BALLOON_INVENTORY.get()), (ResourceLocation)new ResourceLocation("loot_or_static"), (stack, lvl, holder, i) -> BalloonItem.isLoot(stack) ? 1.0f : (BalloonItem.isStatic(stack) ? 0.5f : 0.0f));
    }

    @Override
    public void bakeEntityModels(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(PROPELLER_HAT_MODEL, () -> PropellerHatModel.createArmorLayer(new CubeDeformation(0.5f)));
    }

    @Override
    public void setVisibleCloudSlots(int i) {
        this.visibleSlots = i;
    }

    @Override
    public int getVisibleCloudSlots() {
        return this.visibleSlots;
    }

    @Override
    public Player getClientSidePlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderWorldLastEvent(RenderLevelLastEvent event) {
        CSItemRenderer.incrementRenderTick();
    }

    @Override
    public void setClientCloudInfo(Player player, int balloonColor, CloudInfo cloudInfo) {
        if (Minecraft.m_91087_().f_91074_ == player) {
            CLIENT_CLOUD_INFO.put(balloonColor, cloudInfo);
        }
    }

    @Override
    public void openBookScreen(ItemStack itemStackIn) {
        Minecraft.m_91087_().m_91152_((Screen)new GuideBookScreen(itemStackIn));
    }

    @Override
    public void onHoldingBalloon(LivingEntity holder, ItemStack balloon, boolean leftHanded) {
        super.onHoldingBalloon(holder, balloon, leftHanded);
        if (BalloonItem.isStatic(balloon)) {
            CSItemRenderer.renderBalloonStatic(holder, balloon, leftHanded);
        }
    }
}

