/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.block;

import com.github.alexthe668.cloudstorage.block.AbstractCloudChestBlockEntity;
import com.github.alexthe668.cloudstorage.block.CSBlockEntityRegistry;
import com.github.alexthe668.cloudstorage.entity.BalloonEntity;
import com.github.alexthe668.cloudstorage.entity.CSEntityRegistry;
import com.github.alexthe668.cloudstorage.inventory.CloudChestMenu;
import com.github.alexthe668.cloudstorage.misc.CloudIndex;
import com.github.alexthe668.cloudstorage.world.CSWorldData;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class StaticCloudChestBlockEntity
extends AbstractCloudChestBlockEntity {
    private static final Component CONTAINER_TITLE = new TranslatableComponent("cloudstorage.container.static_cloud_chest");
    private int balloonColor = -1;
    private LazyOptional<? extends IItemHandler> input = LazyOptional.empty();

    public StaticCloudChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CSBlockEntityRegistry.STATIC_CLOUD_CHEST.get(), pos, state);
    }

    @Override
    public boolean hasBalloonFor(Player player) {
        return this.balloonColor != -1;
    }

    @Override
    public int getBalloonFor(Player player) {
        return this.balloonColor;
    }

    @Override
    public void setBalloonColorFor(Player player, int color) {
        this.balloonColor = color;
        this.m_6596_();
    }

    @Override
    public AbstractContainerMenu getMenu(int i, Inventory playerInventory) {
        CloudIndex cloudIndex;
        CSWorldData data = CSWorldData.get(this.m_58904_());
        Player player = playerInventory.f_35978_;
        if (data != null && this.hasBalloonFor(player) && (cloudIndex = data.getPublicCloud(this.getBalloonFor(player))) != null && cloudIndex.getContainerSize() > 0) {
            return new CloudChestMenu(i, playerInventory, (Container)cloudIndex.getContainer());
        }
        return null;
    }

    @Override
    public Component getTitle() {
        return CONTAINER_TITLE;
    }

    @Override
    public boolean hasNoInvSpace(Player player) {
        CSWorldData data = CSWorldData.get(this.m_58904_());
        if (data != null && this.hasBalloonFor(player)) {
            CloudIndex cloudIndex = data.getPublicCloud(this.getBalloonFor(player));
            return cloudIndex == null || cloudIndex.getContainerSize() == 0;
        }
        return false;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.balloonColor = tag.m_128451_("BalloonColor");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("BalloonColor", this.balloonColor);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && this.balloonColor != -1 && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && !this.hasNoInvSpace(null)) {
            Container cloudContainer;
            if (!this.input.isPresent() && (cloudContainer = this.getCloudContainer()) != null) {
                this.input = LazyOptional.of(() -> new InvWrapper(cloudContainer));
            }
            return this.input.cast();
        }
        return super.getCapability(capability, facing);
    }

    private Container getCloudContainer() {
        CloudIndex cloudIndex;
        CSWorldData data = CSWorldData.get(this.m_58904_());
        if (data != null && this.hasBalloonFor(null) && (cloudIndex = data.getPublicCloud(this.getBalloonFor(null))) != null && cloudIndex.getContainerSize() > 0) {
            return cloudIndex.getContainer();
        }
        return null;
    }

    @Override
    public void releaseBalloons() {
        if (this.balloonColor != -1) {
            Vec3 releasePosition = Vec3.m_82539_((Vec3i)this.m_58899_()).m_82520_(0.0, (double)(this.getEmergence(1.0f) * 2.0f), 0.0);
            BalloonEntity balloon = (BalloonEntity)((EntityType)CSEntityRegistry.BALLOON.get()).m_20615_(this.f_58857_);
            balloon.setBalloonColor(this.balloonColor);
            balloon.setCharged(true);
            balloon.setStringLength(1);
            balloon.m_146884_(releasePosition);
            this.f_58857_.m_7967_((Entity)balloon);
        }
    }

    @Override
    public int getContainerSize(Player player) {
        CSWorldData data = CSWorldData.get(this.m_58904_());
        if (data != null && this.hasBalloonFor(player)) {
            CloudIndex cloudIndex = data.getPublicCloud(this.getBalloonFor(player));
            return cloudIndex != null ? cloudIndex.getContainerSize() : 0;
        }
        return 0;
    }
}

