/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage;

import com.github.alexthe668.cloudstorage.CloudStorage;
import com.github.alexthe668.cloudstorage.entity.BadloonEntity;
import com.github.alexthe668.cloudstorage.entity.BalloonBuddyEntity;
import com.github.alexthe668.cloudstorage.entity.BalloonEntity;
import com.github.alexthe668.cloudstorage.entity.BalloonFace;
import com.github.alexthe668.cloudstorage.entity.LivingBalloon;
import com.github.alexthe668.cloudstorage.entity.villager.CSVillagerRegistry;
import com.github.alexthe668.cloudstorage.inventory.CloudChestMenu;
import com.github.alexthe668.cloudstorage.inventory.ItemSorting;
import com.github.alexthe668.cloudstorage.item.BalloonItem;
import com.github.alexthe668.cloudstorage.item.CSItemRegistry;
import com.github.alexthe668.cloudstorage.misc.CSAdvancementTrigger;
import com.github.alexthe668.cloudstorage.misc.CloudIndex;
import com.github.alexthe668.cloudstorage.misc.CloudInfo;
import com.github.alexthe668.cloudstorage.misc.DyeRandomlyLootFunction;
import com.github.alexthe668.cloudstorage.network.MessageUpdateCloudInfo;
import com.github.alexthe668.cloudstorage.world.CSWorldData;
import com.github.alexthe668.cloudstorage.world.SkyMobSpawner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cloudstorage", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonProxy {
    public static CSAdvancementTrigger UPLOAD_TRIGGER = new CSAdvancementTrigger(new ResourceLocation("cloudstorage:upload"));
    public static CSAdvancementTrigger LUFTBALLONS_TRIGGER = new CSAdvancementTrigger(new ResourceLocation("cloudstorage:luftballons"));
    public static LootItemFunctionType DYE_RANDOMLY_LOOT_FUNCTION = (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)new ResourceLocation("cloudstorage:dye_randomly"), (Object)new LootItemFunctionType((Serializer)new DyeRandomlyLootFunction.Serializer()));
    private Random random = new Random();
    private static final Map<ServerLevel, SkyMobSpawner> SKY_MOB_SPAWNER_MAP = new HashMap<ServerLevel, SkyMobSpawner>();

    public void clientInit() {
    }

    public void init() {
        CriteriaTriggers.m_10595_((CriterionTrigger)UPLOAD_TRIGGER);
        CriteriaTriggers.m_10595_((CriterionTrigger)LUFTBALLONS_TRIGGER);
    }

    public void setupParticles() {
    }

    public Object getISTERProperties(boolean armor) {
        return null;
    }

    public void setVisibleCloudSlots(int i) {
    }

    public int getVisibleCloudSlots() {
        return 0;
    }

    public Player getClientSidePlayer() {
        return null;
    }

    public void processSortPacket(Player player, int type) {
        if (player.f_36096_ instanceof CloudChestMenu && type == 0) {
            ((CloudChestMenu)player.f_36096_).sort(ItemSorting::defaultCompare);
        }
    }

    public void processSearchPacket(Player player, String search) {
        if (player.f_36096_ instanceof CloudChestMenu) {
            ((CloudChestMenu)player.f_36096_).search(player, search);
        }
    }

    public void processScrollPacket(Player player, int scrollAmount) {
        if (player.f_36096_ instanceof CloudChestMenu) {
            ((CloudChestMenu)player.f_36096_).setScrollAmount(scrollAmount);
            player.f_36096_.m_150429_();
        }
    }

    public void bakeEntityModels(EntityRenderersEvent.RegisterLayerDefinitions event) {
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack().m_41720_() == CSItemRegistry.BALLOON.get()) {
            event.setUseBlock(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        if (event.getRayTraceResult() instanceof EntityHitResult) {
            Projectile badloon2;
            BalloonBuddyEntity buddy;
            Entity entity = ((EntityHitResult)event.getRayTraceResult()).m_82443_();
            boolean flag = false;
            if (entity instanceof BalloonBuddyEntity && (buddy = (BalloonBuddyEntity)entity).getPersonality() == BalloonFace.SMIRK) {
                if (event.getEntity() instanceof AbstractArrow) {
                    ((AbstractArrow)event.getEntity()).m_36767_((byte)0);
                }
                event.setCanceled(true);
                boolean left = buddy.m_21187_().nextBoolean();
                Vec3 vector3d2 = new Vec3(0.0, 0.0, 1.0).m_82524_((float)((double)(left ? event.getProjectile().m_146908_() - 90.0f : event.getProjectile().m_146908_() + 90.0f) * Math.PI / 180.0)).m_82541_();
                buddy.f_19812_ = true;
                buddy.setRotZ(left ? -45.0f : 45.0f);
                buddy.m_6478_(MoverType.SELF, new Vec3(vector3d2.m_7096_(), vector3d2.m_7098_(), vector3d2.m_7094_()));
                flag = true;
            }
            if (!flag && (entity instanceof LivingBalloon || entity instanceof BalloonEntity)) {
                if (event.getProjectile().m_37282_() instanceof AbstractSkeleton && entity instanceof BadloonEntity) {
                    BadloonEntity badloon2 = (BadloonEntity)entity;
                    badloon2.dropMusicDisk = true;
                }
            } else if (!flag && (badloon2 = event.getProjectile()) instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)badloon2;
                AABB aabb = arrow.m_142469_().m_82400_(15.0);
                BalloonEntity tied = null;
                List balloons = arrow.f_19853_.m_45976_(BalloonEntity.class, aabb);
                for (BalloonEntity balloon : balloons) {
                    if (!balloon.isArrow() || balloon.getChildId() == null || !balloon.getChildId().equals(arrow.m_142081_())) continue;
                    tied = balloon;
                    break;
                }
                if (tied != null) {
                    tied.setChildId(entity.m_142081_());
                    tied.setStringLength(1);
                    tied.setArrowTime(this.random.nextInt(80) + 80);
                }
            }
        }
    }

    @SubscribeEvent
    public void onMobAttemptSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getEntityLiving() instanceof Monster && this.random.nextFloat() < 0.5f) {
            double dist = 64.0;
            AABB aabb = event.getEntityLiving().m_142469_().m_82400_(dist);
            List balloonBuddies = event.getWorld().m_45976_(BalloonBuddyEntity.class, aabb);
            if (!balloonBuddies.isEmpty()) {
                for (BalloonBuddyEntity balloonBuddy : balloonBuddies) {
                    if (balloonBuddy.getPersonality() != BalloonFace.HAPPY) continue;
                    event.setResult(Event.Result.DENY);
                    balloonBuddy.m_183503_().m_7605_((Entity)balloonBuddy, (byte)68);
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void onMobVisiblity(LivingEvent.LivingVisibilityEvent event) {
        if (event.getEntityLiving() instanceof Player) {
            double dist = 16.0;
            AABB aabb = event.getEntityLiving().m_142469_().m_82400_(dist);
            List balloonBuddies = event.getEntityLiving().m_183503_().m_45976_(BalloonBuddyEntity.class, aabb);
            if (!balloonBuddies.isEmpty()) {
                for (BalloonBuddyEntity balloonBuddy : balloonBuddies) {
                    if (balloonBuddy.getPersonality() != BalloonFace.EYEPATCH) continue;
                    event.modifyVisibility(0.25);
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void onVillagerTrades(VillagerTradesEvent event) {
        if (((Boolean)CloudStorage.CONFIG.balloonSalesmanVillager.get()).booleanValue() && event.getType() == CSVillagerRegistry.BALLOON_SALESMAN) {
            ArrayList<VillagerTrades.ItemListing> level1 = new ArrayList<VillagerTrades.ItemListing>();
            ArrayList<VillagerTrades.ItemListing> level2 = new ArrayList<VillagerTrades.ItemListing>();
            ArrayList<VillagerTrades.ItemListing> level3 = new ArrayList<VillagerTrades.ItemListing>();
            ArrayList<VillagerTrades.ItemListing> level4 = new ArrayList<VillagerTrades.ItemListing>();
            ArrayList<VillagerTrades.ItemListing> level5 = new ArrayList<VillagerTrades.ItemListing>();
            CSVillagerRegistry.initTrades(level1, level2, level3, level4, level5);
            event.getTrades().put(1, level1);
            event.getTrades().put(2, level2);
            event.getTrades().put(3, level3);
            event.getTrades().put(4, level4);
            event.getTrades().put(5, level5);
        }
    }

    public void processCloudInfoRequest(Player player, int balloonColor) {
        if (!player.m_183503_().f_46443_) {
            CSWorldData data = CSWorldData.get(player.m_183503_());
            int usedSlots = 0;
            int allSlots = 0;
            int staticUsedSlots = 0;
            int staticAllSlots = 0;
            if (data != null) {
                CloudIndex staticCloud = data.getPublicCloud(balloonColor);
                CloudIndex cloud = data.getPrivateCloud(player.m_142081_(), balloonColor);
                if (cloud != null) {
                    usedSlots = cloud.calcUsedSlots();
                    allSlots = cloud.getContainerSize();
                }
                if (staticCloud != null) {
                    staticUsedSlots = staticCloud.calcUsedSlots();
                    staticAllSlots = staticCloud.getContainerSize();
                }
            }
            CloudStorage.sendMSGToAll(new MessageUpdateCloudInfo(balloonColor, usedSlots, allSlots, staticUsedSlots, staticAllSlots));
        }
    }

    public void setClientCloudInfo(Player player, int balloonColor, CloudInfo cloudInfo) {
    }

    public void openBookScreen(ItemStack itemStackIn) {
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.WorldTickEvent tick) {
        if (!tick.world.f_46443_ && tick.world instanceof ServerLevel && ((Boolean)CloudStorage.CONFIG.skyMobSpawning.get()).booleanValue() && tick.world.m_46791_() != Difficulty.PEACEFUL) {
            ServerLevel serverWorld = (ServerLevel)tick.world;
            if (SKY_MOB_SPAWNER_MAP.get(serverWorld) == null) {
                SKY_MOB_SPAWNER_MAP.put(serverWorld, new SkyMobSpawner(serverWorld));
            }
            SkyMobSpawner spawner = SKY_MOB_SPAWNER_MAP.get(serverWorld);
            spawner.tick();
        }
    }

    private static void checkForLuftballoons(Player player) {
        int redBalloons = 0;
        Inventory inv = player.m_150109_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (inv.m_8020_(i).m_150930_((Item)CSItemRegistry.BALLOON.get()) && BalloonItem.getBalloonColor(inv.m_8020_(i)) == 15149353) {
                redBalloons += inv.m_8020_(i).m_41613_();
            }
            if (redBalloons >= 99) break;
        }
        if (redBalloons >= 99 && player instanceof ServerPlayer) {
            LUFTBALLONS_TRIGGER.trigger((ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public void onPlayerCraft(PlayerEvent.ItemCraftedEvent event) {
        CommonProxy.checkForLuftballoons(event.getPlayer());
    }

    @SubscribeEvent
    public void onPlayerPickup(PlayerEvent.ItemPickupEvent event) {
        CommonProxy.checkForLuftballoons(event.getPlayer());
    }

    @SubscribeEvent
    public void onPlayerOpenContainer(PlayerContainerEvent event) {
        CommonProxy.checkForLuftballoons(event.getPlayer());
    }

    @SubscribeEvent
    public void onEntitySetTarget(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof Mob && event.getTarget() instanceof BalloonBuddyEntity && ((BalloonBuddyEntity)event.getTarget()).getPersonality() == BalloonFace.EYEPATCH) {
            ((Mob)event.getEntityLiving()).m_6710_(null);
        }
    }

    public void onHoldingBalloon(LivingEntity holder, ItemStack balloon, boolean leftHanded) {
    }
}

