/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraftforge.common.util.FakePlayer;
import wile.redstonepen.libmc.detail.Registries;

public class StandardEntityBlocks {

    public static abstract class StandardBlockEntity
    extends BlockEntity {
        public StandardBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        public void tick() {
        }
    }

    public static interface IStandardEntityBlock<ET extends StandardBlockEntity>
    extends EntityBlock {
        public ResourceLocation getBlockRegistryName();

        default public boolean isBlockEntityTicking(Level world, BlockState state) {
            return false;
        }

        default public InteractionResult useOpenGui(BlockState state, Level world, BlockPos pos, Player player) {
            if (world.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof MenuProvider) || player instanceof FakePlayer) {
                return InteractionResult.FAIL;
            }
            player.m_5893_((MenuProvider)te);
            return InteractionResult.CONSUME;
        }

        @Nullable
        default public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            BlockEntityType<?> tet = Registries.getBlockEntityTypeOfBlock(this.getBlockRegistryName().m_135815_());
            return tet == null ? null : tet.m_155264_(pos, state);
        }

        @Nullable
        default public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> te_type) {
            return world.f_46443_ || !this.isBlockEntityTicking(world, state) ? null : (w, p, s, te) -> ((StandardBlockEntity)te).tick();
        }

        @Nullable
        default public <T extends BlockEntity> GameEventListener m_142226_(Level world, T te) {
            return null;
        }
    }
}

