/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.items;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ComparatorBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.redstonepen.ModContent;
import wile.redstonepen.blocks.RedstoneTrack;
import wile.redstonepen.libmc.detail.Auxiliaries;
import wile.redstonepen.libmc.detail.Inventories;
import wile.redstonepen.libmc.detail.Overlay;
import wile.redstonepen.libmc.detail.Registries;

public class RedstonePenItem
extends Item {
    public RedstonePenItem(Item.Properties properties) {
        super(properties.setNoRepair());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (this.getMaxDamage(stack) > 0) {
            tooltip.add((Component)Auxiliaries.localizable("item.redstonepen.pen.tooltip.numstored", this.getMaxDamage(stack) - this.getDamage(stack)));
        } else {
            tooltip.add((Component)Auxiliaries.localizable("item.redstonepen.pen.tooltip.rsfrominventory"));
        }
        Auxiliaries.Tooltip.addInformation(stack, (BlockGetter)world, tooltip, flag, true);
    }

    public Collection<CreativeModeTab> getCreativeTabs() {
        return Collections.singletonList(Registries.getCreativeModeTab());
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean m_41465_() {
        return this.m_41462_() > 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean m_142522_(ItemStack stack) {
        return this.m_41465_() && stack.m_41773_() > 0;
    }

    public int m_142158_(ItemStack stack) {
        return stack.m_41776_() <= 0 ? 13 : 13 - Mth.m_14045_((int)Math.round(13.0f * (float)stack.m_41773_() / (float)stack.m_41776_()), (int)0, (int)13);
    }

    public int m_142159_(ItemStack stack) {
        return 0x663333;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        Level world = player.m_20193_();
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof RepeaterBlock) {
            return false;
        }
        if (state.m_60713_(Blocks.f_50088_)) {
            RedstonePenItem.pushRedstone(stack, 1, player);
            world.m_7471_(pos, false);
            return true;
        }
        if (state.m_60713_((Block)ModContent.references.TRACK_BLOCK)) {
            InteractionHand hand;
            HitResult rt = player.m_19907_(10.0, 0.0f, false);
            if (rt.m_6662_() != HitResult.Type.BLOCK) {
                return false;
            }
            InteractionHand interactionHand = hand = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == this ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            if (state.m_60734_() instanceof RedstoneTrack.RedstoneTrackBlock) {
                ((RedstoneTrack.RedstoneTrackBlock)state.m_60734_()).onBlockActivated(state, player.m_20193_(), pos, player, hand, (BlockHitResult)rt, true);
                return true;
            }
        }
        return state.m_60800_((BlockGetter)world, pos) != 0.0f;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_();
        Level world = context.m_43725_();
        BlockState state = world.m_8055_(pos);
        if (state.m_60713_(Blocks.f_50088_)) {
            if (context.m_43725_().m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            RedstonePenItem.pushRedstone(stack, 1, player);
            world.m_7471_(pos, false);
            world.m_5594_(null, pos, SoundEvents.f_12016_, SoundSource.BLOCKS, 0.4f, 2.0f);
            return InteractionResult.CONSUME;
        }
        if (state.m_60734_() instanceof RedstoneTrack.RedstoneTrackBlock) {
            if (context.m_43725_().m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            BlockHitResult rtr = new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), context.m_43721_());
            return ((RedstoneTrack.RedstoneTrackBlock)state.m_60734_()).m_6227_(state, world, pos, player, hand, rtr);
        }
        if (!RedstoneTrack.RedstoneTrackBlock.canBePlacedOnFace(state, world, pos, facing)) {
            return InteractionResult.PASS;
        }
        if (context.m_43725_().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos target_pos = pos.m_142300_(facing);
        BlockState target_state = world.m_8055_(target_pos);
        if (target_state.m_60734_() instanceof RedstoneTrack.RedstoneTrackBlock) {
            BlockHitResult rtr = new BlockHitResult(context.m_43720_(), context.m_43719_(), target_pos, context.m_43721_());
            return ((RedstoneTrack.RedstoneTrackBlock)target_state.m_60734_()).m_6227_(target_state, world, target_pos, player, hand, rtr);
        }
        BlockHitResult rtr = new BlockHitResult(context.m_43720_(), context.m_43719_(), target_pos, context.m_43721_());
        BlockPlaceContext ctx = new BlockPlaceContext(context.m_43723_(), context.m_43724_(), new ItemStack((ItemLike)Items.f_42451_), rtr);
        BlockState rs_state = ModContent.references.TRACK_BLOCK.m_5573_(ctx);
        if (rs_state == null) {
            return InteractionResult.FAIL;
        }
        if (!state.m_60734_().m_6864_(target_state, ctx)) {
            return InteractionResult.FAIL;
        }
        if (!world.m_7731_(target_pos, rs_state, 3)) {
            return InteractionResult.FAIL;
        }
        BlockState placed_state = world.m_8055_(target_pos);
        if (!(placed_state.m_60734_() instanceof RedstoneTrack.RedstoneTrackBlock)) {
            world.m_7471_(target_pos, false);
            return InteractionResult.FAIL;
        }
        if (((RedstoneTrack.RedstoneTrackBlock)placed_state.m_60734_()).m_6227_(placed_state, world, target_pos, player, hand, rtr) == InteractionResult.FAIL) {
            return InteractionResult.FAIL;
        }
        ((RedstoneTrack.RedstoneTrackBlock)placed_state.m_60734_()).checkSmartPlacement(placed_state, world, target_pos, player, hand, rtr);
        return InteractionResult.CONSUME;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (!isSelected || !entity.m_6144_() || world.m_5776_() || (world.m_46467_() & 1L) != 0L || !(entity instanceof ServerPlayer)) {
            return;
        }
        HitResult rt = entity.m_19907_(10.0, 0.0f, false);
        if (rt.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult brtr = (BlockHitResult)rt;
        BlockPos pos = brtr.m_82425_();
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        Direction rs_side = brtr.m_82434_().m_122424_();
        TranslatableComponent tc = null;
        if (block == Blocks.f_50088_) {
            tc = Auxiliaries.localizable("overlay.wire_power", this.powerFormatted((Integer)state.m_61143_((Property)RedStoneWireBlock.f_55500_)));
        } else if (block == ModContent.references.TRACK_BLOCK) {
            RedstoneTrack.TrackTileEntity te = RedstoneTrack.RedstoneTrackBlock.tile((BlockGetter)world, pos).orElse(null);
            if (te == null) {
                return;
            }
            tc = Auxiliaries.localizable("overlay.track_power", this.powerFormatted(te.getSidePower(rs_side)));
            if (Auxiliaries.isDevelopmentMode()) {
                tc.m_7220_((Component)new TextComponent(String.format(" | %016x | ", te.getStateFlags())));
                tc.m_7220_((Component)new TextComponent(Arrays.stream(Direction.values()).map(side -> side.toString().substring(0, 1) + te.getRedstonePower(side.m_122424_(), false)).collect(Collectors.joining(","))));
            }
        } else if (state.m_60713_(Blocks.f_50146_)) {
            tc = Auxiliaries.localizable("overlay.direct_power", this.powerFormatted((Boolean)state.m_61143_((Property)RepeaterBlock.f_52496_) != false ? 15 : 0));
            tc.m_7220_((Component)Auxiliaries.localizable("overlay.repeater_delay", state.m_61143_((Property)RepeaterBlock.f_55798_)));
        } else if (state.m_60713_(Blocks.f_50328_)) {
            BlockEntity te = world.m_7702_(pos);
            if (te instanceof ComparatorBlockEntity) {
                tc = Auxiliaries.localizable("overlay.direct_power", this.powerFormatted(((ComparatorBlockEntity)te).m_59182_()));
                switch ((ComparatorMode)state.m_61143_((Property)ComparatorBlock.f_51854_)) {
                    case COMPARE: {
                        tc.m_7220_((Component)Auxiliaries.localizable("overlay.comparator_compare"));
                        break;
                    }
                    case SUBTRACT: {
                        tc.m_7220_((Component)Auxiliaries.localizable("overlay.comparator_subtract"));
                        break;
                    }
                }
            }
        } else if (state.m_60803_()) {
            int p = Math.max(state.m_60775_((BlockGetter)world, pos, rs_side), state.m_60746_((BlockGetter)world, pos, rs_side));
            if (p > 0) {
                tc = Auxiliaries.localizable("overlay.direct_power", this.powerFormatted(p));
            } else {
                Direction max_side = null;
                for (Direction side2 : Direction.values()) {
                    int ps;
                    if (side2 == rs_side || (ps = Math.max(state.m_60775_((BlockGetter)world, pos, side2), state.m_60746_((BlockGetter)world, pos, side2))) <= p) continue;
                    p = ps;
                    max_side = side2;
                    if (p >= 15) break;
                }
                tc = p == 0 || max_side == null ? Auxiliaries.localizable("overlay.direct_power", this.powerFormatted(p)) : Auxiliaries.localizable("overlay.direct_power_at", this.powerFormatted(p), max_side.m_122424_());
            }
        } else if (state.shouldCheckWeakPower((LevelReader)world, pos, rs_side)) {
            Direction max_side = Direction.values()[0];
            int p = 0;
            for (Direction d : Direction.values()) {
                int ps = world.m_46681_(pos.m_142300_(d), d);
                if (ps <= p) continue;
                p = ps;
                max_side = d;
                if (p >= 15) break;
            }
            if (p > 0) {
                tc = Auxiliaries.localizable("overlay.indirect_power", this.powerFormatted(p), max_side);
            }
        }
        if (tc != null) {
            Overlay.show((Player)((ServerPlayer)entity), (Component)tc, 400);
        }
    }

    private String powerFormatted(int p) {
        return String.format("%02d", p);
    }

    public static void pushRedstone(ItemStack stack, int amount, Player player) {
        if (player.m_7500_()) {
            return;
        }
        if (amount <= 0) {
            return;
        }
        if (RedstonePenItem.isPen(stack)) {
            if (!stack.m_41763_()) {
                ItemStack remaining = Inventories.insert(Inventories.itemhandler(player), new ItemStack((ItemLike)Items.f_42451_, amount), false);
                if (!remaining.m_41619_()) {
                    Inventories.give(player, remaining);
                }
            } else if (stack.m_41773_() >= amount) {
                stack.m_41721_(stack.m_41773_() - amount);
            } else {
                stack.m_41721_(0);
                Inventories.give(player, new ItemStack((ItemLike)Items.f_42451_, amount -= stack.m_41773_()));
            }
        } else if (stack.m_41720_() == Items.f_42451_) {
            if (stack.m_41613_() <= stack.m_41741_() - amount) {
                stack.m_41769_(amount);
            } else {
                Inventories.give(player, new ItemStack((ItemLike)Items.f_42451_, amount));
            }
        } else {
            Inventories.give(player, new ItemStack((ItemLike)Items.f_42451_, amount));
        }
    }

    public static int popRedstone(ItemStack stack, int amount, Player player, InteractionHand hand) {
        if (player.m_7500_()) {
            return amount;
        }
        if (amount <= 0) {
            return 0;
        }
        if (RedstonePenItem.isPen(stack)) {
            if (stack.m_41763_()) {
                int dmg = stack.m_41773_() + amount;
                if (dmg >= stack.m_41776_()) {
                    amount = stack.m_41776_() - stack.m_41773_();
                    player.m_21008_(hand, ItemStack.f_41583_);
                } else {
                    stack.m_41721_(dmg);
                }
            } else {
                amount = Inventories.extract(Inventories.itemhandler(player), new ItemStack((ItemLike)Items.f_42451_), amount, false).m_41613_();
            }
        } else if (stack.m_41720_() == Items.f_42451_) {
            if (stack.m_41613_() <= amount) {
                amount = stack.m_41613_();
                player.m_21008_(hand, ItemStack.f_41583_);
            } else {
                stack.m_41774_(amount);
            }
        }
        return amount;
    }

    public static boolean hasEnoughRedstone(ItemStack stack, int amount, Player player) {
        if (player.m_7500_()) {
            return true;
        }
        if (RedstonePenItem.isPen(stack)) {
            if (stack.m_41763_()) {
                return stack.m_41773_() < stack.m_41776_() - amount;
            }
            return Inventories.extract(Inventories.itemhandler(player), new ItemStack((ItemLike)Items.f_42451_), amount, true).m_41613_() >= amount;
        }
        if (stack.m_41720_() == Items.f_42451_) {
            return stack.m_41613_() >= amount;
        }
        return false;
    }

    public static boolean isFullRedstone(ItemStack stack) {
        if (RedstonePenItem.isPen(stack)) {
            return stack.m_41773_() <= 0;
        }
        if (stack.m_41720_() == Items.f_42451_) {
            return stack.m_41613_() >= stack.m_41741_();
        }
        return false;
    }

    public static boolean isPen(ItemStack stack) {
        return stack.m_41720_() instanceof RedstonePenItem;
    }
}

