/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wile.redstonepen.ModConfig;
import wile.redstonepen.ModContent;
import wile.redstonepen.detail.RcaSync;
import wile.redstonepen.libmc.detail.Auxiliaries;
import wile.redstonepen.libmc.detail.ExtendedShapelessRecipe;
import wile.redstonepen.libmc.detail.Networking;
import wile.redstonepen.libmc.detail.Overlay;
import wile.redstonepen.libmc.detail.Registries;

@Mod(value="redstonepen")
public class ModRedstonePen {
    public static final String MODID = "redstonepen";
    public static final String MODNAME = "Redstone Pen";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final boolean USE_CONFIG = false;

    public ModRedstonePen() {
        Auxiliaries.init(MODID, LOGGER, ModConfig::getServerConfig);
        Auxiliaries.logGitVersion(MODNAME);
        Registries.init(MODID, "quill");
        ModContent.init(MODID);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static Logger logger() {
        return LOGGER;
    }

    private void onSetup(FMLCommonSetupEvent event) {
        Networking.init(MODID);
        ModConfig.apply();
        RcaSync.CommonRca.init();
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        Overlay.register();
        ModContent.registerBlockEntityRenderers(event);
        ModContent.registerMenuGuis(event);
        ModContent.processContentClientSide();
        Overlay.TextOverlayGui.on_config(0.75, 0xFFAA00, 0x55333333, 0x55333333, 0x55444444);
        if (RcaSync.ClientRca.init()) {
            MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, ForgeEvents::onPlayerTickEvent);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static final class ForgeEvents {
        @SubscribeEvent
        public static void onBlockRegistry(RegistryEvent.Register<Block> event) {
            Registries.onBlockRegistry((ResourceLocation rl, Block block) -> event.getRegistry().register((IForgeRegistryEntry)block));
        }

        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> event) {
            Registries.onItemRegistry((ResourceLocation rl, Item item) -> event.getRegistry().register((IForgeRegistryEntry)item));
        }

        @SubscribeEvent
        public static void onBlockEntityRegistry(RegistryEvent.Register<BlockEntityType<?>> event) {
            Registries.onBlockEntityRegistry((ResourceLocation rl, BlockEntityType<?> tet) -> event.getRegistry().register((IForgeRegistryEntry)tet));
        }

        @SubscribeEvent
        public static void onRegisterMenuTypes(RegistryEvent.Register<MenuType<?>> event) {
            Registries.onMenuTypeRegistry((rl, ct) -> event.getRegistry().register((IForgeRegistryEntry)ct));
        }

        @SubscribeEvent
        public static void onRegisterModels(ModelRegistryEvent event) {
            ModContent.registerModels();
        }

        @SubscribeEvent
        public static void onRecipeRegistry(RegistryEvent.Register<RecipeSerializer<?>> event) {
            event.getRegistry().register((IForgeRegistryEntry)ExtendedShapelessRecipe.SERIALIZER);
        }

        public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
            if (event.phase != TickEvent.Phase.END || !event.player.f_19853_.f_46443_) {
                return;
            }
            if ((event.player.f_19853_.m_46467_() & 1L) != 0L) {
                return;
            }
            RcaSync.ClientRca.tick();
        }
    }
}

