/*
 * Decompiled with CFR 0.152.
 */
package com.luxtracon.floralis.common.world.structure;

import com.google.common.collect.ImmutableList;
import com.luxtracon.floralis.common.config.FloralisStructuresConfig;
import com.luxtracon.floralis.mixin.SingleJigsawAccess;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.DesertVillagePools;
import net.minecraft.data.worldgen.PlainVillagePools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.data.worldgen.SavannaVillagePools;
import net.minecraft.data.worldgen.SnowyVillagePools;
import net.minecraft.data.worldgen.TaigaVillagePools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class FloralisStructures {
    private static final int WEIGHT = 4;

    public static void register() {
        PlainVillagePools.m_127185_();
        SnowyVillagePools.m_127233_();
        SavannaVillagePools.m_127230_();
        DesertVillagePools.m_126860_();
        TaigaVillagePools.m_127305_();
        if (((Boolean)FloralisStructuresConfig.PLAINS_FIELD.get()).booleanValue()) {
            FloralisStructures.addStructureToPool(new ResourceLocation("village/plains/houses"), new ResourceLocation("floralis", "village/houses/plains_field"));
        }
        if (((Boolean)FloralisStructuresConfig.SNOWY_FIELD.get()).booleanValue()) {
            FloralisStructures.addStructureToPool(new ResourceLocation("village/snowy/houses"), new ResourceLocation("floralis", "village/houses/snowy_field"));
        }
        if (((Boolean)FloralisStructuresConfig.SAVANNA_FIELD.get()).booleanValue()) {
            FloralisStructures.addStructureToPool(new ResourceLocation("village/savanna/houses"), new ResourceLocation("floralis", "village/houses/savanna_field"));
        }
        if (((Boolean)FloralisStructuresConfig.DESERT_FIELD.get()).booleanValue()) {
            FloralisStructures.addStructureToPool(new ResourceLocation("village/desert/houses"), new ResourceLocation("floralis", "village/houses/desert_field"));
        }
        if (((Boolean)FloralisStructuresConfig.TAIGA_FIELD.get()).booleanValue()) {
            FloralisStructures.addStructureToPool(new ResourceLocation("village/taiga/houses"), new ResourceLocation("floralis", "village/houses/taiga_field"));
        }
    }

    private static void addStructureToPool(ResourceLocation pool, ResourceLocation structure) {
        StructureTemplatePool structureTemplatePool = (StructureTemplatePool)BuiltinRegistries.f_123864_.m_7745_(pool);
        int id = BuiltinRegistries.f_123864_.m_7447_((Object)structureTemplatePool);
        List structurePoolElementList = structureTemplatePool != null ? structureTemplatePool.m_210588_(new Random(0L)) : ImmutableList.of();
        Object2IntLinkedOpenHashMap structurePoolElementMap = new Object2IntLinkedOpenHashMap();
        Iterator iterator = structurePoolElementList.iterator();
        while (iterator.hasNext()) {
            StructurePoolElement structurePoolElement = (StructurePoolElement)iterator.next();
            structurePoolElementMap.computeInt((Object)structurePoolElement, (p, i) -> (i == null ? 0 : i) + 1);
        }
        structurePoolElementMap.put((Object)SingleJigsawAccess.construct((Either<ResourceLocation, StructureTemplate>)Either.left((Object)structure), (Holder<StructureProcessorList>)ProcessorLists.f_127198_, StructureTemplatePool.Projection.RIGID), 4);
        List newStructure = structurePoolElementMap.object2IntEntrySet().stream().map(e -> Pair.of((Object)((StructurePoolElement)e.getKey()), (Object)e.getIntValue())).collect(Collectors.toList());
        ResourceLocation resourceLocation = structureTemplatePool.m_210587_();
        ((WritableRegistry)BuiltinRegistries.f_123864_).m_203384_(OptionalInt.of(id), ResourceKey.m_135785_((ResourceKey)BuiltinRegistries.f_123864_.m_123023_(), (ResourceLocation)resourceLocation), (Object)new StructureTemplatePool(pool, resourceLocation, newStructure), Lifecycle.stable());
    }
}

