/*
 * Decompiled with CFR 0.152.
 */
package com.luxtracon.floralis.common.blocks;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.event.ForgeEventFactory;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CactusCropBlock
extends Block
implements BonemealableBlock,
IPlantable {
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)2.0, (double)9.0), Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0), Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0)};
    private static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)5);
    private static final int MAX_AGE = 5;

    public CactusCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos posBelow = pPos.m_7495_();
        return (pLevel.m_45524_(pPos, 0) >= 8 || pLevel.m_45527_(pPos)) && this.mayPlaceOn(pLevel.m_8055_(posBelow));
    }

    public boolean m_5491_(Level pLevel, Random pRandom, BlockPos pPos, BlockState pState) {
        return this.isNotMaxAge(pState);
    }

    public boolean isNotMaxAge(BlockState pState) {
        return (Integer)pState.m_61143_((Property)this.getAgeProperty()) < this.getMaxAge();
    }

    public boolean m_6724_(BlockState pState) {
        return this.isNotMaxAge(pState);
    }

    public boolean m_7370_(BlockGetter pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return this.isNotMaxAge(pState);
    }

    public boolean mayPlaceOn(BlockState pState) {
        return pState.m_204336_(BlockTags.f_13029_);
    }

    public static float getGrowthSpeed(Block pBlock, BlockGetter pLevel, BlockPos pPos) {
        boolean flagSecond;
        BlockPos posBelow = pPos.m_7495_();
        float floatFirst = 1.0f;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float floatSecond = 0.0f;
                if (pLevel.m_8055_(posBelow.m_142082_(i, 0, j)).canSustainPlant(pLevel, posBelow.m_142082_(i, 0, j), Direction.UP, (IPlantable)pBlock)) {
                    floatSecond = 1.0f;
                    if (pLevel.m_8055_(posBelow.m_142082_(i, 0, j)).isFertile(pLevel, pPos.m_142082_(i, 0, j))) {
                        floatSecond = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    floatSecond /= 4.0f;
                }
                floatFirst += floatSecond;
            }
        }
        BlockPos posNorth = pPos.m_142127_();
        BlockPos posSouth = pPos.m_142128_();
        BlockPos posWest = pPos.m_142125_();
        BlockPos posEast = pPos.m_142126_();
        boolean flagFirst = pLevel.m_8055_(posWest).m_60713_(pBlock) || pLevel.m_8055_(posEast).m_60713_(pBlock);
        boolean bl = flagSecond = pLevel.m_8055_(posNorth).m_60713_(pBlock) || pLevel.m_8055_(posSouth).m_60713_(pBlock);
        if (flagFirst && flagSecond) {
            floatFirst /= 2.0f;
        } else {
            boolean flagThird;
            boolean bl2 = flagThird = pLevel.m_8055_(posWest.m_142127_()).m_60713_(pBlock) || pLevel.m_8055_(posEast.m_142127_()).m_60713_(pBlock) || pLevel.m_8055_(posEast.m_142128_()).m_60713_(pBlock) || pLevel.m_8055_(posWest.m_142128_()).m_60713_(pBlock);
            if (flagThird) {
                floatFirst /= 2.0f;
            }
        }
        return floatFirst;
    }

    public int getAge(BlockState pState) {
        return (Integer)pState.m_61143_((Property)this.getAgeProperty());
    }

    public int getBonemealAgeIncrease(Level pLevel) {
        return Mth.m_14072_((Random)pLevel.f_46441_, (int)1, (int)3);
    }

    public int getMaxAge() {
        return 5;
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AGE});
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pEntity instanceof Ravager && ForgeEventFactory.getMobGriefingEvent((Level)pLevel, (Entity)pEntity)) {
            pLevel.m_46953_(pPos, true, pEntity);
        }
        if (pEntity instanceof Villager) {
            pEntity.m_20331_(true);
        }
        if (this.getAge(pState) >= 3) {
            pEntity.m_6469_(DamageSource.f_19314_, 1.0f);
        }
    }

    public void growCrops(Level pLevel, BlockPos pPos, BlockState pState) {
        int i = this.getAge(pState) + this.getBonemealAgeIncrease(pLevel);
        if (i > this.getMaxAge()) {
            i = this.getMaxAge();
        }
        pLevel.m_7731_(pPos, this.getStateForAge(i), 2);
    }

    public void m_7719_(ServerLevel pLevel, Random pRandom, BlockPos pPos, BlockState pState) {
        this.growCrops((Level)pLevel, pPos, pState);
    }

    public void m_7455_(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRandom) {
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        if (pLevel.m_45524_(pPos, 0) >= 8 && this.getAge(pState) < this.getMaxAge() && ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.nextInt((int)(25.0f / CactusCropBlock.getGrowthSpeed(this, (BlockGetter)pLevel, pPos)) + 1) == 0 ? 1 : 0) != 0)) {
            pLevel.m_7731_(pPos, this.getStateForAge(this.getAge(pState) + 1), 2);
            ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public BlockState getPlant(BlockGetter world, BlockPos pos) {
        return world.m_8055_(pos);
    }

    public BlockState getStateForAge(int pAge) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(pAge));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.CROP;
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPES[(Integer)pState.m_61143_((Property)this.getAgeProperty())];
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPES[(Integer)pState.m_61143_((Property)this.getAgeProperty())];
    }
}

