/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client;

import com.google.common.collect.BiMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import dev.architectury.platform.Platform;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.ClientInternals;
import me.shedaniel.rei.plugin.autocrafting.recipebook.DefaultRecipeBookHandler;
import me.shedaniel.rei.plugin.client.BuiltinClientPlugin;
import me.shedaniel.rei.plugin.client.categories.DefaultBrewingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultCampfireCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultCompostingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultFuelCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultInformationCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultOxidationScrapingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultOxidizingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultPathingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultSmithingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultStoneCuttingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultStrippingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultTillingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultWaxScrapingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultWaxingCategory;
import me.shedaniel.rei.plugin.client.categories.anvil.DefaultAnvilCategory;
import me.shedaniel.rei.plugin.client.categories.beacon.DefaultBeaconBaseCategory;
import me.shedaniel.rei.plugin.client.categories.beacon.DefaultBeaconPaymentCategory;
import me.shedaniel.rei.plugin.client.categories.cooking.DefaultCookingCategory;
import me.shedaniel.rei.plugin.client.categories.crafting.DefaultCraftingCategory;
import me.shedaniel.rei.plugin.client.categories.tag.DefaultTagCategory;
import me.shedaniel.rei.plugin.client.exclusionzones.DefaultPotionEffectExclusionZones;
import me.shedaniel.rei.plugin.client.exclusionzones.DefaultRecipeBookExclusionZones;
import me.shedaniel.rei.plugin.client.favorites.GameModeFavoriteEntry;
import me.shedaniel.rei.plugin.client.favorites.TimeFavoriteEntry;
import me.shedaniel.rei.plugin.client.favorites.WeatherFavoriteEntry;
import me.shedaniel.rei.plugin.common.displays.DefaultCampfireDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultCompostingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultFuelDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultInformationDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultOxidationScrapingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultOxidizingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultPathingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultSmithingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultStoneCuttingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultStrippingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultWaxScrapingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultWaxingDisplay;
import me.shedaniel.rei.plugin.common.displays.anvil.AnvilRecipe;
import me.shedaniel.rei.plugin.common.displays.anvil.DefaultAnvilDisplay;
import me.shedaniel.rei.plugin.common.displays.beacon.DefaultBeaconBaseDisplay;
import me.shedaniel.rei.plugin.common.displays.beacon.DefaultBeaconPaymentDisplay;
import me.shedaniel.rei.plugin.common.displays.brewing.BrewingRecipe;
import me.shedaniel.rei.plugin.common.displays.brewing.DefaultBrewingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultBlastingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultSmeltingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultSmokingDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomDisplay;
import me.shedaniel.rei.plugin.common.displays.tag.DefaultTagDisplay;
import net.minecraft.client.gui.screens.inventory.BlastFurnaceScreen;
import net.minecraft.client.gui.screens.inventory.BrewingStandScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.FurnaceScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.SmokerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class DefaultClientPlugin
implements REIClientPlugin,
BuiltinClientPlugin {
    public DefaultClientPlugin() {
        ClientInternals.attachInstance(() -> this, "builtinClientPlugin");
    }

    @Override
    public void registerBrewingRecipe(Ingredient input, Ingredient ingredient, ItemStack output) {
        DisplayRegistry.getInstance().add(new BrewingRecipe(input, ingredient, output));
    }

    @Override
    public void registerInformation(EntryIngredient ingredient, Component name, UnaryOperator<List<Component>> textBuilder) {
        DisplayRegistry.getInstance().add(DefaultInformationDisplay.createFromEntries(ingredient, name).lines((Collection)textBuilder.apply(Lists.newArrayList())));
    }

    @Override
    public void registerEntries(EntryRegistry registry) {
        for (Item item : Registry.f_122827_) {
            try {
                registry.addEntries(EntryIngredients.ofItemStacks(registry.appendStacksForItem(item)));
            }
            catch (Exception ignored) {
                registry.addEntry(EntryStacks.of((ItemLike)item));
            }
        }
        for (Fluid fluid : Registry.f_122822_) {
            FluidState state = fluid.m_76145_();
            if (state.m_76178_() || !state.m_76170_()) continue;
            registry.addEntry(EntryStacks.of(fluid));
        }
    }

    @Override
    public void registerCategories(CategoryRegistry registry) {
        registry.add(new DefaultCraftingCategory(), new DefaultCookingCategory(SMELTING, EntryStacks.of((ItemLike)Items.f_41962_), "category.rei.smelting"), new DefaultCookingCategory(SMOKING, EntryStacks.of((ItemLike)Items.f_42769_), "category.rei.smoking"), new DefaultCookingCategory(BLASTING, EntryStacks.of((ItemLike)Items.f_42770_), "category.rei.blasting"), new DefaultCampfireCategory(), new DefaultStoneCuttingCategory(), new DefaultFuelCategory(), new DefaultBrewingCategory(), new DefaultCompostingCategory(), new DefaultStrippingCategory(), new DefaultSmithingCategory(), new DefaultAnvilCategory(), new DefaultBeaconBaseCategory(), new DefaultBeaconPaymentCategory(), new DefaultTillingCategory(), new DefaultPathingCategory(), new DefaultWaxingCategory(), new DefaultWaxScrapingCategory(), new DefaultOxidizingCategory(), new DefaultOxidationScrapingCategory());
        registry.addWorkstations(CRAFTING, EntryStacks.of((ItemLike)Items.f_41960_));
        registry.addWorkstations(SMELTING, EntryStacks.of((ItemLike)Items.f_41962_));
        registry.addWorkstations(SMOKING, EntryStacks.of((ItemLike)Items.f_42769_));
        registry.addWorkstations(BLASTING, EntryStacks.of((ItemLike)Items.f_42770_));
        registry.addWorkstations(CAMPFIRE, EntryStacks.of((ItemLike)Items.f_42781_), EntryStacks.of((ItemLike)Items.f_42782_));
        registry.addWorkstations(FUEL, EntryStacks.of((ItemLike)Items.f_41962_), EntryStacks.of((ItemLike)Items.f_42769_), EntryStacks.of((ItemLike)Items.f_42770_));
        registry.addWorkstations(BREWING, EntryStacks.of((ItemLike)Items.f_42543_));
        registry.addWorkstations(ANVIL, EntryStacks.of((ItemLike)Items.f_42146_));
        registry.addWorkstations(STONE_CUTTING, EntryStacks.of((ItemLike)Items.f_42776_));
        registry.addWorkstations(COMPOSTING, EntryStacks.of((ItemLike)Items.f_42726_));
        registry.addWorkstations(SMITHING, EntryStacks.of((ItemLike)Items.f_42775_));
        registry.addWorkstations(BEACON_BASE, EntryStacks.of((ItemLike)Items.f_42065_));
        registry.addWorkstations(BEACON_PAYMENT, EntryStacks.of((ItemLike)Items.f_42065_));
        registry.addWorkstations(WAXING, EntryStacks.of((ItemLike)Items.f_42784_));
        HashSet axes = Sets.newHashSet();
        HashSet hoes = Sets.newHashSet();
        HashSet shovels = Sets.newHashSet();
        EntryRegistry.getInstance().getEntryStacks().filter(stack -> stack.getValueType() == ItemStack.class).map(stack -> ((ItemStack)stack.getValue()).m_41720_()).forEach(item -> {
            if (item instanceof AxeItem && axes.add(item)) {
                registry.addWorkstations(STRIPPING, EntryStacks.of((ItemLike)item));
                registry.addWorkstations(WAX_SCRAPING, EntryStacks.of((ItemLike)item));
                registry.addWorkstations(OXIDATION_SCRAPING, EntryStacks.of((ItemLike)item));
            }
            if (item instanceof HoeItem && hoes.add(item)) {
                registry.addWorkstations(TILLING, EntryStacks.of((ItemLike)item));
            }
            if (item instanceof ShovelItem && shovels.add(item)) {
                registry.addWorkstations(PATHING, EntryStacks.of((ItemLike)item));
            }
        });
        for (EntryStack stack2 : DefaultClientPlugin.getTag(new ResourceLocation("c", "axes"))) {
            if (!axes.add(((ItemStack)stack2.castValue()).m_41720_())) continue;
            registry.addWorkstations(STRIPPING, stack2);
            registry.addWorkstations(WAX_SCRAPING, stack2);
            registry.addWorkstations(OXIDATION_SCRAPING, stack2);
        }
        for (EntryStack stack2 : DefaultClientPlugin.getTag(new ResourceLocation("c", "hoes"))) {
            if (!hoes.add(((ItemStack)stack2.castValue()).m_41720_())) continue;
            registry.addWorkstations(TILLING, stack2);
        }
        for (EntryStack stack2 : DefaultClientPlugin.getTag(new ResourceLocation("c", "shovels"))) {
            if (!shovels.add(((ItemStack)stack2.castValue()).m_41720_())) continue;
            registry.addWorkstations(PATHING, stack2);
        }
    }

    private static EntryIngredient getTag(ResourceLocation tagId) {
        return EntryIngredients.ofItemTag(TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)tagId));
    }

    @Override
    public void registerDisplays(DisplayRegistry registry) {
        CategoryRegistry.getInstance().add(new DefaultInformationCategory(), new DefaultTagCategory());
        registry.registerRecipeFiller(CraftingRecipe.class, RecipeType.f_44107_, DefaultCraftingDisplay::of);
        registry.registerRecipeFiller(SmeltingRecipe.class, RecipeType.f_44108_, DefaultSmeltingDisplay::new);
        registry.registerRecipeFiller(SmokingRecipe.class, RecipeType.f_44110_, DefaultSmokingDisplay::new);
        registry.registerRecipeFiller(BlastingRecipe.class, RecipeType.f_44109_, DefaultBlastingDisplay::new);
        registry.registerRecipeFiller(CampfireCookingRecipe.class, RecipeType.f_44111_, DefaultCampfireDisplay::new);
        registry.registerRecipeFiller(StonecutterRecipe.class, RecipeType.f_44112_, DefaultStoneCuttingDisplay::new);
        registry.registerRecipeFiller(UpgradeRecipe.class, RecipeType.f_44113_, DefaultSmithingDisplay::new);
        registry.registerFiller(AnvilRecipe.class, DefaultAnvilDisplay::new);
        registry.registerFiller(BrewingRecipe.class, DefaultBrewingDisplay::new);
        registry.registerFiller(TagKey.class, tagKey -> {
            if (tagKey.m_207645_(Registry.f_122904_)) {
                return DefaultTagDisplay.ofItems((TagKey<ItemLike>)tagKey);
            }
            if (tagKey.m_207645_(Registry.f_122901_)) {
                return DefaultTagDisplay.ofItems((TagKey<ItemLike>)tagKey);
            }
            if (tagKey.m_207645_(Registry.f_122899_)) {
                return DefaultTagDisplay.ofFluids((TagKey<Fluid>)tagKey);
            }
            return null;
        });
        for (Map.Entry entry2 : AbstractFurnaceBlockEntity.m_58423_().entrySet()) {
            registry.add(new DefaultFuelDisplay(Collections.singletonList(EntryIngredients.of((ItemLike)entry2.getKey())), Collections.emptyList(), (Integer)entry2.getValue()));
        }
        EntryIngredient arrowStack = EntryIngredient.of(EntryStacks.of((ItemLike)Items.f_42412_));
        ReferenceOpenHashSet registeredPotions = new ReferenceOpenHashSet();
        EntryRegistry.getInstance().getEntryStacks().filter(entry -> entry.getValueType() == ItemStack.class && ((ItemStack)entry.castValue()).m_41720_() == Items.f_42739_).forEach(arg_0 -> DefaultClientPlugin.lambda$registerDisplays$6((ReferenceSet)registeredPotions, arrowStack, registry, arg_0));
        if (ComposterBlock.f_51914_.isEmpty()) {
            ComposterBlock.m_51988_();
        }
        int page = 0;
        UnmodifiableIterator iterator = Iterators.partition(ComposterBlock.f_51914_.object2FloatEntrySet().stream().sorted(Map.Entry.comparingByValue()).iterator(), (int)35);
        while (iterator.hasNext()) {
            List entries = (List)iterator.next();
            registry.add(DefaultCompostingDisplay.of(entries, Collections.singletonList(EntryIngredients.of(new ItemStack((ItemLike)Items.f_42499_))), page++));
        }
        DummyAxeItem.getStrippedBlocksMap().entrySet().stream().sorted(Comparator.comparing(b -> Registry.f_122824_.m_7981_((Object)((Block)b.getKey())))).forEach(set -> registry.add(new DefaultStrippingDisplay(EntryStacks.of((ItemLike)set.getKey()), EntryStacks.of((ItemLike)set.getValue()))));
        DummyShovelItem.getPathBlocksMap().entrySet().stream().sorted(Comparator.comparing(b -> Registry.f_122824_.m_7981_((Object)((Block)b.getKey())))).forEach(set -> registry.add(new DefaultPathingDisplay(EntryStacks.of((ItemLike)set.getKey()), EntryStacks.of((ItemLike)((BlockState)set.getValue()).m_60734_()))));
        registry.add(new DefaultBeaconBaseDisplay(Collections.singletonList(EntryIngredients.ofItemTag(BlockTags.f_13079_)), Collections.emptyList()));
        registry.add(new DefaultBeaconPaymentDisplay(Collections.singletonList(EntryIngredients.ofItemTag(ItemTags.f_13164_)), Collections.emptyList()));
        ((BiMap)HoneycombItem.f_150863_.get()).entrySet().stream().sorted(Comparator.comparing(b -> Registry.f_122824_.m_7981_((Object)((Block)b.getKey())))).forEach(set -> registry.add(new DefaultWaxingDisplay(EntryStacks.of((ItemLike)set.getKey()), EntryStacks.of((ItemLike)set.getValue()))));
        ((BiMap)HoneycombItem.f_150864_.get()).entrySet().stream().sorted(Comparator.comparing(b -> Registry.f_122824_.m_7981_((Object)((Block)b.getKey())))).forEach(set -> registry.add(new DefaultWaxScrapingDisplay(EntryStacks.of((ItemLike)set.getKey()), EntryStacks.of((ItemLike)set.getValue()))));
        ((BiMap)WeatheringCopper.f_154886_.get()).entrySet().stream().sorted(Comparator.comparing(b -> Registry.f_122824_.m_7981_((Object)((Block)b.getKey())))).forEach(set -> registry.add(new DefaultOxidizingDisplay(EntryStacks.of((ItemLike)set.getKey()), EntryStacks.of((ItemLike)set.getValue()))));
        ((BiMap)WeatheringCopper.f_154887_.get()).entrySet().stream().sorted(Comparator.comparing(b -> Registry.f_122824_.m_7981_((Object)((Block)b.getKey())))).forEach(set -> registry.add(new DefaultOxidationScrapingDisplay(EntryStacks.of((ItemLike)set.getKey()), EntryStacks.of((ItemLike)set.getValue()))));
        if (Platform.isFabric()) {
            ItemStack output;
            Ingredient base;
            Potion to;
            Ingredient ingredient;
            Potion from;
            LinkedHashSet potions = Sets.newLinkedHashSet();
            for (Ingredient container : PotionBrewing.f_43496_) {
                for (PotionBrewing.Mix mix : PotionBrewing.f_43494_) {
                    from = (Potion)mix.from;
                    ingredient = mix.f_43533_;
                    to = (Potion)mix.to;
                    base = Ingredient.m_43921_(Arrays.stream(container.m_43908_()).map(ItemStack::m_41777_).map(stack -> PotionUtils.m_43549_((ItemStack)stack, (Potion)from)));
                    output = Arrays.stream(container.m_43908_()).map(ItemStack::m_41777_).map(stack -> PotionUtils.m_43549_((ItemStack)stack, (Potion)to)).findFirst().orElse(ItemStack.f_41583_);
                    this.registerBrewingRecipe(base, ingredient, output);
                    potions.add(from);
                    potions.add(to);
                }
            }
            for (Potion potion : potions) {
                for (PotionBrewing.Mix mix : PotionBrewing.f_43495_) {
                    from = (Item)mix.from;
                    ingredient = mix.f_43533_;
                    to = (Item)mix.to;
                    base = Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)from), (Potion)potion)});
                    output = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)to), (Potion)potion);
                    this.registerBrewingRecipe(base, ingredient, output);
                }
            }
        } else {
            this.registerForgePotions(registry, this);
        }
        for (Registry reg : Registry.f_122897_) {
            reg.m_203612_().forEach(tagPair -> registry.add(tagPair.getFirst()));
        }
    }

    protected void registerForgePotions(DisplayRegistry registry, BuiltinClientPlugin clientPlugin) {
    }

    @Override
    public void registerExclusionZones(ExclusionZones zones) {
        zones.register(EffectRenderingInventoryScreen.class, new DefaultPotionEffectExclusionZones());
        zones.register(RecipeUpdateListener.class, new DefaultRecipeBookExclusionZones());
    }

    @Override
    public void registerScreens(ScreenRegistry registry) {
        registry.registerContainerClickArea(new Rectangle(88, 32, 28, 23), CraftingScreen.class, CRAFTING);
        registry.registerContainerClickArea(new Rectangle(137, 29, 10, 13), InventoryScreen.class, CRAFTING);
        registry.registerContainerClickArea(new Rectangle(97, 16, 14, 30), BrewingStandScreen.class, BREWING);
        registry.registerContainerClickArea(new Rectangle(78, 32, 28, 23), FurnaceScreen.class, SMELTING);
        registry.registerContainerClickArea(new Rectangle(78, 32, 28, 23), SmokerScreen.class, SMOKING);
        registry.registerContainerClickArea(new Rectangle(78, 32, 28, 23), BlastFurnaceScreen.class, BLASTING);
    }

    @Override
    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        registry.register(new DefaultRecipeBookHandler());
    }

    @Override
    public void registerFavorites(FavoriteEntryType.Registry registry) {
        registry.register(GameModeFavoriteEntry.ID, GameModeFavoriteEntry.Type.INSTANCE);
        registry.getOrCrateSection((Component)new TranslatableComponent("favorite.section.gamemode")).add((FavoriteEntry[])Stream.concat(Arrays.stream(GameType.values()).filter(type -> type.m_46392_() >= 0), Stream.of((GameType)null)).map(GameModeFavoriteEntry::new).toArray(FavoriteEntry[]::new));
        registry.register(WeatherFavoriteEntry.ID, WeatherFavoriteEntry.Type.INSTANCE);
        registry.getOrCrateSection((Component)new TranslatableComponent("favorite.section.weather")).add((FavoriteEntry[])Stream.concat(Arrays.stream(WeatherFavoriteEntry.Weather.values()), Stream.of((WeatherFavoriteEntry.Weather)null)).map(WeatherFavoriteEntry::new).toArray(FavoriteEntry[]::new));
        registry.register(TimeFavoriteEntry.ID, TimeFavoriteEntry.Type.INSTANCE);
        registry.getOrCrateSection((Component)new TranslatableComponent("favorite.section.time")).add((FavoriteEntry[])Stream.concat(Arrays.stream(TimeFavoriteEntry.Time.values()), Stream.of((TimeFavoriteEntry.Time)null)).map(TimeFavoriteEntry::new).toArray(FavoriteEntry[]::new));
    }

    @Override
    public double getPriority() {
        return -100.0;
    }

    private static /* synthetic */ void lambda$registerDisplays$6(ReferenceSet registeredPotions, EntryIngredient arrowStack, DisplayRegistry registry, EntryStack entry) {
        ItemStack itemStack = (ItemStack)entry.getValue();
        Potion potion = PotionUtils.m_43579_((ItemStack)itemStack);
        if (registeredPotions.add((Object)potion)) {
            int i;
            ArrayList<EntryIngredient> input = new ArrayList<EntryIngredient>();
            for (i = 0; i < 4; ++i) {
                input.add(arrowStack);
            }
            input.add(EntryIngredients.of(itemStack));
            for (i = 0; i < 4; ++i) {
                input.add(arrowStack);
            }
            ItemStack outputStack = new ItemStack((ItemLike)Items.f_42738_, 8);
            PotionUtils.m_43549_((ItemStack)outputStack, (Potion)potion);
            PotionUtils.m_43552_((ItemStack)outputStack, (Collection)PotionUtils.m_43571_((ItemStack)itemStack));
            EntryIngredient output = EntryIngredients.of(outputStack);
            registry.add(new DefaultCustomDisplay(null, input, Collections.singletonList(output)));
        }
    }

    public static class DummyAxeItem
    extends AxeItem {
        public DummyAxeItem(Tier tier, float f, float g, Item.Properties properties) {
            super(tier, f, g, properties);
        }

        public static Map<Block, Block> getStrippedBlocksMap() {
            return f_150683_;
        }
    }

    public static class DummyShovelItem
    extends ShovelItem {
        public DummyShovelItem(Tier tier, float f, float g, Item.Properties properties) {
            super(tier, f, g, properties);
        }

        public static Map<Block, BlockState> getPathBlocksMap() {
            return f_43110_;
        }
    }
}

