/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.mixin.forge;

import com.google.common.base.Stopwatch;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.plugin.common.displays.tag.TagNodes;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagLoader;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TagLoader.class})
public class MixinTagLoader<T> {
    @Shadow
    @Final
    private String f_13449_;

    @Inject(method={"build"}, at={@At(value="HEAD")})
    private void load(Map<ResourceLocation, Tag.Builder> map, CallbackInfoReturnable<Map<ResourceLocation, Tag<T>>> cir) {
        TagNodes.RAW_TAG_DATA_MAP.put(this.f_13449_, new HashMap());
        TagNodes.CURRENT_TAG_DIR.set(this.f_13449_);
    }

    @Inject(method={"build"}, at={@At(value="RETURN")})
    private void loadPost(Map<ResourceLocation, Tag.Builder> map, CallbackInfoReturnable<Map<ResourceLocation, Tag<T>>> cir) {
        HashMap<Tag, ResourceLocation> inverseMap = new HashMap<Tag, ResourceLocation>(((Map)cir.getReturnValue()).size());
        for (Map.Entry entry : ((Map)cir.getReturnValue()).entrySet()) {
            inverseMap.put((Tag)entry.getValue(), (ResourceLocation)entry.getKey());
        }
        ResourceKey<? extends Registry<?>> resourceKey = TagNodes.TAG_DIR_MAP.get(this.f_13449_);
        if (resourceKey == null) {
            return;
        }
        TagNodes.TAG_DATA_MAP.put(resourceKey, new HashMap());
        Map<ResourceLocation, TagNodes.TagData> tagDataMap = TagNodes.TAG_DATA_MAP.get(resourceKey);
        if (tagDataMap == null) {
            return;
        }
        Registry registry = (Registry)Registry.f_122897_.m_6246_(resourceKey);
        Stopwatch stopwatch = Stopwatch.createStarted();
        Iterator entryIterator = TagNodes.RAW_TAG_DATA_MAP.getOrDefault(this.f_13449_, Collections.emptyMap()).entrySet().iterator();
        if (!entryIterator.hasNext()) {
            return;
        }
        while (entryIterator.hasNext()) {
            ResourceLocation tagLoc;
            Map.Entry entry = entryIterator.next();
            Tag tag = (Tag)entry.getKey();
            entryIterator.remove();
            if (registry == null || (tagLoc = (ResourceLocation)inverseMap.get(tag)) == null) continue;
            TagNodes.RawTagData rawTagData = (TagNodes.RawTagData)entry.getValue();
            IntArrayList elements = new IntArrayList();
            for (ResourceLocation element : rawTagData.otherElements()) {
                Object t = registry.m_7745_(element);
                if (t == null) continue;
                elements.add(registry.m_7447_(t));
            }
            tagDataMap.put(tagLoc, new TagNodes.TagData((IntList)elements, rawTagData.otherTags()));
        }
        InternalLogger.getInstance().debug("Processed %d tags in %s for %s", tagDataMap.size(), stopwatch.stop(), resourceKey.m_135782_());
    }
}

