/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.client.view.Views;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIFocus;
import me.shedaniel.rei.jeicompat.wrap.JEIFocusGroup;
import me.shedaniel.rei.jeicompat.wrap.JEIIngredients;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeLayoutBuilder;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedCategory;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;

public class JEIWrappedDisplay<T>
implements Display {
    private final JEIWrappedCategory<T> backingCategory;
    private final T backingRecipe;
    private List<EntryIngredient> compiledInput;
    private List<EntryIngredient> compiledOutputs;
    private JEIIngredients ingredients = null;

    public JEIWrappedDisplay(JEIWrappedCategory<T> backingCategory, T backingRecipe) {
        this.backingCategory = backingCategory;
        this.backingRecipe = backingRecipe;
        this.cache();
    }

    public void cache() {
        JEIRecipeLayoutBuilder builder = new JEIRecipeLayoutBuilder(null);
        IRecipeCategory<T> category = this.getBackingCategory().getBackingCategory();
        category.setRecipe((IRecipeLayoutBuilder)builder, this.getBackingRecipe(), JEIWrappedDisplay.getFoci());
        if (builder.isDirty()) {
            this.compiledInput = CollectionUtils.filterAndMap(builder.slots, role -> role.role == RecipeIngredientRole.INPUT || role.role == RecipeIngredientRole.CATALYST, slot -> EntryIngredient.of(slot.slot.getEntries()));
            this.compiledOutputs = CollectionUtils.filterAndMap(builder.slots, role -> role.role == RecipeIngredientRole.OUTPUT, slot -> EntryIngredient.of(slot.slot.getEntries()));
            return;
        }
        this.ingredients = new JEIIngredients();
        this.backingCategory.getBackingCategory().setIngredients(this.backingRecipe, this.ingredients);
        this.compiledInput = new ArrayList<EntryIngredient>();
        this.compiledOutputs = new ArrayList<EntryIngredient>();
        this.ingredients.compileIngredients(this.compiledInput, this.compiledOutputs);
    }

    public IIngredients getLegacyIngredients() {
        return this.ingredients;
    }

    public JEIWrappedCategory<T> getBackingCategory() {
        return this.backingCategory;
    }

    public T getBackingRecipe() {
        return this.backingRecipe;
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return this.backingCategory.getCategoryIdentifier();
    }

    public static IFocusGroup getFoci() {
        ViewSearchBuilder context = Views.getInstance().getContext();
        if (context != null) {
            ArrayList foci = new ArrayList();
            for (EntryStack<?> stack : context.getUsagesFor()) {
                if (stack == null || stack.isEmpty()) continue;
                foci.add(new JEIFocus(RecipeIngredientRole.INPUT, JEIPluginDetector.typedJeiValue(stack)));
            }
            for (EntryStack<?> stack : context.getRecipesFor()) {
                if (stack == null || stack.isEmpty()) continue;
                foci.add(new JEIFocus(RecipeIngredientRole.OUTPUT, JEIPluginDetector.typedJeiValue(stack)));
            }
            return new JEIFocusGroup(foci);
        }
        if (Minecraft.m_91087_().f_91080_ instanceof DisplayScreen) {
            ArrayList foci = new ArrayList();
            DisplayScreen screen = (DisplayScreen)Minecraft.m_91087_().f_91080_;
            List<EntryStack<?>> notice = screen.getIngredientsToNotice();
            for (EntryStack<?> stack : notice) {
                if (stack == null || stack.isEmpty()) continue;
                foci.add(new JEIFocus(RecipeIngredientRole.INPUT, JEIPluginDetector.typedJeiValue(stack)));
            }
            notice = screen.getResultsToNotice();
            for (EntryStack<?> stack : notice) {
                if (stack == null || stack.isEmpty()) continue;
                foci.add(new JEIFocus(RecipeIngredientRole.OUTPUT, JEIPluginDetector.typedJeiValue(stack)));
            }
            return new JEIFocusGroup(foci);
        }
        return JEIFocusGroup.EMPTY;
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return this.compiledInput != null ? this.compiledInput : Collections.emptyList();
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return this.compiledOutputs != null ? this.compiledOutputs : Collections.emptyList();
    }

    @Override
    public Optional<ResourceLocation> getDisplayLocation() {
        if (this.backingRecipe instanceof Recipe) {
            return Optional.ofNullable(((Recipe)this.backingRecipe).m_6423_());
        }
        return Optional.empty();
    }
}

