/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIIngredientManager;
import me.shedaniel.rei.jeicompat.wrap.JEIIngredientVisibility;
import me.shedaniel.rei.jeicompat.wrap.JEIJeiHelpers;
import me.shedaniel.rei.jeicompat.wrap.JEIVanillaRecipeFactory;
import me.shedaniel.rei.plugin.client.BuiltinClientPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IIngredientVisibility;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class JEIRecipeRegistration
implements IRecipeRegistration {
    private final List<Runnable> post;

    public JEIRecipeRegistration(List<Runnable> post) {
        this.post = post;
    }

    @Override
    @NotNull
    public IJeiHelpers getJeiHelpers() {
        return JEIJeiHelpers.INSTANCE;
    }

    @Override
    @NotNull
    public IIngredientManager getIngredientManager() {
        return JEIIngredientManager.INSTANCE;
    }

    @Override
    @NotNull
    public IVanillaRecipeFactory getVanillaRecipeFactory() {
        return JEIVanillaRecipeFactory.INSTANCE;
    }

    @Override
    public IIngredientVisibility getIngredientVisibility() {
        return JEIIngredientVisibility.INSTANCE;
    }

    @Override
    public void addRecipes(@NotNull Collection<?> recipes, @NotNull ResourceLocation categoryId) {
        this.post.add(() -> JEIRecipeRegistration.addRecipes0(recipes, categoryId));
    }

    public static void addRecipes0(@NotNull Collection<?> recipes, @NotNull ResourceLocation categoryId) {
        CategoryIdentifier categoryIdentifier = CategoryIdentifier.of(categoryId);
        DisplayRegistry registry = DisplayRegistry.getInstance();
        if (recipes instanceof List && recipes.size() >= 100) {
            JEIRecipeRegistration.addRecipesOptimized((List)recipes, categoryIdentifier, registry);
            return;
        }
        for (Object recipe : recipes) {
            Collection<Display> displays = registry.tryFillDisplay(recipe);
            if (displays.isEmpty()) {
                InternalLogger.getInstance().warn("No displays found for recipe: %s for category %s", recipe, categoryId);
                return;
            }
            boolean registered = false;
            for (Display display : displays) {
                if (!Objects.equals(display.getCategoryIdentifier(), categoryIdentifier)) continue;
                registry.add(display, recipe);
                registered = true;
            }
            if (registered) continue;
            InternalLogger.getInstance().warn("No displays matched category for recipe: %s for category %s", recipe, categoryId);
        }
    }

    @Override
    public <T> void addRecipes(RecipeType<T> recipeType, List<T> recipes) {
        this.addRecipes(recipes, recipeType.getUid());
    }

    private static void addRecipesOptimized(List<Object> recipes, @NotNull CategoryIdentifier<?> categoryId, DisplayRegistry registry) {
        ArrayList completableFutures = Lists.newArrayList();
        Function<Object, Supplier> tryFillDisplay = o -> {
            try {
                Collection<Display> displays = registry.tryFillDisplay(o);
                return () -> displays;
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof ConcurrentModificationException) {
                    InternalLogger.getInstance().debug("Failed to parallelize recipe: %s for category %s", o, categoryId);
                    return () -> registry.tryFillDisplay(o);
                }
                throw e;
            }
        };
        CollectionUtils.partition(recipes, 50).forEach(list -> completableFutures.add(CompletableFuture.supplyAsync(() -> CollectionUtils.map(list, tryFillDisplay))));
        try {
            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get(120L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
        int i = 0;
        boolean contains = false;
        boolean registered = false;
        for (CompletableFuture future : completableFutures) {
            List displayCollection = future.getNow(null);
            if (displayCollection != null) {
                int j = 0;
                for (Supplier displays : displayCollection) {
                    Object origin = recipes.get(i * 50 + j);
                    for (Display display : (Collection)displays.get()) {
                        if (!Objects.equals(display.getCategoryIdentifier(), categoryId)) continue;
                        registry.add(display, origin);
                        registered = true;
                    }
                }
                if (displayCollection.size() > 0) {
                    contains = true;
                }
            }
            ++i;
        }
        if (!contains) {
            InternalLogger.getInstance().warn("No displays found for recipes: %s for category %s", recipes.stream().map(Objects::toString).collect(Collectors.joining(", ")), categoryId);
        } else if (!registered) {
            InternalLogger.getInstance().warn("No displays matched category for recipes: %s for category %s", recipes.stream().map(Objects::toString).collect(Collectors.joining(", ")), categoryId);
        }
    }

    @Override
    public <T> void addIngredientInfo(@NotNull T ingredient, @NotNull IIngredientType<T> ingredientType, Component ... descriptionComponents) {
        EntryStack<T> stack = JEIPluginDetector.unwrapStack(ingredient, ingredientType);
        BuiltinClientPlugin.getInstance().registerInformation(stack, stack.asFormattedText(), components -> {
            Collections.addAll(components, descriptionComponents);
            return components;
        });
    }

    @Override
    public <T> void addIngredientInfo(@NotNull List<T> ingredients, @NotNull IIngredientType<T> ingredientType, Component ... descriptionComponents) {
        EntryIngredient ingredient = JEIPluginDetector.unwrapList(ingredientType, ingredients);
        BuiltinClientPlugin.getInstance().registerInformation(ingredient, (Component)ImmutableTextComponent.EMPTY, components -> {
            Collections.addAll(components, descriptionComponents);
            return components;
        });
    }
}

