/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.shedaniel.math.Point;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.jeicompat.wrap.JEIDisplaySetup;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeSlot;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.recipe.RecipeIngredientRole;

public class JEIRecipeLayoutBuilder
implements IRecipeLayoutBuilder {
    private final JEIDisplaySetup.ShapelessData shapelessData;
    private boolean dirty = false;
    public Predicate<RecipeIngredientRole> rolePredicate;
    public List<JEIRecipeSlot> slots = new ArrayList<JEIRecipeSlot>();

    public JEIRecipeLayoutBuilder(JEIDisplaySetup.ShapelessData shapelessData) {
        this.shapelessData = shapelessData;
    }

    @Override
    public IRecipeSlotBuilder addSlot(RecipeIngredientRole role, int x, int y) {
        return this.addSlot(role, x, y, -1);
    }

    public IRecipeSlotBuilder addSlot(RecipeIngredientRole role, int x, int y, int index) {
        if (index == -1) {
            index = this.getNextId(this.slots.stream().map(JEIRecipeSlot::getIndex).filter(integer -> integer >= 0).collect(Collectors.toSet()));
        }
        JEIRecipeSlot slot = new JEIRecipeSlot(index, role, new Point(x, y));
        if (this.rolePredicate != null && !this.rolePredicate.test(role)) {
            return slot;
        }
        this.slots.add(slot);
        this.markDirty();
        return slot;
    }

    private int getNextId(Set<Integer> keys) {
        int i = 0;
        while (keys.contains(i)) {
            ++i;
        }
        return i;
    }

    @Override
    public IIngredientAcceptor<?> addInvisibleIngredients(RecipeIngredientRole role) {
        return this._addInvisibleIngredients(role);
    }

    public JEIRecipeSlot _addInvisibleIngredients(RecipeIngredientRole role) {
        JEIRecipeSlot slot = new JEIRecipeSlot(-1, role, null);
        if (this.rolePredicate != null && !this.rolePredicate.test(role)) {
            return slot;
        }
        this.slots.add(slot);
        this.markDirty();
        return slot;
    }

    @Override
    public void moveRecipeTransferButton(int posX, int posY) {
        this.markDirty();
    }

    @Override
    public void setShapeless() {
        if (this.shapelessData != null) {
            this.shapelessData.shapeless = true;
        }
        this.markDirty();
    }

    @Override
    public void setShapeless(int posX, int posY) {
        if (this.shapelessData != null) {
            this.shapelessData.shapeless = true;
            this.shapelessData.pos = new Point(posX, posY);
        }
        this.markDirty();
    }

    @Override
    public void createFocusLink(IRecipeSlotBuilder ... slots) {
        InternalLogger.getInstance().error("createFocusLink is not supported in REI yet!");
    }

    private void markDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

