/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

class JEIIngredients
implements IIngredients {
    private final Map<IIngredientType<?>, List<? extends List<?>>> inputs = new HashMap();
    private final Map<IIngredientType<?>, List<? extends List<?>>> outputs = new HashMap();

    JEIIngredients() {
    }

    @Override
    public void setInputIngredients(@NotNull List<Ingredient> inputs) {
        this.setInputLists((IIngredientType)VanillaTypes.ITEM, CollectionUtils.map(inputs, ingredient -> Arrays.asList(ingredient.m_43908_())));
    }

    public <R> void setInput(@NotNull IIngredientType<R> ingredientType, @NotNull R input) {
        List ingredient = this.inputs.computeIfAbsent(ingredientType, e -> new ArrayList());
        ingredient.add(Collections.singletonList(input));
    }

    public <R> void setInputs(@NotNull IIngredientType<R> ingredientType, @NotNull List<R> input) {
        List ingredient = this.inputs.computeIfAbsent(ingredientType, e -> new ArrayList());
        ingredient.addAll(CollectionUtils.map(input, Collections::singletonList));
    }

    public <R> void setInputLists(@NotNull IIngredientType<R> ingredientType, @NotNull List<List<R>> input) {
        List ingredient = this.inputs.computeIfAbsent(ingredientType, e -> new ArrayList());
        ingredient.addAll(input);
    }

    public <R> void setOutput(@NotNull IIngredientType<R> ingredientType, @NotNull R output) {
        List ingredient = this.outputs.computeIfAbsent(ingredientType, e -> new ArrayList());
        ingredient.add(Collections.singletonList(output));
    }

    public <R> void setOutputs(@NotNull IIngredientType<R> ingredientType, @NotNull List<R> output) {
        List ingredient = this.outputs.computeIfAbsent(ingredientType, e -> new ArrayList());
        ingredient.addAll(CollectionUtils.map(output, Collections::singletonList));
    }

    public <R> void setOutputLists(@NotNull IIngredientType<R> ingredientType, @NotNull List<List<R>> output) {
        List ingredient = this.outputs.computeIfAbsent(ingredientType, e -> new ArrayList());
        ingredient.addAll(output);
    }

    @NotNull
    public <R> List<List<R>> getInputs(@NotNull IIngredientType<R> ingredientType) {
        return this.inputs.getOrDefault(ingredientType, Collections.emptyList());
    }

    @NotNull
    public <R> List<List<R>> getOutputs(@NotNull IIngredientType<R> ingredientType) {
        return this.outputs.getOrDefault(ingredientType, Collections.emptyList());
    }

    public void compileIngredients(List<EntryIngredient> compiledInput, List<EntryIngredient> compiledOutputs) {
        for (Map.Entry<IIngredientType<?>, List<List<?>>> entry : this.inputs.entrySet()) {
            for (List<?> slot : entry.getValue()) {
                compiledInput.add(JEIPluginDetector.unwrapList(entry.getKey(), slot));
            }
        }
        for (Map.Entry<IIngredientType<?>, List<List<?>>> entry : this.outputs.entrySet()) {
            for (List<?> slot : entry.getValue()) {
                compiledOutputs.add(JEIPluginDetector.unwrapList(entry.getKey(), slot));
            }
        }
    }
}

