/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.config.entry.EntryStackProvider;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JEIIngredientFilter implements IIngredientFilter
{
    INSTANCE;


    @Override
    public void setFilterText(@NotNull String filterText) {
        REIRuntime.getInstance().getSearchTextField().setText(filterText);
    }

    @Override
    @NotNull
    public String getFilterText() {
        return REIRuntime.getInstance().getSearchTextField().getText();
    }

    @Override
    public <T> List<T> getFilteredIngredients(IIngredientType<T> ingredientType) {
        List<EntryStackProvider<?>> filteredStacks = ConfigObject.getInstance().getFilteredStackProviders();
        EntryType<T> type = JEIPluginDetector.unwrapType(ingredientType);
        Object[] filtered = (Object[])Array.newInstance(ingredientType.getIngredientClass(), filteredStacks.size());
        int i = 0;
        for (EntryStackProvider<?> provider : filteredStacks) {
            EntryStack<?> stack = provider.provide();
            if (stack.getType() != type || stack.isEmpty()) continue;
            filtered[i++] = JEIPluginDetector.jeiValue(stack.cast());
        }
        return ImmutableList.copyOf((Object[])Arrays.copyOf(filtered, i));
    }

    @Override
    public <V> boolean isIngredientVisible(V ingredient) {
        return this.isIngredientVisible(ingredient, null);
    }

    @Override
    public <V> boolean isIngredientVisible(V ingredient, @Nullable IIngredientHelper<V> ingredientHelper) {
        EntryStack<?> stack = ingredientHelper == null ? JEIPluginDetector.unwrapStack(ingredient) : JEIPluginDetector.unwrapStack(ingredient, JEIPluginDetector.unwrapDefinition(ingredientHelper.getIngredientType()));
        EntryRegistry registry = EntryRegistry.getInstance();
        if (!registry.alreadyContain(stack)) {
            return false;
        }
        Collection<EntryStack<?>> stacks = registry.refilterNew(false, Collections.singletonList(stack));
        return !stacks.isEmpty();
    }
}

