/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.mojang.blaze3d.vertex.PoseStack;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEICraftingGridHelper;
import me.shedaniel.rei.jeicompat.wrap.JEIDrawableBuilder;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public enum JEIGuiHelper implements IGuiHelper
{
    INSTANCE;


    @Override
    @NotNull
    public IDrawableBuilder drawableBuilder(@NotNull ResourceLocation resourceLocation, int u, int v, int width, int height) {
        return new JEIDrawableBuilder(resourceLocation, u, v, width, height);
    }

    @Override
    @NotNull
    public IDrawableAnimated createAnimatedDrawable(@NotNull IDrawableStatic drawable, int ticksPerCycle, @NotNull IDrawableAnimated.StartDirection startDirection, boolean inverted) {
        if (inverted) {
            if (startDirection == IDrawableAnimated.StartDirection.LEFT) {
                startDirection = IDrawableAnimated.StartDirection.RIGHT;
            } else if (startDirection == IDrawableAnimated.StartDirection.RIGHT) {
                startDirection = IDrawableAnimated.StartDirection.LEFT;
            } else if (startDirection == IDrawableAnimated.StartDirection.TOP) {
                startDirection = IDrawableAnimated.StartDirection.BOTTOM;
            } else if (startDirection == IDrawableAnimated.StartDirection.BOTTOM) {
                startDirection = IDrawableAnimated.StartDirection.TOP;
            }
        }
        int maxValue = startDirection == IDrawableAnimated.StartDirection.TOP || startDirection == IDrawableAnimated.StartDirection.BOTTOM ? drawable.getHeight() : drawable.getWidth();
        return this.createAnimatedDrawable(drawable, this.createTickTimer(ticksPerCycle, maxValue, !inverted), startDirection);
    }

    @NotNull
    public IDrawableAnimated createAnimatedDrawable(final @NotNull IDrawableStatic drawable, final ITickTimer timer, final @NotNull IDrawableAnimated.StartDirection startDirection) {
        return new IDrawableAnimated(){

            @Override
            public int getWidth() {
                return drawable.getWidth();
            }

            @Override
            public int getHeight() {
                return drawable.getHeight();
            }

            @Override
            public void draw(@NotNull PoseStack matrixStack, int xOffset, int yOffset) {
                int maskTop = 0;
                int maskBottom = 0;
                int maskLeft = 0;
                int maskRight = 0;
                switch (startDirection) {
                    case TOP: {
                        maskBottom = timer.getValue();
                        break;
                    }
                    case BOTTOM: {
                        maskTop = timer.getValue();
                        break;
                    }
                    case LEFT: {
                        maskRight = timer.getValue();
                        break;
                    }
                    case RIGHT: {
                        maskLeft = timer.getValue();
                    }
                }
                drawable.draw(matrixStack, xOffset, yOffset, maskTop, maskBottom, maskLeft, maskRight);
            }
        };
    }

    @Override
    @NotNull
    public IDrawableStatic getSlotDrawable() {
        final Panel base = Widgets.createSlotBase(new Rectangle(0, 0, 18, 18));
        return new IDrawableStatic(){

            @Override
            public void draw(@NotNull PoseStack matrixStack, int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
                base.getBounds().setLocation(xOffset, yOffset);
                base.m_6305_(matrixStack, PointHelper.getMouseX(), PointHelper.getMouseY(), 0.0f);
            }

            @Override
            public void draw(@NotNull PoseStack matrixStack, int xOffset, int yOffset) {
                this.draw(matrixStack, xOffset, yOffset, 0, 0, 0, 0);
            }

            @Override
            public int getWidth() {
                return base.getBounds().getWidth();
            }

            @Override
            public int getHeight() {
                return base.getBounds().getHeight();
            }
        };
    }

    @Override
    @NotNull
    public IDrawableStatic createBlankDrawable(final int width, final int height) {
        return new IDrawableStatic(){

            @Override
            public void draw(@NotNull PoseStack matrixStack, int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
            }

            @Override
            public void draw(@NotNull PoseStack matrixStack, int xOffset, int yOffset) {
            }

            @Override
            public int getWidth() {
                return width;
            }

            @Override
            public int getHeight() {
                return height;
            }
        };
    }

    @Override
    public <V> IDrawable createDrawableIngredient(IIngredientType<V> type, V ingredient) {
        final EntryStack<V> stack = JEIPluginDetector.unwrapStack(ingredient, type);
        return new IDrawable(){

            @Override
            public int getWidth() {
                return 16;
            }

            @Override
            public int getHeight() {
                return 16;
            }

            @Override
            public void draw(@NotNull PoseStack matrixStack, int xOffset, int yOffset) {
                stack.render(matrixStack, new Rectangle(xOffset, yOffset, this.getWidth(), this.getHeight()), PointHelper.getMouseX(), PointHelper.getMouseY(), 0.0f);
            }
        };
    }

    @Override
    @NotNull
    public <V> IDrawable createDrawableIngredient(@NotNull V ingredient) {
        final EntryStack<?> stack = JEIPluginDetector.unwrapStack(ingredient);
        return new IDrawable(){

            @Override
            public int getWidth() {
                return 16;
            }

            @Override
            public int getHeight() {
                return 16;
            }

            @Override
            public void draw(@NotNull PoseStack matrixStack, int xOffset, int yOffset) {
                stack.render(matrixStack, new Rectangle(xOffset, yOffset, this.getWidth(), this.getHeight()), PointHelper.getMouseX(), PointHelper.getMouseY(), 0.0f);
            }
        };
    }

    @Override
    @NotNull
    public ICraftingGridHelper createCraftingGridHelper(int craftInputSlot1) {
        return JEICraftingGridHelper.INSTANCE;
    }

    @Override
    @NotNull
    public ITickTimer createTickTimer(final int ticksPerCycle, final int maxValue, final boolean countDown) {
        return new ITickTimer(){

            @Override
            public int getValue() {
                float value = (float)(System.currentTimeMillis() % ((long)ticksPerCycle * 50L)) / ((float)ticksPerCycle * 50.0f);
                if (countDown) {
                    value = 1.0f - value;
                }
                return Math.round(value * (float)this.getMaxValue());
            }

            @Override
            public int getMaxValue() {
                return maxValue;
            }
        };
    }
}

