/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayCategoryView;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.unwrap.JEIUnwrappedCategory;
import me.shedaniel.rei.jeicompat.wrap.JEICraftingGridHelper;
import me.shedaniel.rei.jeicompat.wrap.JEIDisplaySetup;
import me.shedaniel.rei.jeicompat.wrap.JEIIngredients;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeLayout;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeLayoutBuilder;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeSlot;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedCategory;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedDisplay;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.extensions.IExtendableRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICustomCraftingCategoryExtension;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import org.jetbrains.annotations.Nullable;

public class JEIExtendableRecipeCategory<T, D extends Display, W extends IRecipeCategoryExtension>
extends JEIUnwrappedCategory<T, D>
implements IExtendableRecipeCategory<T, W> {
    private final JEIPluginDetector.JEIPluginWrapper wrapper;

    public JEIExtendableRecipeCategory(JEIPluginDetector.JEIPluginWrapper wrapper, DisplayCategory<D> backingCategory) {
        super(backingCategory);
        this.wrapper = wrapper;
    }

    @Override
    public <R extends T> void addCategoryExtension(Class<? extends R> recipeClass, Function<R, ? extends W> extensionFactory) {
        this.addCategoryExtension(recipeClass, $ -> true, extensionFactory);
    }

    @Override
    public <R extends T> void addCategoryExtension(Class<? extends R> recipeClass, Predicate<R> extensionFilter, Function<R, ? extends W> extensionFactory) {
        CategoryRegistry.getInstance().configure(this.getBackingCategory().getCategoryIdentifier().cast(), config -> config.registerExtension((display, category, lastView) -> {
            Object origin = DisplayRegistry.getInstance().getDisplayOrigin(display);
            if (recipeClass.isInstance(origin) && extensionFilter.test(origin)) {
                return new ExtendedCategoryView(this, origin, lastView, category, (IRecipeCategoryExtension)extensionFactory.apply(origin));
            }
            return lastView;
        }));
    }

    private static class ExtendedCategoryView<R>
    implements DisplayCategoryView<D> {
        private final R origin;
        private final DisplayCategoryView<D> lastView;
        private final DisplayCategory<D> category;
        private final W extension;
        final /* synthetic */ JEIExtendableRecipeCategory this$0;

        public ExtendedCategoryView(R origin, DisplayCategoryView<D> lastView, DisplayCategory<D> category, W extension) {
            this.this$0 = var1_1;
            this.origin = origin;
            this.lastView = lastView;
            this.category = category;
            this.extension = extension;
        }

        @Override
        public DisplayRenderer getDisplayRenderer(D display) {
            return this.lastView.getDisplayRenderer(display);
        }

        @Override
        public List<Widget> setupDisplay(D display, final Rectangle bounds) {
            ArrayList<Widget> widgets = new ArrayList<Widget>();
            if (this.category instanceof JEIWrappedCategory) {
                JEIDisplaySetup.Result result;
                try {
                    result = ExtendedCategoryView.createForExtension(this.extension, (JEIWrappedDisplay)display);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    widgets.add(Widgets.createRecipeBase(bounds).color(-65536));
                    widgets.add(Widgets.createLabel(new Point(bounds.getCenterX(), bounds.getCenterY() - 8), (Component)new TextComponent("Failed to initiate JEI integration setRecipe")));
                    widgets.add(Widgets.createLabel(new Point(bounds.getCenterX(), bounds.getCenterY() + 1), (Component)new TextComponent("Check console for error")));
                    return widgets;
                }
                widgets.addAll(JEIWrappedCategory.setupDisplay(result, ((JEIWrappedCategory)this.category).getBackingCategory(), (JEIWrappedDisplay)display, bounds, ((JEIWrappedCategory)this.category).background));
            } else if (this.extension instanceof ICraftingCategoryExtension) {
                JEIDisplaySetup.Result result;
                try {
                    result = ExtendedCategoryView.createCraftingForExtension((ICraftingCategoryExtension)this.extension);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    widgets.add(Widgets.createRecipeBase(bounds).color(-65536));
                    widgets.add(Widgets.createLabel(new Point(bounds.getCenterX(), bounds.getCenterY() - 8), (Component)new TextComponent("Failed to initiate JEI integration setRecipe")));
                    widgets.add(Widgets.createLabel(new Point(bounds.getCenterX(), bounds.getCenterY() + 1), (Component)new TextComponent("Check console for error")));
                    return widgets;
                }
                List<Widget> setupDisplay = this.lastView.setupDisplay(display, bounds);
                widgets.addAll(setupDisplay.stream().filter(widget -> !(widget instanceof Slot)).toList());
                for (Widget widget2 : setupDisplay) {
                    Slot slot;
                    if (!(widget2 instanceof Slot) || !(slot = (Slot)widget2).isBackgroundEnabled()) continue;
                    widgets.add(Widgets.createSlotBase(slot.getBounds()));
                }
                JEIDisplaySetup.addTo(widgets, bounds, result);
            } else {
                widgets.addAll(this.lastView.setupDisplay(display, bounds));
            }
            widgets.add(new WidgetWithBounds(){

                @Override
                public Rectangle getBounds() {
                    return bounds;
                }

                public void m_6305_(PoseStack arg, int i, int j, float f) {
                    Tooltip tooltip;
                    arg.m_85836_();
                    arg.m_85837_((double)(bounds.x + 4), (double)(bounds.y + 4), (double)this.getZ());
                    ExtendedCategoryView.this.extension.drawInfo(bounds.width, bounds.height, arg, i - bounds.x, j - bounds.y);
                    arg.m_85849_();
                    Point mouse = PointHelper.ofMouse();
                    if (this.containsMouse(mouse) && (tooltip = this.getTooltip(TooltipContext.of(mouse))) != null) {
                        tooltip.queue();
                    }
                }

                @Override
                @Nullable
                public Tooltip getTooltip(Point mouse) {
                    List<Component> strings = ExtendedCategoryView.this.extension.getTooltipStrings(mouse.x - bounds.x, mouse.y - bounds.y);
                    if (strings.isEmpty()) {
                        return null;
                    }
                    return Tooltip.create(mouse, strings);
                }

                public List<? extends GuiEventListener> m_6702_() {
                    return Collections.emptyList();
                }

                public boolean m_6375_(double d, double e, int i) {
                    return ExtendedCategoryView.this.extension.handleInput(d - (double)bounds.x, e - (double)bounds.y, InputConstants.Type.MOUSE.m_84895_(i)) || super.m_6375_(d, e, i);
                }

                public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
                    double e;
                    double d = PointHelper.getMouseFloatingX();
                    return ExtendedCategoryView.this.extension.handleInput(d - (double)bounds.x - 4.0, (e = PointHelper.getMouseFloatingY()) - (double)bounds.y - 4.0, InputConstants.m_84827_((int)keyCode, (int)scanCode)) || super.m_7933_(keyCode, scanCode, modifiers);
                }
            });
            return widgets;
        }

        public static <T> JEIDisplaySetup.Result createForExtension(IRecipeCategoryExtension category, JEIWrappedDisplay<T> display) {
            JEIDisplaySetup.Result result = new JEIDisplaySetup.Result();
            JEIRecipeLayoutBuilder builder = new JEIRecipeLayoutBuilder(result.shapelessData);
            JEIRecipeLayout layout = new JEIRecipeLayout(builder);
            IIngredients ingredients = display.getLegacyIngredients();
            if (ingredients != null) {
                category.setIngredients(ingredients);
                JEIDisplaySetup.applyLegacyTooltip(result, layout);
            }
            result.setSlots(builder.slots);
            return result;
        }

        public static <T> JEIDisplaySetup.Result createCraftingForExtension(ICraftingCategoryExtension category) {
            JEIDisplaySetup.Result result = new JEIDisplaySetup.Result();
            JEIRecipeLayoutBuilder builder = new JEIRecipeLayoutBuilder(result.shapelessData);
            category.setRecipe((IRecipeLayoutBuilder)builder, (ICraftingGridHelper)JEICraftingGridHelper.INSTANCE, JEIWrappedDisplay.getFoci());
            if (builder.isDirty()) {
                result.setSlots(builder.slots);
                return result;
            }
            if (category instanceof ICustomCraftingCategoryExtension) {
                ICustomCraftingCategoryExtension extension = (ICustomCraftingCategoryExtension)category;
                JEIRecipeLayout layout = new JEIRecipeLayout(builder);
                layout.getItemStacks().init(0, false, 107, 20);
                JEIIngredients ingredients = new JEIIngredients();
                extension.setIngredients(ingredients);
                extension.setRecipe(layout, ingredients);
                JEIDisplaySetup.applyLegacyTooltip(result, layout);
                result.setSlots(builder.slots);
                return result;
            }
            result.setSlots(new ArrayList<JEIRecipeSlot>());
            return result;
        }
    }
}

