/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import dev.architectury.fluid.FluidStack;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.jeicompat.ingredient.JEIGuiIngredientGroup;
import me.shedaniel.rei.jeicompat.wrap.JEIEntryDefinition;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeLayout;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeLayoutBuilder;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeSlot;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedDisplay;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;

public class JEIDisplaySetup {
    public static <T> Result create(IRecipeCategory<T> category, JEIWrappedDisplay<T> display, IFocusGroup focuses) {
        Result result = new Result();
        JEIRecipeLayoutBuilder builder = new JEIRecipeLayoutBuilder(result.shapelessData);
        category.setRecipe((IRecipeLayoutBuilder)builder, display.getBackingRecipe(), focuses);
        if (builder.isDirty()) {
            result.setSlots(builder.slots);
            return result;
        }
        JEIRecipeLayout layout = new JEIRecipeLayout(builder);
        IIngredients ingredients = display.getLegacyIngredients();
        if (ingredients != null) {
            category.setRecipe(layout, display.getBackingRecipe(), ingredients);
            JEIDisplaySetup.applyLegacyTooltip(result, layout);
        }
        result.setSlots(builder.slots);
        return result;
    }

    public static void applyLegacyTooltip(Result result, JEIRecipeLayout<?> layout) {
        for (JEIGuiIngredientGroup<?> group : layout.getGroups().values()) {
            for (JEIGuiIngredientGroup.SlotWrapper wrapper : group.getSlots().values()) {
                wrapper.slot.addTooltipCallback((recipeSlotView, tooltip) -> {
                    Optional ingredient = recipeSlotView.getDisplayedIngredient(group.getType());
                    if (ingredient.isPresent()) {
                        for (ITooltipCallback callback : group.tooltipCallbacks) {
                            callback.onTooltip(wrapper.index, wrapper.slot.role == RecipeIngredientRole.INPUT || wrapper.slot.role == RecipeIngredientRole.CATALYST, ingredient.get(), tooltip);
                        }
                    }
                });
            }
        }
    }

    public static void addTo(List<Widget> widgets, Rectangle bounds, Result result) {
        for (JEIRecipeSlot slot : result.slots) {
            RecipeIngredientRole role;
            if (!slot.isVisible()) continue;
            slot.slot.getBounds().translate(bounds.x + 4, bounds.y + 4);
            slot.slot.highlightEnabled(!slot.isEmpty());
            if (slot.background != null) {
                widgets.add(slot.background);
            }
            if ((role = slot.role) == RecipeIngredientRole.INPUT || role == RecipeIngredientRole.CATALYST) {
                slot.slot.markInput();
            } else if (role == RecipeIngredientRole.OUTPUT) {
                slot.slot.markOutput();
            }
            widgets.add(Widgets.withTranslate(slot.slot, 0.0, 0.0, 10.0));
            for (Map.Entry<EntryType<?>, IIngredientRenderer<?>> entry : slot.renderers.entrySet()) {
                EntryType<?> type = entry.getKey();
                JEIEntryDefinition.Renderer renderer = new JEIEntryDefinition.Renderer(entry.getValue());
                for (EntryStack<?> entry2 : slot.slot.getEntries()) {
                    if (entry2.getType() != type) continue;
                    ClientEntryStacks.setRenderer(entry2, renderer);
                }
            }
            if (slot.renderers.size() == 1) {
                IIngredientRenderer<?> renderer = slot.renderers.values().iterator().next();
                slot.slot.getBounds().setSize(renderer.getWidth() + 2, renderer.getHeight() + 2);
            }
            if (slot.capacityMb != null) {
                for (EntryStack entryStack : slot.slot.getEntries()) {
                    if (entryStack.getType() != VanillaEntryTypes.FLUID) continue;
                    ClientEntryStacks.setFluidRenderRatio(entryStack.cast(), (float)((FluidStack)entryStack.cast().getValue()).getAmount() / (float)slot.capacityMb.intValue());
                }
            }
            for (EntryStack entryStack : slot.slot.getEntries()) {
                if (entryStack.getType() != VanillaEntryTypes.FLUID) continue;
                entryStack.setting(EntryStack.Settings.FLUID_AMOUNT_VISIBLE, false);
            }
            if (slot.overlay != null) {
                widgets.add(slot.overlay);
            }
            for (EntryStack entryStack : slot.slot.getEntries()) {
                ClientEntryStacks.setTooltipProcessor(entryStack, (stack, tooltip) -> {
                    Object ingredient = null;
                    List<Component> components = CollectionUtils.filterAndMap(tooltip.entries(), Tooltip.Entry::isText, Tooltip.Entry::getAsText);
                    slot.tooltipCallback.onTooltip(slot, components);
                    tooltip.entries().removeIf(Tooltip.Entry::isText);
                    tooltip.addAllTexts(components);
                    return tooltip;
                });
            }
        }
    }

    public static class Result
    implements IRecipeSlotsView {
        public ShapelessData shapelessData = new ShapelessData();
        public List<JEIRecipeSlot> slots;
        public Map<RecipeIngredientRole, List<JEIRecipeSlot>> slotsRoled;

        @Override
        public List<IRecipeSlotView> getSlotViews() {
            return this.slots;
        }

        @Override
        public List<IRecipeSlotView> getSlotViews(RecipeIngredientRole role) {
            return this.slotsRoled.getOrDefault((Object)role, Collections.emptyList());
        }

        @Override
        public Optional<IRecipeSlotView> findSlotByName(String slotName) {
            return this.slots.stream().filter(slot -> Objects.equals(slot.getSlotName().orElse(null), slotName)).findFirst();
        }

        public void setSlots(List<JEIRecipeSlot> slots) {
            this.slots = slots;
            this.slotsRoled = slots.stream().collect(Collectors.groupingBy(JEIRecipeSlot::getRole));
        }
    }

    public static class ShapelessData {
        public boolean shapeless;
        public Point pos;
    }
}

