/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.unwrap;

import java.util.Objects;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class JEIIngredientHelper<T>
implements IIngredientHelper<T> {
    private final EntryDefinition<T> definition;

    public JEIIngredientHelper(EntryDefinition<T> definition) {
        this.definition = definition;
    }

    @Override
    public IIngredientType<T> getIngredientType() {
        return JEIPluginDetector.jeiType(this.definition);
    }

    @Override
    @Nullable
    public T getMatch(Iterable<T> ingredients, T ingredientToMatch, UidContext context) {
        ComparisonContext comparisonContext = JEIPluginDetector.unwrapContext(context);
        T value = JEIPluginDetector.unwrapStack(ingredientToMatch, this.definition).getValue();
        return (T)CollectionUtils.findFirstOrNull(ingredients, t -> this.definition.equals(JEIPluginDetector.unwrapStack(t, this.definition).getValue(), value, comparisonContext));
    }

    @Override
    public String getDisplayName(T ingredient) {
        EntryStack<T> entry = JEIPluginDetector.unwrapStack(ingredient, this.definition);
        return this.definition.asFormattedText(entry, entry.getValue(), TooltipContext.of()).getString();
    }

    @Override
    public String getUniqueId(T ingredient, UidContext context) {
        ComparisonContext comparisonContext = JEIPluginDetector.unwrapContext(context);
        EntryStack<T> entry = JEIPluginDetector.unwrapStack(ingredient, this.definition);
        return String.valueOf(EntryStacks.hash(entry, comparisonContext));
    }

    @Override
    public String getModId(T ingredient) {
        EntryStack<T> entry = JEIPluginDetector.unwrapStack(ingredient, this.definition);
        String ns = entry.getContainingNamespace();
        return ns == null ? "minecraft" : ns;
    }

    @Override
    public String getResourceId(T ingredient) {
        EntryStack<T> entry = JEIPluginDetector.unwrapStack(ingredient, this.definition);
        ResourceLocation location = entry.getIdentifier();
        return location == null ? "unknown" : location.m_135815_();
    }

    @Override
    public T copyIngredient(T ingredient) {
        EntryStack<T> entry = JEIPluginDetector.unwrapStack(ingredient, this.definition);
        return this.definition.copy(entry, entry.getValue());
    }

    @Override
    public String getErrorInfo(@Nullable T ingredient) {
        try {
            return Objects.toString(this.getResourceLocation(ingredient));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return throwable.getClass().getName() + ": " + throwable.getLocalizedMessage();
        }
    }
}

